/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.CraftingAltarMaterials;
import am2.api.IMultiblockStructureController;
import am2.api.SpellRegistry;
import am2.api.blocks.MultiblockGroup;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.blocks.TypedMultiblockGroup;
import am2.api.power.IPowerNode;
import am2.api.spell.AbstractSpellPart;
import am2.blocks.BlockLectern;
import am2.blocks.tileentity.ITileEntityAMBase;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.blocks.tileentity.TileEntityLectern;
import am2.blocks.tileentity.TileEntityOtherworldAura;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.spell.component.Summon;
import am2.spell.shape.Binding;
import am2.utils.KeyValuePair;
import am2.utils.NBTUtils;
import am2.utils.SpellUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCraftingAltar
extends TileEntityAMPower
implements IMultiblockStructureController,
ITileEntityAMBase {
    private MultiblockStructureDefinition primary = new MultiblockStructureDefinition("craftingAltar_alt");
    private MultiblockStructureDefinition secondary = new MultiblockStructureDefinition("craftingAltar");
    private TypedMultiblockGroup out;
    private TypedMultiblockGroup out_alt;
    private TypedMultiblockGroup catalysts;
    private TypedMultiblockGroup catalysts_alt;
    private HashMap<IBlockState, Integer> capsPower = new HashMap();
    private HashMap<IBlockState, Integer> structurePower = new HashMap();
    private static final int BLOCKID = 0;
    private static final int STAIR_NORTH = 1;
    private static final int STAIR_SOUTH = 2;
    private static final int STAIR_EAST = 3;
    private static final int STAIR_WEST = 4;
    private static final int STAIR_NORTH_INVERTED = 5;
    private static final int STAIR_SOUTH_INVERTED = 6;
    private static final int STAIR_EAST_INVERTED = 7;
    private static final int STAIR_WEST_INVERTED = 8;
    private boolean isCrafting;
    private final ArrayList<ItemStack> allAddedItems;
    private final ArrayList<ItemStack> currentAddedItems;
    private final ArrayList<AbstractSpellPart> spellDef;
    private final NBTTagCompound savedData = new NBTTagCompound();
    private final ArrayList<KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>> shapeGroups;
    private int currentKey = -1;
    private int checkCounter;
    private boolean structureValid;
    private BlockPos podiumLocation;
    private BlockPos switchLocation;
    private int maxEffects;
    private boolean dirty = false;
    private ItemStack addedPhylactery = null;
    private ItemStack addedBindingCatalyst = null;
    private ItemStack[] spellGuide;
    private int[] outputCombo;
    private int[][] shapeGroupGuide;
    private int currentConsumedPower = 0;
    private int ticksExisted = 0;
    private PowerTypes currentMainPowerTypes = PowerTypes.NONE;
    private static final byte CRAFTING_CHANGED = 1;
    private static final byte COMPONENT_ADDED = 2;
    private static final byte FULL_UPDATE = 3;
    private String currentSpellName = "";
    private IBlockState mimicState;

    public TileEntityCraftingAltar() {
        super(500);
        this.setupMultiblock();
        this.allAddedItems = new ArrayList();
        this.currentAddedItems = new ArrayList();
        this.isCrafting = false;
        this.structureValid = false;
        this.checkCounter = 0;
        this.setNoPowerRequests();
        this.maxEffects = 2;
        this.spellDef = new ArrayList();
        this.shapeGroups = new ArrayList();
        for (int i = 0; i < 5; ++i) {
            this.shapeGroups.add(new KeyValuePair(new ArrayList(), new NBTTagCompound()));
        }
    }

    private HashMap<Integer, IBlockState> createStateMap(IBlockState block, IBlockState stairs) {
        HashMap<Integer, IBlockState> map = new HashMap<Integer, IBlockState>();
        map.put(0, block);
        map.put(1, stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        map.put(2, stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        map.put(3, stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        map.put(4, stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        map.put(5, stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        map.put(6, stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        map.put(7, stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        map.put(8, stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        return map;
    }

    private void setupMultiblock() {
        ArrayList<HashMap<Integer, IBlockState>> structureMaterials = new ArrayList<HashMap<Integer, IBlockState>>();
        for (Map.Entry entry : CraftingAltarMaterials.getMainMap().entrySet()) {
            structureMaterials.add(this.createStateMap((IBlockState)((KeyValuePair)entry.getKey()).key, (IBlockState)((KeyValuePair)entry.getKey()).value));
            this.structurePower.put((IBlockState)((KeyValuePair)entry.getKey()).key, (int)((Integer)entry.getValue()));
        }
        ArrayList<HashMap<Integer, IBlockState>> capsMaterials = new ArrayList<HashMap<Integer, IBlockState>>();
        for (Map.Entry entry : CraftingAltarMaterials.getCapsMap().entrySet()) {
            HashMap capMat = new HashMap();
            capMat.put(0, entry.getKey());
            capsMaterials.add(capMat);
            this.capsPower.put((IBlockState)entry.getKey(), (int)((Integer)entry.getValue()));
        }
        this.catalysts = new TypedMultiblockGroup("catalysts", capsMaterials, false);
        this.out = new TypedMultiblockGroup("out", structureMaterials, false);
        this.catalysts.addBlock(new BlockPos(-1, 0, -2), 0);
        this.catalysts.addBlock(new BlockPos(1, 0, -2), 0);
        this.catalysts.addBlock(new BlockPos(-1, 0, 2), 0);
        this.catalysts.addBlock(new BlockPos(1, 0, 2), 0);
        this.catalysts.addBlock(new BlockPos(0, -4, 0), 0);
        this.out.addBlock(new BlockPos(-1, 0, -1), 3);
        this.out.addBlock(new BlockPos(-1, 0, 0), 3);
        this.out.addBlock(new BlockPos(-1, 0, 1), 3);
        this.out.addBlock(new BlockPos(1, 0, -1), 4);
        this.out.addBlock(new BlockPos(1, 0, 0), 4);
        this.out.addBlock(new BlockPos(1, 0, 1), 4);
        this.out.addBlock(new BlockPos(0, 0, -2), 2);
        this.out.addBlock(new BlockPos(0, 0, 2), 1);
        this.out.addBlock(new BlockPos(-1, -1, -1), 5);
        this.out.addBlock(new BlockPos(-1, -1, 1), 6);
        this.out.addBlock(new BlockPos(1, -1, -1), 5);
        this.out.addBlock(new BlockPos(1, -1, 1), 6);
        this.out.addBlock(new BlockPos(0, 0, -1), 0);
        this.out.addBlock(new BlockPos(0, 0, 1), 0);
        this.out.addBlock(new BlockPos(1, -1, -2), 0);
        this.out.addBlock(new BlockPos(1, -1, 2), 0);
        this.out.addBlock(new BlockPos(-1, -1, -2), 0);
        this.out.addBlock(new BlockPos(-1, -1, 2), 0);
        this.out.addBlock(new BlockPos(1, -2, -2), 0);
        this.out.addBlock(new BlockPos(1, -2, 2), 0);
        this.out.addBlock(new BlockPos(-1, -2, -2), 0);
        this.out.addBlock(new BlockPos(-1, -2, 2), 0);
        this.out.addBlock(new BlockPos(1, -3, -2), 0);
        this.out.addBlock(new BlockPos(1, -3, 2), 0);
        this.out.addBlock(new BlockPos(-1, -3, -2), 0);
        this.out.addBlock(new BlockPos(-1, -3, 2), 0);
        this.out.addBlock(new BlockPos(-2, -4, -2), 0);
        this.out.addBlock(new BlockPos(-2, -4, -1), 0);
        this.out.addBlock(new BlockPos(-2, -4, 0), 0);
        this.out.addBlock(new BlockPos(-2, -4, 1), 0);
        this.out.addBlock(new BlockPos(-2, -4, 2), 0);
        this.out.addBlock(new BlockPos(-1, -4, -2), 0);
        this.out.addBlock(new BlockPos(-1, -4, -1), 0);
        this.out.addBlock(new BlockPos(-1, -4, 0), 0);
        this.out.addBlock(new BlockPos(-1, -4, 1), 0);
        this.out.addBlock(new BlockPos(-1, -4, 2), 0);
        this.out.addBlock(new BlockPos(0, -4, -2), 0);
        this.out.addBlock(new BlockPos(0, -4, -1), 0);
        this.out.addBlock(new BlockPos(0, -4, 1), 0);
        this.out.addBlock(new BlockPos(0, -4, 2), 0);
        this.out.addBlock(new BlockPos(1, -4, -2), 0);
        this.out.addBlock(new BlockPos(1, -4, -1), 0);
        this.out.addBlock(new BlockPos(1, -4, 0), 0);
        this.out.addBlock(new BlockPos(1, -4, 1), 0);
        this.out.addBlock(new BlockPos(1, -4, 2), 0);
        this.out.addBlock(new BlockPos(2, -4, -2), 0);
        this.out.addBlock(new BlockPos(2, -4, -1), 0);
        this.out.addBlock(new BlockPos(2, -4, 0), 0);
        this.out.addBlock(new BlockPos(2, -4, 1), 0);
        this.out.addBlock(new BlockPos(2, -4, 2), 0);
        MultiblockGroup wall = new MultiblockGroup("wall", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.magicWall.func_176223_P()}), true);
        wall.addBlock(new BlockPos(0, -1, -2));
        wall.addBlock(new BlockPos(0, -2, -2));
        wall.addBlock(new BlockPos(0, -3, -2));
        wall.addBlock(new BlockPos(0, -1, 2));
        wall.addBlock(new BlockPos(0, -2, 2));
        wall.addBlock(new BlockPos(0, -3, 2));
        MultiblockGroup lever1 = new MultiblockGroup("lever1", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.EAST), Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.EAST).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true))}), false);
        MultiblockGroup lever2 = new MultiblockGroup("lever2", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.EAST), Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.EAST).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true))}), false);
        MultiblockGroup lever3 = new MultiblockGroup("lever3", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.WEST), Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.WEST).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true))}), false);
        MultiblockGroup lever4 = new MultiblockGroup("lever4", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.WEST), Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.WEST).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true))}), false);
        MultiblockGroup podium1 = new MultiblockGroup("podium1", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.lectern.func_176223_P().func_177226_a(BlockLectern.FACING, (Comparable)EnumFacing.EAST)}), false);
        MultiblockGroup podium2 = new MultiblockGroup("podium2", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.lectern.func_176223_P().func_177226_a(BlockLectern.FACING, (Comparable)EnumFacing.EAST)}), false);
        MultiblockGroup podium3 = new MultiblockGroup("podium3", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.lectern.func_176223_P().func_177226_a(BlockLectern.FACING, (Comparable)EnumFacing.WEST)}), false);
        MultiblockGroup podium4 = new MultiblockGroup("podium4", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.lectern.func_176223_P().func_177226_a(BlockLectern.FACING, (Comparable)EnumFacing.WEST)}), false);
        lever1.addBlock(new BlockPos(2, -2, 2));
        lever2.addBlock(new BlockPos(2, -2, -2));
        lever3.addBlock(new BlockPos(-2, -2, 2));
        lever4.addBlock(new BlockPos(-2, -2, -2));
        podium1.addBlock(new BlockPos(2, -3, 2));
        podium2.addBlock(new BlockPos(2, -3, -2));
        podium3.addBlock(new BlockPos(-2, -3, 2));
        podium4.addBlock(new BlockPos(-2, -3, -2));
        this.primary.addGroup(wall, new MultiblockGroup[0]);
        this.primary.addGroup(lever1, lever2, lever3, lever4);
        this.primary.addGroup(this.out, new MultiblockGroup[0]);
        this.primary.addGroup(this.catalysts, new MultiblockGroup[0]);
        this.primary.addGroup(podium1, podium2, podium3, podium4);
        this.catalysts_alt = new TypedMultiblockGroup("catalysts_alt", capsMaterials, false);
        this.out_alt = new TypedMultiblockGroup("out_alt", structureMaterials, false);
        MultiblockGroup wall_alt = new MultiblockGroup("wall_alt", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.magicWall.func_176223_P()}), true);
        wall_alt.addBlock(new BlockPos(-2, -1, 0));
        wall_alt.addBlock(new BlockPos(-2, -2, 0));
        wall_alt.addBlock(new BlockPos(-2, -3, 0));
        wall_alt.addBlock(new BlockPos(2, -1, 0));
        wall_alt.addBlock(new BlockPos(2, -2, 0));
        wall_alt.addBlock(new BlockPos(2, -3, 0));
        this.catalysts_alt.addBlock(new BlockPos(-2, 0, -1), 0);
        this.catalysts_alt.addBlock(new BlockPos(-2, 0, 1), 0);
        this.catalysts_alt.addBlock(new BlockPos(2, 0, -1), 0);
        this.catalysts_alt.addBlock(new BlockPos(2, 0, 1), 0);
        this.catalysts_alt.addBlock(new BlockPos(0, -4, 0), 0);
        this.out_alt.addBlock(new BlockPos(-1, 0, -1), 2);
        this.out_alt.addBlock(new BlockPos(0, 0, -1), 2);
        this.out_alt.addBlock(new BlockPos(1, 0, -1), 2);
        this.out_alt.addBlock(new BlockPos(-1, 0, 1), 1);
        this.out_alt.addBlock(new BlockPos(0, 0, 1), 1);
        this.out_alt.addBlock(new BlockPos(1, 0, 1), 1);
        this.out_alt.addBlock(new BlockPos(-2, 0, 0), 3);
        this.out_alt.addBlock(new BlockPos(2, 0, 0), 4);
        this.out_alt.addBlock(new BlockPos(-1, -1, -1), 8);
        this.out_alt.addBlock(new BlockPos(-1, -1, 1), 8);
        this.out_alt.addBlock(new BlockPos(1, -1, -1), 7);
        this.out_alt.addBlock(new BlockPos(1, -1, 1), 7);
        this.out_alt.addBlock(new BlockPos(-1, 0, 0), 0);
        this.out_alt.addBlock(new BlockPos(1, 0, 0), 0);
        this.out_alt.addBlock(new BlockPos(-2, -1, 1), 0);
        this.out_alt.addBlock(new BlockPos(2, -1, 1), 0);
        this.out_alt.addBlock(new BlockPos(-2, -1, -1), 0);
        this.out_alt.addBlock(new BlockPos(2, -1, -1), 0);
        this.out_alt.addBlock(new BlockPos(-2, -2, 1), 0);
        this.out_alt.addBlock(new BlockPos(2, -2, 1), 0);
        this.out_alt.addBlock(new BlockPos(-2, -2, -1), 0);
        this.out_alt.addBlock(new BlockPos(2, -2, -1), 0);
        this.out_alt.addBlock(new BlockPos(-2, -3, 1), 0);
        this.out_alt.addBlock(new BlockPos(2, -3, 1), 0);
        this.out_alt.addBlock(new BlockPos(-2, -3, -1), 0);
        this.out_alt.addBlock(new BlockPos(2, -3, -1), 0);
        this.out_alt.addBlock(new BlockPos(-2, -4, -2), 0);
        this.out_alt.addBlock(new BlockPos(-2, -4, -1), 0);
        this.out_alt.addBlock(new BlockPos(-2, -4, 0), 0);
        this.out_alt.addBlock(new BlockPos(-2, -4, 1), 0);
        this.out_alt.addBlock(new BlockPos(-2, -4, 2), 0);
        this.out_alt.addBlock(new BlockPos(-1, -4, -2), 0);
        this.out_alt.addBlock(new BlockPos(-1, -4, -1), 0);
        this.out_alt.addBlock(new BlockPos(-1, -4, 0), 0);
        this.out_alt.addBlock(new BlockPos(-1, -4, 1), 0);
        this.out_alt.addBlock(new BlockPos(-1, -4, 2), 0);
        this.out_alt.addBlock(new BlockPos(0, -4, -2), 0);
        this.out_alt.addBlock(new BlockPos(0, -4, -1), 0);
        this.out_alt.addBlock(new BlockPos(0, -4, 1), 0);
        this.out_alt.addBlock(new BlockPos(0, -4, 2), 0);
        this.out_alt.addBlock(new BlockPos(1, -4, -2), 0);
        this.out_alt.addBlock(new BlockPos(1, -4, -1), 0);
        this.out_alt.addBlock(new BlockPos(1, -4, 0), 0);
        this.out_alt.addBlock(new BlockPos(1, -4, 1), 0);
        this.out_alt.addBlock(new BlockPos(1, -4, 2), 0);
        this.out_alt.addBlock(new BlockPos(2, -4, -2), 0);
        this.out_alt.addBlock(new BlockPos(2, -4, -1), 0);
        this.out_alt.addBlock(new BlockPos(2, -4, 0), 0);
        this.out_alt.addBlock(new BlockPos(2, -4, 1), 0);
        this.out_alt.addBlock(new BlockPos(2, -4, 2), 0);
        MultiblockGroup lever1_alt = new MultiblockGroup("lever1_alt", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.SOUTH), Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.SOUTH).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true))}), false);
        MultiblockGroup lever2_alt = new MultiblockGroup("lever2_alt", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH), Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true))}), false);
        MultiblockGroup lever3_alt = new MultiblockGroup("lever3_alt", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.SOUTH), Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.SOUTH).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true))}), false);
        MultiblockGroup lever4_alt = new MultiblockGroup("lever4_alt", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH), Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true))}), false);
        MultiblockGroup podium1_alt = new MultiblockGroup("podium1_alt", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.lectern.func_176223_P().func_177226_a(BlockLectern.FACING, (Comparable)EnumFacing.SOUTH)}), false);
        MultiblockGroup podium2_alt = new MultiblockGroup("podium2_alt", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.lectern.func_176223_P().func_177226_a(BlockLectern.FACING, (Comparable)EnumFacing.NORTH)}), false);
        MultiblockGroup podium3_alt = new MultiblockGroup("podium3_alt", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.lectern.func_176223_P().func_177226_a(BlockLectern.FACING, (Comparable)EnumFacing.SOUTH)}), false);
        MultiblockGroup podium4_alt = new MultiblockGroup("podium4_alt", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.lectern.func_176223_P().func_177226_a(BlockLectern.FACING, (Comparable)EnumFacing.NORTH)}), false);
        lever1_alt.addBlock(new BlockPos(2, -2, 2));
        lever2_alt.addBlock(new BlockPos(2, -2, -2));
        lever3_alt.addBlock(new BlockPos(-2, -2, 2));
        lever4_alt.addBlock(new BlockPos(-2, -2, -2));
        podium1_alt.addBlock(new BlockPos(2, -3, 2));
        podium2_alt.addBlock(new BlockPos(2, -3, -2));
        podium3_alt.addBlock(new BlockPos(-2, -3, 2));
        podium4_alt.addBlock(new BlockPos(-2, -3, -2));
        this.secondary.addGroup(wall_alt, new MultiblockGroup[0]);
        this.secondary.addGroup(lever1_alt, lever2_alt, lever3_alt, lever4_alt);
        this.secondary.addGroup(this.out_alt, new MultiblockGroup[0]);
        this.secondary.addGroup(this.catalysts_alt, new MultiblockGroup[0]);
        this.secondary.addGroup(podium1_alt, podium2_alt, podium3_alt, podium4_alt);
        MultiblockGroup center = new MultiblockGroup("center", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.craftingAltar.func_176223_P()}), true);
        center.addBlock(new BlockPos(0, 0, 0));
        this.primary.addGroup(center, new MultiblockGroup[0]);
        this.secondary.addGroup(center, new MultiblockGroup[0]);
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.secondary;
    }

    public ItemStack getNextPlannedItem() {
        if (this.spellGuide != null) {
            if (this.allAddedItems.size() < this.spellGuide.length) {
                return this.spellGuide[this.allAddedItems.size()].func_77946_l();
            }
            return new ItemStack((Item)ItemDefs.spellParchment);
        }
        return null;
    }

    private int getNumPartsInSpell() {
        int parts = 0;
        if (this.outputCombo != null) {
            parts = this.outputCombo.length;
        }
        if (this.shapeGroupGuide != null) {
            for (int i = 0; i < this.shapeGroupGuide.length; ++i) {
                if (this.shapeGroupGuide[i] == null) continue;
                parts += this.shapeGroupGuide[i].length;
            }
        }
        return parts;
    }

    private boolean spellGuideIsWithinStructurePower() {
        return this.getNumPartsInSpell() <= this.maxEffects;
    }

    private boolean currentDefinitionIsWithinStructurePower() {
        int count = this.spellDef.size();
        for (KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> part : this.shapeGroups) {
            count += ((ArrayList)part.key).size();
        }
        return count <= this.maxEffects;
    }

    public boolean structureValid() {
        return this.structureValid;
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.ticksExisted;
        this.checkStructure();
        this.checkForStartCondition();
        this.updateLecternInformation();
        if (this.isCrafting) {
            this.checkForEndCondition();
            this.updatePowerRequestData();
            if (!this.field_145850_b.field_72995_K && !this.currentDefinitionIsWithinStructurePower() && this.ticksExisted > 100) {
                this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 5.0f, false, true);
                this.setCrafting(false);
                return;
            }
            if (this.field_145850_b.field_72995_K && this.checkCounter == 1) {
                ArsMagica2.proxy.particleManager.RibbonFromPointToPoint(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() - 2, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() - 3, (double)this.field_174879_c.func_177952_p() + 0.5);
            }
            List<EntityItem> components = this.lookForValidItems();
            ItemStack stack = this.getNextPlannedItem();
            for (EntityItem item : components) {
                if (item.field_70128_L) continue;
                ItemStack entityItemStack = item.func_92059_d();
                if (stack == null || !this.compareItemStacks(stack, entityItemStack)) continue;
                if (!this.field_145850_b.field_72995_K) {
                    this.updateCurrentRecipe(item);
                    item.func_70106_y();
                    continue;
                }
                for (int i = 0; i < 5 * ArsMagica2.config.getGFXLevel(); ++i) {
                    AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "radiant", item.field_70165_t, item.field_70163_u, item.field_70161_v));
                    if (particle == null) continue;
                    particle.func_187114_a(40);
                    particle.AddParticleController(new ParticleMoveOnHeading(particle, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.01f, 1, false));
                    particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
                    particle.setParticleScale(0.02f);
                    particle.setRGBColorF(this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat());
                }
            }
        }
        this.func_70296_d();
    }

    private void updateLecternInformation() {
        if (this.podiumLocation == null) {
            return;
        }
        TileEntityLectern lectern = (TileEntityLectern)this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)this.podiumLocation));
        if (lectern != null) {
            if (lectern.hasStack()) {
                ItemStack lecternStack = lectern.getStack();
                if (lecternStack.func_77942_o()) {
                    this.spellGuide = NBTUtils.getItemStackArray(lecternStack.func_77978_p(), "spell_combo");
                    this.outputCombo = lecternStack.func_77978_p().func_74759_k("output_combo");
                    this.currentSpellName = lecternStack.func_82833_r();
                    int numShapeGroups = lecternStack.func_77978_p().func_74762_e("numShapeGroups");
                    this.shapeGroupGuide = new int[numShapeGroups][];
                    for (int i = 0; i < numShapeGroups; ++i) {
                        this.shapeGroupGuide[i] = lecternStack.func_77978_p().func_74759_k("shapeGroupCombo_" + i);
                    }
                }
                if (this.isCrafting) {
                    if (this.spellGuide != null) {
                        lectern.setNeedsBook(false);
                        lectern.setTooltipStack(this.getNextPlannedItem());
                    } else {
                        lectern.setNeedsBook(true);
                    }
                } else {
                    lectern.setTooltipStack(null);
                }
                if (this.spellGuideIsWithinStructurePower()) {
                    lectern.setOverpowered(false);
                } else {
                    lectern.setOverpowered(true);
                }
            } else {
                if (this.isCrafting) {
                    lectern.setNeedsBook(true);
                }
                lectern.setTooltipStack(null);
            }
        }
    }

    public BlockPos getSwitchLocation() {
        return this.switchLocation;
    }

    public boolean switchIsOn() {
        if (this.switchLocation == null) {
            return false;
        }
        IBlockState block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177971_a((Vec3i)this.switchLocation));
        boolean b = false;
        if (block.func_177230_c() == Blocks.field_150442_at) {
            for (int i = 0; i < 6 && !(b |= ((Boolean)block.func_177229_b((IProperty)BlockLever.field_176359_b)).booleanValue()); ++i) {
            }
        }
        return b;
    }

    public void flipSwitch() {
        if (this.switchLocation == null) {
            return;
        }
        IBlockState block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177971_a((Vec3i)this.switchLocation));
        if (block.func_177230_c() == Blocks.field_150442_at) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177971_a((Vec3i)this.switchLocation), block.func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void updatePowerRequestData() {
        ItemStack stack = this.getNextPlannedItem();
        if (stack != null && stack.func_77973_b().equals(ItemDefs.etherium)) {
            if (this.switchIsOn()) {
                int flags = stack.func_77952_i();
                this.setPowerRequests();
                this.pickPowerType(stack);
                if (this.currentMainPowerTypes != PowerTypes.NONE && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.currentMainPowerTypes, 100.0f)) {
                    this.currentConsumedPower = (int)((float)this.currentConsumedPower + PowerNodeRegistry.For(this.field_145850_b).consumePower(this, this.currentMainPowerTypes, Math.min(100, stack.field_77994_a - this.currentConsumedPower)));
                }
                if (this.currentConsumedPower >= stack.field_77994_a) {
                    PowerNodeRegistry.For(this.field_145850_b).setPower(this, this.currentMainPowerTypes, 0.0f);
                    if (!this.field_145850_b.field_72995_K) {
                        this.addItemToRecipe(new ItemStack(ItemDefs.etherium, stack.field_77994_a, flags));
                    }
                    this.currentConsumedPower = 0;
                    this.currentMainPowerTypes = PowerTypes.NONE;
                    this.setNoPowerRequests();
                    this.flipSwitch();
                }
            } else {
                this.setNoPowerRequests();
            }
        } else {
            this.setNoPowerRequests();
        }
    }

    @Override
    protected void setNoPowerRequests() {
        this.currentConsumedPower = 0;
        this.currentMainPowerTypes = PowerTypes.NONE;
        super.setNoPowerRequests();
    }

    private void pickPowerType(ItemStack stack) {
        if (this.currentMainPowerTypes != PowerTypes.NONE) {
            return;
        }
        PowerTypes highestValid = PowerTypes.NONE;
        float amt = 0.0f;
        for (PowerTypes type : PowerTypes.all()) {
            float tmpAmt = PowerNodeRegistry.For(this.field_145850_b).getPower(this, type);
            if (!(tmpAmt > amt)) continue;
            highestValid = type;
        }
        this.currentMainPowerTypes = highestValid;
    }

    private void updateCurrentRecipe(EntityItem item) {
        ItemStack stack = item.func_92059_d();
        this.addItemToRecipe(stack);
    }

    private void addItemToRecipe(ItemStack stack) {
        this.allAddedItems.add(stack);
        this.currentAddedItems.add(stack);
        if (!this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_174879_c.func_177958_n());
            writer.add(this.field_174879_c.func_177956_o());
            writer.add(this.field_174879_c.func_177952_p());
            writer.add((byte)2);
            writer.add(stack);
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 32.0, (byte)4, writer.generate());
        }
        if (this.matchCurrentRecipe()) {
            this.currentAddedItems.clear();
            return;
        }
    }

    private boolean matchCurrentRecipe() {
        AbstractSpellPart part = SpellRegistry.getPartByRecipe(this.currentAddedItems);
        if (part == null) {
            return false;
        }
        KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> currentShapeGroupList = this.getShapeGroupToAddTo();
        if (part instanceof Summon) {
            this.handleSummonShape();
        }
        if (part instanceof Binding) {
            this.handleBindingShape();
        }
        if (currentShapeGroupList == null) {
            part.encodeBasicData(this.savedData, this.currentAddedItems.toArray());
            this.spellDef.add(part);
        } else {
            part.encodeBasicData((NBTTagCompound)currentShapeGroupList.value, this.currentAddedItems.toArray());
            ((ArrayList)currentShapeGroupList.key).add(part);
        }
        return true;
    }

    private KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> getShapeGroupToAddTo() {
        for (int i = 0; i < this.shapeGroupGuide.length; ++i) {
            int guideLength = this.shapeGroupGuide[i].length;
            int addedLength = ((ArrayList)this.shapeGroups.get((int)i).key).size();
            if (addedLength >= guideLength) continue;
            return this.shapeGroups.get(i);
        }
        return null;
    }

    private void handleSummonShape() {
        if (this.currentAddedItems.size() > 2) {
            this.addedPhylactery = this.currentAddedItems.get(this.currentAddedItems.size() - 2);
        }
    }

    private void handleBindingShape() {
        if (this.currentAddedItems.size() == 7) {
            this.addedBindingCatalyst = this.currentAddedItems.get(this.currentAddedItems.size() - 1);
        }
    }

    private List<EntityItem> lookForValidItems() {
        if (!this.isCrafting) {
            return new ArrayList<EntityItem>();
        }
        double radius = this.field_145850_b.field_72995_K ? 2.1 : 2.0;
        List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - radius, (double)(this.field_174879_c.func_177956_o() - 3), (double)this.field_174879_c.func_177952_p() - radius, (double)this.field_174879_c.func_177958_n() + radius, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + radius));
        return items;
    }

    private void checkStructure() {
        this.maxEffects = 0;
        if (this.checkCounter++ > 50) {
            this.checkCounter = 0;
        }
        if (this.primary.matches(this.field_145850_b, this.field_174879_c)) {
            for (MultiblockGroup matching : this.primary.getMatchingGroups(this.field_145850_b, this.field_174879_c)) {
                Integer toAdd;
                for (IBlockState state : matching.getStates()) {
                    if (state.func_177230_c().equals(Blocks.field_150442_at)) {
                        this.switchLocation = (BlockPos)matching.getPositions().get(0);
                        continue;
                    }
                    if (!state.func_177230_c().equals(BlockDefs.lectern)) continue;
                    this.podiumLocation = (BlockPos)matching.getPositions().get(0);
                }
                if (matching == this.catalysts || matching == this.catalysts_alt) {
                    toAdd = this.capsPower.get(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(4)));
                    this.maxEffects += toAdd != null ? toAdd : 0;
                    continue;
                }
                if (matching != this.out && matching != this.out_alt) continue;
                this.mimicState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(4).func_177974_f());
                toAdd = this.structurePower.get(this.mimicState);
                this.maxEffects += toAdd != null ? toAdd : 0;
            }
        } else if (this.secondary.matches(this.field_145850_b, this.field_174879_c)) {
            for (MultiblockGroup matching : this.secondary.getMatchingGroups(this.field_145850_b, this.field_174879_c)) {
                Object toAdd;
                for (IBlockState state : matching.getStates()) {
                    if (state.func_177230_c().equals(Blocks.field_150442_at)) {
                        this.switchLocation = (BlockPos)matching.getPositions().get(0);
                        continue;
                    }
                    if (!state.func_177230_c().equals(BlockDefs.lectern)) continue;
                    this.podiumLocation = (BlockPos)matching.getPositions().get(0);
                }
                if (matching == this.catalysts || matching == this.catalysts_alt) {
                    toAdd = this.capsPower.get(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(4)));
                    this.maxEffects += toAdd != null ? (Integer)toAdd : 0;
                    continue;
                }
                if (matching != this.out && matching != this.out_alt) continue;
                this.mimicState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(4).func_177974_f());
                toAdd = this.structurePower.get(this.mimicState);
                this.maxEffects += toAdd != null ? (Integer)toAdd : 0;
            }
        }
        this.setStructureValid(this.primary.matches(this.field_145850_b, this.field_174879_c) || this.secondary.matches(this.field_145850_b, this.field_174879_c));
    }

    private void checkForStartCondition() {
        EntityItem item;
        if (this.field_145850_b.field_72995_K || !this.structureValid || this.isCrafting) {
            return;
        }
        List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() + 2)));
        if (items.size() == 1 && (item = (EntityItem)items.get(0)) != null && !item.field_70128_L && item.func_92059_d().func_77973_b() == ItemDefs.blankRune) {
            item.func_70106_y();
            this.setCrafting(true);
        }
    }

    public IBlockState getMimicState() {
        return this.mimicState;
    }

    private void checkForEndCondition() {
        EntityItem item;
        if (!this.structureValid || !this.isCrafting || this.field_145850_b == null) {
            return;
        }
        double radius = this.field_145850_b.field_72995_K ? 2.2 : 2.0;
        List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - radius, (double)(this.field_174879_c.func_177956_o() - 3), (double)this.field_174879_c.func_177952_p() - radius, (double)this.field_174879_c.func_177958_n() + radius, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + radius));
        if (items.size() == 1 && (item = (EntityItem)items.get(0)) != null && !item.field_70128_L && item.func_92059_d() != null && item.func_92059_d().func_77973_b() == ItemDefs.spellParchment && !this.field_145850_b.field_72995_K) {
            item.func_70106_y();
            this.setCrafting(false);
            EntityItem craftedItem = new EntityItem(this.field_145850_b);
            craftedItem.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 1.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            ItemStack craftStack = SpellUtils.createSpellStack(this.shapeGroups, this.spellDef, this.savedData);
            if (!craftStack.func_77942_o()) {
                craftStack.func_77982_d(new NBTTagCompound());
            }
            this.AddSpecialMetadata(craftStack);
            craftStack.func_77978_p().func_74778_a("suggestedName", this.currentSpellName != null ? this.currentSpellName : "");
            if (this.getNextPlannedItem() == null || this.getNextPlannedItem().func_77973_b() != ItemDefs.spellParchment) {
                craftStack.func_77982_d(null);
            }
            craftedItem.func_92058_a(craftStack);
            this.field_145850_b.func_72838_d((Entity)craftedItem);
            this.allAddedItems.clear();
            this.currentAddedItems.clear();
        }
    }

    private void AddSpecialMetadata(ItemStack craftStack) {
    }

    private void setCrafting(boolean crafting) {
        this.isCrafting = crafting;
        if (!this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_174879_c.func_177958_n());
            writer.add(this.field_174879_c.func_177956_o());
            writer.add(this.field_174879_c.func_177952_p());
            writer.add((byte)1);
            writer.add(crafting);
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 32.0, (byte)4, writer.generate());
        }
        if (crafting) {
            IPowerNode<?>[] nodes;
            this.allAddedItems.clear();
            this.currentAddedItems.clear();
            this.spellDef.clear();
            this.shapeGroups.clear();
            for (int i = 0; i < 5; ++i) {
                this.shapeGroups.add(new KeyValuePair(new ArrayList(), new NBTTagCompound()));
            }
            for (IPowerNode<?> node : nodes = PowerNodeRegistry.For(this.field_145850_b).getAllNearbyNodes(this.field_145850_b, new Vec3d((Vec3i)this.field_174879_c), PowerTypes.DARK)) {
                if (!(node instanceof TileEntityOtherworldAura)) continue;
                ((TileEntityOtherworldAura)node).setActive(true, this);
                break;
            }
        }
    }

    private void setStructureValid(boolean valid) {
        if (this.structureValid == valid) {
            return;
        }
        this.structureValid = valid;
        this.func_70296_d();
    }

    public void deactivate() {
        if (!this.field_145850_b.field_72995_K) {
            this.setCrafting(false);
            for (ItemStack stack : this.allAddedItems) {
                if (stack.func_77973_b() == ItemDefs.etherium) continue;
                EntityItem eItem = new EntityItem(this.field_145850_b);
                eItem.func_70107_b((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p());
                eItem.func_92058_a(stack);
                this.field_145850_b.func_72838_d((Entity)eItem);
            }
            this.allAddedItems.clear();
        }
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    private boolean compareItemStacks(ItemStack target, ItemStack input) {
        boolean tagCheck = target.func_77978_p() == null ? true : (input.func_77978_p() == null ? false : NBTUtils.contains(target.func_77978_p(), input.func_77978_p()));
        return OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false) && tagCheck;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagCompound altarCompound = new NBTTagCompound();
        altarCompound.func_74757_a("isCrafting", this.isCrafting);
        altarCompound.func_74768_a("currentKey", this.currentKey);
        altarCompound.func_74778_a("currentSpellName", this.currentSpellName);
        altarCompound.func_74757_a("StructureValid", this.structureValid);
        if (this.mimicState != null) {
            altarCompound.func_74768_a("MimicState", Block.func_176210_f((IBlockState)this.mimicState));
        }
        NBTTagList allAddedItemsList = new NBTTagList();
        for (ItemStack itemStack : this.allAddedItems) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            itemStack.func_77955_b(nBTTagCompound);
            allAddedItemsList.func_74742_a((NBTBase)nBTTagCompound);
        }
        altarCompound.func_74782_a("allAddedItems", (NBTBase)allAddedItemsList);
        NBTTagList currentAddedItemsList = new NBTTagList();
        for (ItemStack itemStack : this.currentAddedItems) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            itemStack.func_77955_b(nBTTagCompound);
            currentAddedItemsList.func_74742_a((NBTBase)nBTTagCompound);
        }
        altarCompound.func_74782_a("currentAddedItems", (NBTBase)currentAddedItemsList);
        if (this.addedPhylactery != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            this.addedPhylactery.func_77955_b(nBTTagCompound);
            altarCompound.func_74782_a("phylactery", (NBTBase)nBTTagCompound);
        }
        if (this.addedBindingCatalyst != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            this.addedBindingCatalyst.func_77955_b(nBTTagCompound);
            altarCompound.func_74782_a("catalyst", (NBTBase)nBTTagCompound);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> keyValuePair : this.shapeGroups) {
            nBTTagList.func_74742_a((NBTBase)this.ISpellPartListToNBT(keyValuePair));
        }
        altarCompound.func_74782_a("shapeGroups", (NBTBase)nBTTagList);
        NBTTagCompound nBTTagCompound = this.ISpellPartListToNBT(new KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>(this.spellDef, this.savedData));
        altarCompound.func_74782_a("spellDef", (NBTBase)nBTTagCompound);
        nbttagcompound.func_74782_a("altarData", (NBTBase)altarCompound);
        return nbttagcompound;
    }

    private NBTTagCompound ISpellPartListToNBT(KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> spellDef2) {
        return SpellUtils.encode(spellDef2);
    }

    private KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> NBTToISpellPartList(NBTTagCompound compound) {
        return SpellUtils.decode(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        ItemStack stack;
        NBTTagCompound addedItem;
        int i;
        NBTTagCompound catalyst;
        NBTTagCompound phylactery;
        super.func_145839_a(nbttagcompound);
        if (!nbttagcompound.func_74764_b("altarData")) {
            return;
        }
        NBTTagCompound altarCompound = nbttagcompound.func_74775_l("altarData");
        this.mimicState = Block.func_176220_d((int)altarCompound.func_74762_e("MimicState"));
        NBTTagList allAddedItems = altarCompound.func_150295_c("allAddedItems", 10);
        NBTTagList currentAddedItems = altarCompound.func_150295_c("currentAddedItems", 10);
        this.structureValid = altarCompound.func_74767_n("StructureValid");
        this.isCrafting = altarCompound.func_74767_n("isCrafting");
        this.currentKey = altarCompound.func_74762_e("currentKey");
        this.currentSpellName = altarCompound.func_74779_i("currentSpellName");
        if (altarCompound.func_74764_b("phylactery") && (phylactery = altarCompound.func_74775_l("phylactery")) != null) {
            this.addedPhylactery = ItemStack.func_77949_a((NBTTagCompound)phylactery);
        }
        if (altarCompound.func_74764_b("catalyst") && (catalyst = altarCompound.func_74775_l("catalyst")) != null) {
            this.addedBindingCatalyst = ItemStack.func_77949_a((NBTTagCompound)catalyst);
        }
        this.allAddedItems.clear();
        for (i = 0; i < allAddedItems.func_74745_c(); ++i) {
            addedItem = allAddedItems.func_150305_b(i);
            if (addedItem == null || (stack = ItemStack.func_77949_a((NBTTagCompound)addedItem)) == null) continue;
            this.allAddedItems.add(stack);
        }
        this.currentAddedItems.clear();
        for (i = 0; i < currentAddedItems.func_74745_c(); ++i) {
            addedItem = currentAddedItems.func_150305_b(i);
            if (addedItem == null || (stack = ItemStack.func_77949_a((NBTTagCompound)addedItem)) == null) continue;
            this.currentAddedItems.add(stack);
        }
        this.spellDef.clear();
        for (KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> groups : this.shapeGroups) {
            ((ArrayList)groups.key).clear();
        }
        NBTTagCompound currentSpellDef = altarCompound.func_74775_l("spellDef");
        this.spellDef.addAll((Collection)this.NBTToISpellPartList((NBTTagCompound)currentSpellDef).key);
        this.savedData.func_179237_a((NBTTagCompound)this.NBTToISpellPartList((NBTTagCompound)currentSpellDef).value);
        NBTTagList currentShapeGroups = altarCompound.func_150295_c("shapeGroups", 10);
        for (int i2 = 0; i2 < currentShapeGroups.func_74745_c(); ++i2) {
            NBTTagCompound compound = currentShapeGroups.func_150305_b(i2);
            try {
                ((ArrayList)this.shapeGroups.get((int)i2).key).addAll((Collection)this.NBTToISpellPartList((NBTTagCompound)compound).key);
                ((NBTTagCompound)this.shapeGroups.get((int)i2).value).func_179237_a((NBTTagCompound)this.NBTToISpellPartList((NBTTagCompound)compound).value);
                continue;
            }
            catch (IndexOutOfBoundsException | NullPointerException e) {
                this.shapeGroups.add(i2, new KeyValuePair(new ArrayList(), new NBTTagCompound()));
                ((ArrayList)this.shapeGroups.get((int)i2).key).addAll((Collection)this.NBTToISpellPartList((NBTTagCompound)compound).key);
                ((NBTTagCompound)this.shapeGroups.get((int)i2).value).func_179237_a((NBTTagCompound)this.NBTToISpellPartList((NBTTagCompound)compound).value);
            }
        }
    }

    @Override
    public int getChargeRate() {
        return 250;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    public void HandleUpdatePacket(byte[] remainingBytes) {
        AMDataReader rdr = new AMDataReader(remainingBytes, false);
        byte subID = rdr.getByte();
        switch (subID) {
            case 3: {
                this.isCrafting = rdr.getBoolean();
                this.currentKey = rdr.getInt();
                this.allAddedItems.clear();
                this.currentAddedItems.clear();
                int itemCount = rdr.getInt();
                for (int i = 0; i < itemCount; ++i) {
                    this.allAddedItems.add(rdr.getItemStack());
                }
                break;
            }
            case 1: {
                this.setCrafting(rdr.getBoolean());
                break;
            }
            case 2: {
                this.allAddedItems.add(rdr.getItemStack());
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public void markForUpdate() {
        this.dirty = true;
    }

    @Override
    public boolean needsUpdate() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dirty = false;
    }
}

