/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.blocks.IKeystoneLockable;
import am2.blocks.BlockCalefactor;
import am2.blocks.tileentity.ITileEntityAMBase;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.defs.AMSounds;
import am2.defs.ItemDefs;
import am2.items.ItemFocusCharge;
import am2.items.ItemFocusMana;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;

public class TileEntityCalefactor
extends TileEntityAMPower
implements IInventory,
ISidedInventory,
IKeystoneLockable<TileEntityCalefactor>,
ITileEntityAMBase {
    private ItemStack[] calefactorItemStacks;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private float rotationStepX;
    private final short baseCookTime = (short)220;
    private short timeSpentCooking = 0;
    private final float basePowerConsumedPerTickCooking = 0.85f;
    private int particleCount = 0;
    private boolean isCooking = false;
    private boolean dirty = false;
    private static final byte PKT_PRG_UPDATE = 1;
    private boolean isFirstTick = true;

    public TileEntityCalefactor() {
        super(100);
        this.calefactorItemStacks = new ItemStack[this.func_70302_i_()];
    }

    @Override
    public float particleOffset(int axis) {
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCalefactor.FACING);
        if (axis == 0) {
            switch (facing) {
                case WEST: {
                    return 0.25f;
                }
                case EAST: {
                    return 0.75f;
                }
            }
            return 0.5f;
        }
        if (axis == 1) {
            switch (facing) {
                case UP: {
                    return 0.75f;
                }
                case DOWN: {
                    return 0.25f;
                }
            }
            return 0.5f;
        }
        if (axis == 2) {
            switch (facing) {
                case NORTH: {
                    return 0.25f;
                }
                case SOUTH: {
                    return 0.75f;
                }
            }
            return 0.5f;
        }
        return 0.5f;
    }

    public void incrementRotations() {
        this.rotationX += this.rotationStepX;
        this.rotationY += this.rotationStepX;
        this.rotationZ += this.rotationStepX;
        if (this.rotationX > 359.0f) {
            this.rotationX -= 360.0f;
        }
        if (this.rotationY > 359.0f) {
            this.rotationY -= 360.0f;
        }
        if (this.rotationZ > 359.0f) {
            this.rotationZ -= 360.0f;
        }
        if (this.rotationX < 0.0f) {
            this.rotationX += 360.0f;
        }
        if (this.rotationY < 0.0f) {
            this.rotationY += 360.0f;
        }
        if (this.rotationZ < 0.0f) {
            this.rotationZ += 360.0f;
        }
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationX;
    }

    public float getRotationZ() {
        return this.rotationX;
    }

    public ItemStack getItemBeingCooked() {
        if (this.calefactorItemStacks[0] != null) {
            return this.calefactorItemStacks[0];
        }
        return null;
    }

    private boolean canSmelt() {
        if (this.calefactorItemStacks[0] == null) {
            return false;
        }
        ItemStack var1 = FurnaceRecipes.func_77602_a().func_151395_a(this.calefactorItemStacks[0]);
        if (var1 == null) {
            return false;
        }
        if (this.calefactorItemStacks[1] == null) {
            return true;
        }
        if (!this.calefactorItemStacks[1].func_77969_a(var1)) {
            return false;
        }
        int result = this.calefactorItemStacks[1].field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            boolean doSmelt;
            ItemStack var1 = FurnaceRecipes.func_77602_a().func_151395_a(this.calefactorItemStacks[0]);
            ItemStack smeltStack = var1.func_77946_l();
            if ((this.calefactorItemStacks[0].func_77973_b() instanceof ItemFood || this.calefactorItemStacks[0].func_77973_b() instanceof ItemBlock || this.calefactorItemStacks[0].func_77973_b() == ItemDefs.itemOre) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.DARK, this.getCookTickPowerCost()) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.NEUTRAL, this.getCookTickPowerCost()) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.LIGHT, this.getCookTickPowerCost())) {
                ++smeltStack.field_77994_a;
            }
            if (this.calefactorItemStacks[0].func_77973_b() instanceof ItemFood && smeltStack.field_77994_a == var1.field_77994_a && this.field_145850_b.field_73012_v.nextDouble() < (double)0.15f) {
                ++smeltStack.field_77994_a;
            }
            if (doSmelt = true) {
                if (this.calefactorItemStacks[1] == null) {
                    this.calefactorItemStacks[1] = smeltStack.func_77946_l();
                } else if (this.calefactorItemStacks[1].func_77969_a(smeltStack)) {
                    this.calefactorItemStacks[1].field_77994_a += smeltStack.field_77994_a;
                    if (this.calefactorItemStacks[1].field_77994_a > this.calefactorItemStacks[1].func_77976_d()) {
                        this.calefactorItemStacks[1].field_77994_a = this.calefactorItemStacks[1].func_77976_d();
                    }
                }
                if (Math.random() <= 0.25) {
                    if (this.calefactorItemStacks[5] == null) {
                        this.calefactorItemStacks[5] = new ItemStack((Item)ItemDefs.itemOre, 1, 0);
                    } else {
                        ++this.calefactorItemStacks[5].field_77994_a;
                        if (this.calefactorItemStacks[5].field_77994_a > this.calefactorItemStacks[5].func_77976_d()) {
                            this.calefactorItemStacks[5].field_77994_a = this.calefactorItemStacks[5].func_77976_d();
                        }
                    }
                }
            }
            --this.calefactorItemStacks[0].field_77994_a;
            if (this.calefactorItemStacks[0].field_77994_a <= 0) {
                this.calefactorItemStacks[0] = null;
            }
        }
    }

    public void handlePacket(byte[] data) {
        if (this.field_145850_b.field_72995_K) {
            AMDataReader rdr = new AMDataReader(data);
            switch (rdr.ID) {
                case 1: {
                    boolean bl = this.isCooking = rdr.getByte() == 1;
                    if (rdr.getByte() == 1) {
                        this.calefactorItemStacks[0] = rdr.getItemStack();
                        break;
                    }
                    this.calefactorItemStacks[0] = null;
                    break;
                }
            }
        }
    }

    protected void sendCookStatusUpdate(boolean isCooking) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)1);
        writer.add(isCooking ? (byte)1 : 0);
        writer.add(this.calefactorItemStacks[0] != null ? (byte)1 : 0);
        if (this.calefactorItemStacks[0] != null) {
            writer.add(this.calefactorItemStacks[0]);
        }
        AMNetHandler.INSTANCE.sendCalefactorCookUpdate(this, writer.generate());
    }

    private short getModifiedCookTime() {
        int foci = this.numFociOfType(ItemFocusCharge.class);
        int base = 220;
        short modified = (short)((double)base * Math.pow(0.5, foci));
        return modified;
    }

    private float getCookTickPowerCost() {
        int fociMana = this.numFociOfType(ItemFocusMana.class);
        int fociCharge = this.numFociOfType(ItemFocusCharge.class);
        float base = 0.85f;
        return (float)((double)base * Math.pow(2.25, fociCharge) * Math.pow(0.5, fociMana));
    }

    private boolean isSmelting() {
        return this.timeSpentCooking != 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isFirstTick) {
            this.rotationStepX = this.field_145850_b.field_73012_v.nextFloat() * 0.03f - 0.015f;
            this.isFirstTick = false;
        }
        if (this.field_145850_b.field_72995_K) {
            this.incrementRotations();
            if (this.isCooking) {
                --this.particleCount;
                if (this.particleCount <= 0) {
                    this.particleCount = (int)(Math.random() * 20.0);
                    double rStartX = Math.random() > 0.5 ? (double)this.field_174879_c.func_177958_n() + 0.01 : (double)this.field_174879_c.func_177958_n() + 1.01;
                    double rStartY = (double)this.field_174879_c.func_177956_o() + 1.1;
                    double rStartZ = Math.random() > 0.5 ? (double)this.field_174879_c.func_177952_p() + 0.01 : (double)this.field_174879_c.func_177952_p() + 1.01;
                    double endX = (float)this.field_174879_c.func_177958_n() + 0.5f;
                    double endY = (double)((float)this.field_174879_c.func_177956_o() + 0.7f) + this.field_145850_b.field_73012_v.nextDouble() * 0.5;
                    double endZ = (float)this.field_174879_c.func_177952_p() + 0.5f;
                    ArsMagica2.proxy.particleManager.BeamFromPointToPoint(this.field_145850_b, rStartX, rStartY, rStartZ, endX, endY, endZ, 0xFF8811);
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "smoke", endX, endY, endZ));
                        if (effect != null) {
                            effect.setIgnoreMaxAge(false);
                            effect.func_187114_a(60);
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.02f, 0.01f, 1, false));
                        }
                    } else {
                        AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "explosion_2", endX, endY, endZ));
                        if (effect != null) {
                            effect.setIgnoreMaxAge(false);
                            effect.func_187114_a(10);
                            effect.setParticleScale(0.04f);
                            effect.addVelocity(this.field_145850_b.field_73012_v.nextDouble() * (double)0.2f - (double)0.1f, 0.2f, this.field_145850_b.field_73012_v.nextDouble() * (double)0.2f - (double)0.1f);
                            effect.setAffectedByGravity();
                            effect.setDontRequireControllers();
                        }
                    }
                }
            } else {
                this.particleCount = 0;
            }
        }
        boolean powerCheck = PowerNodeRegistry.For(this.field_145850_b).checkPower(this, this.getCookTickPowerCost());
        if (this.canSmelt() && this.isSmelting() && powerCheck) {
            this.timeSpentCooking = (short)(this.timeSpentCooking + 1);
            if (this.timeSpentCooking >= this.getModifiedCookTime()) {
                if (!this.field_145850_b.field_72995_K) {
                    this.smeltItem();
                } else {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), AMSounds.CALEFACTOR_BURN, SoundCategory.BLOCKS, 0.2f, 1.0f, true);
                }
                this.timeSpentCooking = 0;
                if (!this.field_145850_b.field_72995_K) {
                    this.sendCookStatusUpdate(false);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.DARK, this.getCookTickPowerCost()) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.NEUTRAL, this.getCookTickPowerCost()) && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.LIGHT, this.getCookTickPowerCost())) {
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.DARK, this.getCookTickPowerCost());
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.NEUTRAL, this.getCookTickPowerCost());
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.LIGHT, this.getCookTickPowerCost());
                } else {
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), this.getCookTickPowerCost());
                }
            }
        } else if (!this.isSmelting() && this.canSmelt() && powerCheck) {
            this.timeSpentCooking = 1;
            if (!this.field_145850_b.field_72995_K) {
                this.sendCookStatusUpdate(true);
            }
        } else if (!this.canSmelt()) {
            this.timeSpentCooking = 0;
        }
        this.func_70296_d();
    }

    public int getCookProgressScaled(int par1) {
        return this.timeSpentCooking * par1 / this.getModifiedCookTime();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    private int numFociOfType(Class<?> type) {
        int count = 0;
        for (int i = 2; i < this.func_70302_i_(); ++i) {
            if (this.calefactorItemStacks[i] == null || !type.isInstance(this.calefactorItemStacks[i].func_77973_b())) continue;
            ++count;
        }
        return count;
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70301_a(int var1) {
        if (var1 >= this.calefactorItemStacks.length) {
            return null;
        }
        return this.calefactorItemStacks[var1];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.calefactorItemStacks[i] != null) {
            if (this.calefactorItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.calefactorItemStacks[i];
                this.calefactorItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.calefactorItemStacks[i].func_77979_a(j);
            if (this.calefactorItemStacks[i].field_77994_a == 0) {
                this.calefactorItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.calefactorItemStacks[i] != null) {
            ItemStack itemstack = this.calefactorItemStacks[i];
            this.calefactorItemStacks[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.calefactorItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "Calefactor";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("CasterInventory", 10);
        this.calefactorItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.calefactorItemStacks.length) continue;
            this.calefactorItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.calefactorItemStacks.length; ++i) {
            if (this.calefactorItemStacks[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.calefactorItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("CasterInventory", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0;
    }

    public int[] func_180463_a(EnumFacing var1) {
        return new int[]{0, 1, 5};
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing j) {
        return i == 0;
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing j) {
        return i == 1 || i == 5;
    }

    @Override
    public int getChargeRate() {
        int numFoci = this.numFociOfType(ItemFocusCharge.class);
        int base = 20;
        if (numFoci > 0) {
            base += 27 * numFoci;
        }
        return base;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.calefactorItemStacks[6], this.calefactorItemStacks[7], this.calefactorItemStacks[8]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public void markForUpdate() {
        this.dirty = true;
    }

    @Override
    public boolean needsUpdate() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dirty = false;
    }
}

