/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.api.power.IPowerNode;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;

public abstract class TileEntityAMPower
extends TileEntity
implements IPowerNode<TileEntityAMPower>,
ITickable {
    protected int capacity;
    protected boolean canRequestPower = true;
    private int tickCounter;
    private static final int REQUEST_INTERVAL = 20;

    public TileEntityAMPower(int capacity) {
        this.capacity = capacity;
    }

    protected void setNoPowerRequests() {
        this.canRequestPower = false;
    }

    protected void setPowerRequests() {
        this.canRequestPower = true;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    public void func_145843_s() {
        PowerNodeRegistry.For(this.field_145850_b).removePowerNode(this);
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.canRequestPower() && this.tickCounter++ >= this.getRequestInterval()) {
            this.tickCounter = 0;
            List<PowerTypes> powerTypes = this.getValidPowerTypes();
            for (PowerTypes type : powerTypes) {
                float amtObtained = PowerNodeRegistry.For(this.field_145850_b).requestPower(this, type, this.getChargeRate());
                if (!(amtObtained > 0.0f)) continue;
                PowerNodeRegistry.For(this.field_145850_b).insertPower(this, type, amtObtained);
            }
        }
    }

    public int getRequestInterval() {
        return 20;
    }

    @Override
    public float particleOffset(int axis) {
        return 0.5f;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public void func_145834_a(World par1World) {
        super.func_145834_a(par1World);
        PowerNodeRegistry.For(this.field_145850_b).registerPowerNode(this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public float getCapacity() {
        return this.capacity;
    }

    public void setPower(PowerTypes type, float amount) {
        PowerNodeRegistry.For(this.field_145850_b).setPower(this, type, amount);
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return PowerTypes.all();
    }

    @Override
    public boolean canRequestPower() {
        return this.canRequestPower;
    }

    @Override
    public boolean isSource() {
        return false;
    }
}

