/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.defs.BlockDefs;
import am2.defs.CreativeTabsDefs;
import am2.items.ItemBlockSubtypes;
import am2.world.AM2FlowerGen;
import am2.world.WitchwoodTreeHuge;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockWitchwoodSapling
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);

    public BlockWitchwoodSapling() {
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabsDefs.tabAM2Blocks);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185850_c);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            int nearbyEssence = this.countNearbyEssencePools(worldIn, pos, rand);
            this.updateOrGrowTree(worldIn, pos, rand, nearbyEssence);
        }
    }

    private void updateOrGrowTree(World world, BlockPos pos, Random rand, int numNearbyPools) {
        if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockWitchwoodSapling)) {
            return;
        }
        if (rand.nextInt(7) == 0) {
            int meta = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)AGE) + numNearbyPools;
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(Math.min(meta, 15))));
            if (this.func_176473_a(world, pos, world.func_180495_p(pos), world.field_72995_K)) {
                this.func_176474_b(world, rand, pos, world.func_180495_p(pos));
            }
        }
    }

    private int countNearbyEssencePools(World world, BlockPos pos, Random rand) {
        int essenceNearby = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                IBlockState block = world.func_180495_p(pos.func_177982_a(i, -1, j));
                if (block != BlockDefs.liquid_essence.getBlock().func_176223_P()) continue;
                ++essenceNearby;
            }
        }
        return essenceNearby;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) == 15;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        WitchwoodTreeHuge generator = new WitchwoodTreeHuge(true);
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        if (!generator.func_180709_b(worldIn, rand, pos)) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(15)));
        } else {
            new AM2FlowerGen(BlockDefs.aum).func_180709_b(worldIn, rand, pos);
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public BlockWitchwoodSapling registerAndName(ResourceLocation rl) {
        this.func_149663_c(rl.toString());
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)rl);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockSubtypes((Block)this), (ResourceLocation)rl);
        return this;
    }
}

