/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.ArsMagica2;
import am2.blocks.BlockAMPowered;
import am2.blocks.tileentity.TileEntityManaBattery;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockManaBattery
extends BlockAMPowered {
    public BlockManaBattery() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityManaBattery te;
        if (!super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!worldIn.field_72995_K && (te = this.getTileEntity(worldIn, pos)) != null) {
            if (ArsMagica2.config.colourblindMode()) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(String.format("Charge Level: %.2f %% [%s]", Float.valueOf(PowerNodeRegistry.For(worldIn).getPower(te, te.getPowerType()) / te.getCapacity() * 100.0f), this.getColorNameFromPowerType(te.getPowerType()))));
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(String.format("Charge Level: %s%.2f \u00a7f%%", te.getPowerType().getChatColor(), Float.valueOf(PowerNodeRegistry.For(worldIn).getPower(te, te.getPowerType()) / te.getCapacity() * 100.0f))));
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityManaBattery();
    }

    private TileEntityManaBattery getTileEntity(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityManaBattery) {
            return (TileEntityManaBattery)te;
        }
        return null;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack != null) {
            TileEntityManaBattery te = this.getTileEntity(worldIn, pos);
            if (stack.func_77978_p() != null) {
                if (stack.func_77978_p().func_74764_b("mana_battery_charge") && stack.func_77978_p().func_74764_b("mana_battery_powertype")) {
                    PowerNodeRegistry.For(worldIn).setPower(te, PowerTypes.getByID(stack.func_77978_p().func_74762_e("mana_battery_powertype")), stack.func_77978_p().func_74760_g("mana_battery_charge"));
                } else {
                    te.setPowerType(PowerTypes.NONE, false);
                }
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        ItemStack stack = new ItemStack((Block)this, 1);
        drops.add(stack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityManaBattery && stack != null && PowerNodeRegistry.For((World)world).getPower((TileEntityManaBattery)te, ((TileEntityManaBattery)te).getPowerType()) != 0.0f) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74776_a("mana_battery_charge", PowerNodeRegistry.For((World)world).getPower((TileEntityManaBattery)te, ((TileEntityManaBattery)te).getPowerType()));
            stack.func_77978_p().func_74768_a("mana_battery_powertype", ((TileEntityManaBattery)te).getPowerType().ID());
        }
        return drops;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityManaBattery batt = this.getTileEntity(worldIn, pos);
        if (batt == null) {
            return 0;
        }
        float pct = PowerNodeRegistry.For(worldIn).getHighestPower(batt) / batt.getCapacity();
        return (int)Math.floor(15.0f * pct);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack stack = new ItemStack((Block)this);
        par3List.add(stack);
        for (PowerTypes type : PowerTypes.all()) {
            stack = new ItemStack((Block)this, 1, type.ID());
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74776_a("mana_battery_charge", new TileEntityManaBattery().getCapacity());
            stack.func_77978_p().func_74768_a("mana_battery_powertype", type.ID());
            par3List.add(stack);
        }
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

