/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.ArsMagica2;
import am2.blocks.BlockAM;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockInvisibleUtility
extends BlockAM {
    public static final PropertyEnum<EnumInvisibleType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumInvisibleType.class);

    public BlockInvisibleUtility() {
        super(Material.field_151592_s);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumInvisibleType.LOW_ILLUMINATED)));
    }

    public int func_149738_a(World par1World) {
        return 5;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (BlockInvisibleUtility.getType(state).type == EnumType.LIGHT) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return new AxisAlignedBB(pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumInvisibleType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumInvisibleType.values()[meta]));
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity) {
        if (entity == null || world == null || entity instanceof EntityPlayer) {
            return;
        }
        EnumInvisibleType meta = BlockInvisibleUtility.getType(state);
        double distanceThreshold = 1.1;
        double shortDistanceThreshold = 0.1;
        boolean isCollided = false;
        if ((double)entity.field_70130_N < 0.5 || (double)entity.field_70131_O < 0.5) {
            distanceThreshold = 0.5;
            shortDistanceThreshold = -0.2f;
        }
        if (meta.type == EnumType.COLLISION) {
            switch (meta) {
                case COLLISION_POSITIVE_X: {
                    if (!(entity.field_70165_t > (double)pos.func_177958_n() + distanceThreshold)) break;
                    collidingBoxes.add(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.25, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 1.25));
                    isCollided = true;
                    break;
                }
                case COLLISION_NEGATIVE_X: {
                    if (!(entity.field_70165_t < (double)pos.func_177958_n() - shortDistanceThreshold)) break;
                    collidingBoxes.add(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.25, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 1.25));
                    isCollided = true;
                    break;
                }
                case COLLISION_POSITIVE_Z: {
                    if (!(entity.field_70161_v > (double)pos.func_177952_p() + distanceThreshold)) break;
                    collidingBoxes.add(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.25, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 1.25));
                    isCollided = true;
                    break;
                }
                case COLLISION_NEGATIVE_Z: {
                    if (!(entity.field_70161_v < (double)pos.func_177952_p() - shortDistanceThreshold)) break;
                    collidingBoxes.add(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.25, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 1.25));
                    isCollided = true;
                    break;
                }
                case COLLISION_ALL_X: {
                    if (!(entity.field_70165_t > (double)pos.func_177958_n() + distanceThreshold) && !(entity.field_70165_t < (double)pos.func_177958_n() - shortDistanceThreshold)) break;
                    collidingBoxes.add(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.25, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 1.25));
                    isCollided = true;
                    break;
                }
                case COLLISION_ALL_Z: {
                    if (!(entity.field_70161_v > (double)pos.func_177952_p() + distanceThreshold) && !(entity.field_70161_v < (double)pos.func_177952_p() - shortDistanceThreshold)) break;
                    collidingBoxes.add(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.25, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 1.25));
                    isCollided = true;
                    break;
                }
                case COLLISION_ALL: {
                    collidingBoxes.add(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.25, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 1.25));
                    isCollided = true;
                }
            }
            if (world.field_72995_K && isCollided) {
                this.spawnBlockParticles(world, pos);
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.field_72995_K && BlockInvisibleUtility.getType(state).type == EnumType.COLLISION) {
            this.spawnBlockParticles(worldIn, pos);
        }
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private void spawnBlockParticles(World world, BlockPos pos) {
        AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "symbols", (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
        if (particle != null) {
            particle.addRandomOffset(1.0, 1.6, 1.0);
            particle.setParticleScale(0.1f);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.02f, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.func_187114_a(20);
            if (world.field_73012_v.nextBoolean()) {
                particle.setRGBColorI(4725704);
            } else {
                particle.setRGBColorI(8985544);
            }
        }
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return null;
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch (BlockInvisibleUtility.getType(state)) {
            case LOW_ILLUMINATED: {
                return 8;
            }
            case MED_ILLUMINATED: {
                return 12;
            }
            case HIGH_ILLUMINATED: 
            case SPECIAL_ILLUMINATED: {
                return 15;
            }
        }
        return 0;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            worldIn.func_180497_b(pos, (Block)this, this.func_149738_a(worldIn), 0);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (BlockInvisibleUtility.getType(state).type == EnumType.LIGHT) {
            float r = 1.5f;
            List ents = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_186662_g((double)r));
            boolean buffNearby = false;
            for (EntityLivingBase ent : ents) {
                buffNearby |= ent.func_70644_a(PotionEffectsDefs.illumination) || ent instanceof EntityPlayer && ((EntityPlayer)ent).field_71071_by.func_70448_g() != null && ((EntityPlayer)ent).field_71071_by.func_70448_g().func_77973_b() == ItemDefs.wardingCandle;
            }
            if (!buffNearby && world.func_180495_p(pos).func_177230_c() == this) {
                world.func_175698_g(pos);
            }
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 0);
        }
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        List ents;
        if (worldIn.field_73012_v.nextInt(10) < 3 && BlockInvisibleUtility.getType(stateIn).type == EnumType.COLLISION && (ents = worldIn.func_72872_a(Entity.class, new AxisAlignedBB(pos).func_186662_g((double)0.2f))).size() > 0) {
            this.spawnBlockParticles(worldIn, pos);
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return BlockInvisibleUtility.getType(world.func_180495_p(pos)).type == EnumType.COLLISION ? 100.0f : 0.0f;
    }

    public static EnumInvisibleType getType(IBlockState state) {
        return (EnumInvisibleType)((Object)state.func_177229_b(TYPE));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public BlockAM registerAndName(ResourceLocation rl) {
        this.func_149663_c(rl.toString());
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)rl);
        return this;
    }

    private static enum EnumType {
        LIGHT,
        COLLISION;

    }

    public static enum EnumInvisibleType implements IStringSerializable
    {
        LOW_ILLUMINATED(EnumType.LIGHT),
        MED_ILLUMINATED(EnumType.LIGHT),
        HIGH_ILLUMINATED(EnumType.LIGHT),
        COLLISION_POSITIVE_X(EnumType.COLLISION),
        COLLISION_NEGATIVE_X(EnumType.COLLISION),
        COLLISION_POSITIVE_Z(EnumType.COLLISION),
        COLLISION_NEGATIVE_Z(EnumType.COLLISION),
        COLLISION_ALL_X(EnumType.COLLISION),
        COLLISION_ALL_Z(EnumType.COLLISION),
        COLLISION_ALL(EnumType.COLLISION),
        SPECIAL_ILLUMINATED(EnumType.LIGHT);

        private final EnumType type;

        private EnumInvisibleType(EnumType type) {
            this.type = type;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

