/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.blocks.BlockAMContainer;
import am2.blocks.tileentity.TileEntityIllusionBlock;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.items.ItemBlockIllusion;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockIllusionBlock
extends BlockAMContainer {
    public static final PropertyEnum<EnumIllusionType> ILLUSION_TYPE = PropertyEnum.func_177709_a((String)"illusion_type", EnumIllusionType.class);

    public BlockIllusionBlock() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ILLUSION_TYPE, (Comparable)((Object)EnumIllusionType.DEFAULT)));
        this.func_149713_g(255);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ILLUSION_TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumIllusionType)((Object)state.func_177229_b(ILLUSION_TYPE))).ordinal();
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityIllusionBlock te = (TileEntityIllusionBlock)blockAccess.func_175625_s(pos);
        if (te != null && te.getMimicBlock() != null && te.getMimicBlock() != Blocks.field_150350_a.func_176223_P()) {
            return te.getMimicBlock().func_185894_c(blockAccess, pos, side);
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ILLUSION_TYPE, (Comparable)((Object)EnumIllusionType.values()[meta]));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityIllusionBlock();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70644_a(PotionEffectsDefs.trueSight)) {
            return;
        }
        if (BlockIllusionBlock.getIllusionType(state).isSolid()) {
            BlockIllusionBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d(worldIn, pos));
        }
    }

    public static EnumIllusionType getIllusionType(IBlockState state) {
        return (EnumIllusionType)((Object)state.func_177229_b(ILLUSION_TYPE));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public Object[] GetRecipeComponents(boolean alwaysPassable) {
        if (alwaysPassable) {
            return new Object[]{"BRB", "RGR", "BRB", Character.valueOf('R'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b()), Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('B'), new ItemStack((Item)ItemDefs.itemOre, 1, 2)};
        }
        return new Object[]{"BRB", "R R", "BRB", Character.valueOf('R'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b()), Character.valueOf('B'), new ItemStack((Item)ItemDefs.itemOre, 1, 2)};
    }

    public int GetCraftingQuantity() {
        return 4;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    @Override
    public BlockAMContainer registerAndName(ResourceLocation rl) {
        this.func_149663_c(rl.toString());
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)rl);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockIllusion((Block)this), (ResourceLocation)rl);
        return this;
    }

    public static enum EnumIllusionType implements IStringSerializable
    {
        DEFAULT(true, true),
        NON_COLLIDE(false, false);

        private final boolean isSolid;
        private final boolean canBeRevealed;

        private EnumIllusionType(boolean isSolid, boolean canBeRevealed) {
            this.isSolid = isSolid;
            this.canBeRevealed = canBeRevealed;
        }

        public boolean isSolid() {
            return this.isSolid;
        }

        public boolean canBeRevealed() {
            return this.canBeRevealed;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

