/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.ArsMagica2;
import am2.blocks.BlockAMPowered;
import am2.blocks.tileentity.TileEntityFlickerHabitat;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;

public class BlockFlickerHabitat
extends BlockAMPowered {
    public BlockFlickerHabitat() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(3.0f);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityFlickerHabitat();
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        if (heldItem != null && heldItem.func_77973_b() == ItemDefs.crystalWrench) {
            if (worldIn.field_72995_K) {
                playerIn.func_184609_a(hand);
            }
            return false;
        }
        FMLNetworkHandler.openGui((EntityPlayer)playerIn, (Object)ArsMagica2.instance, (int)13, (World)worldIn, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        return true;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.setBlockMode(worldIn, pos);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setBlockMode(worldIn, pos);
        super.func_176213_c(worldIn, pos, state);
    }

    protected void setBlockMode(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity ent = world.func_175625_s(pos);
        int habCount = 0;
        if (ent instanceof TileEntityFlickerHabitat) {
            TileEntityFlickerHabitat hab = (TileEntityFlickerHabitat)ent;
            for (EnumFacing direction : EnumFacing.values()) {
                Block block = world.func_180495_p(pos.func_177972_a(direction)).func_177230_c();
                TileEntity te = world.func_175625_s(pos.func_177972_a(direction));
                if (block != BlockDefs.elementalAttuner || te == null || !(te instanceof TileEntityFlickerHabitat)) continue;
                TileEntityFlickerHabitat foundHab = (TileEntityFlickerHabitat)te;
                if (!foundHab.isUpgrade()) {
                    if (++habCount == 1) {
                        hab.setUpgrade(true, direction);
                        continue;
                    }
                    world.func_175655_b(pos, true);
                    continue;
                }
                world.func_175655_b(pos, true);
            }
        }
    }

    public void onNeighborChange(IBlockAccess iblockaccess, BlockPos pos, BlockPos neighbor) {
        if (!(iblockaccess instanceof World)) {
            return;
        }
        World world = (World)iblockaccess;
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFlickerHabitat) {
            TileEntityFlickerHabitat hab = (TileEntityFlickerHabitat)te;
            if (hab.isUpgrade()) {
                int habCount = 0;
                for (EnumFacing direction : EnumFacing.values()) {
                    te = world.func_175625_s(pos.func_177972_a(direction));
                    if (te == null || !(te instanceof TileEntityFlickerHabitat)) continue;
                    TileEntityFlickerHabitat foundHab = (TileEntityFlickerHabitat)te;
                    if (!foundHab.isUpgrade()) {
                        if (++habCount == 1) continue;
                        world.func_175655_b(pos, true);
                        continue;
                    }
                    world.func_175655_b(pos, true);
                }
                if (habCount == 0) {
                    world.func_175655_b(pos, true);
                }
            } else {
                hab.scanForNearbyUpgrades();
                if (!hab.isUpgrade()) {
                    hab.scanForNearbyUpgrades();
                }
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityFlickerHabitat habitat = (TileEntityFlickerHabitat)worldIn.func_175625_s(pos);
        if (habitat == null) {
            return;
        }
        if (habitat.hasFlicker()) {
            ItemStack stack = habitat.func_70301_a(0);
            float offsetX = worldIn.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float offsetY = worldIn.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float offsetZ = worldIn.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float force = 0.05f;
            EntityItem entityItem = new EntityItem(worldIn, (double)((float)pos.func_177958_n() + offsetX), (double)((float)pos.func_177956_o() + offsetY), (double)((float)pos.func_177952_p() + offsetZ), stack);
            entityItem.field_70159_w = (float)worldIn.field_73012_v.nextGaussian() * force;
            entityItem.field_70181_x = (float)worldIn.field_73012_v.nextGaussian() * force + 0.2f;
            entityItem.field_70179_y = (float)worldIn.field_73012_v.nextGaussian() * force;
            worldIn.func_72838_d((Entity)entityItem);
        }
        if (!habitat.isUpgrade()) {
            for (EnumFacing direction : EnumFacing.values()) {
                TileEntityFlickerHabitat upgHab;
                TileEntity te = worldIn.func_175625_s(pos.func_177972_a(direction));
                if (te == null || !(te instanceof TileEntityFlickerHabitat) || !(upgHab = (TileEntityFlickerHabitat)te).isUpgrade()) continue;
                worldIn.func_175655_b(pos.func_177972_a(direction), true);
                worldIn.func_175690_a(pos.func_177972_a(direction), null);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

