/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.ArsMagica2;
import am2.blocks.BlockAMPowered;
import am2.blocks.tileentity.TileEntityEverstone;
import am2.defs.ItemDefs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEverstone
extends BlockAMPowered {
    public static final PropertyBool HAS_FACADE = PropertyBool.func_177716_a((String)"has_facade");
    public static final PropertyBool IS_SOLID = PropertyBool.func_177716_a((String)"is_solid");

    public BlockEverstone() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HAS_FACADE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)IS_SOLID, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HAS_FACADE, IS_SOLID});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityEverstone();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)world, pos);
        if (everstone == null) {
            if (player.field_71075_bZ.field_75098_d) {
                world.func_175690_a(pos, null);
                world.func_175698_g(pos);
                return true;
            }
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            everstone.onBreak();
        }
        if (player.field_71075_bZ.field_75098_d) {
            world.func_175690_a(pos, null);
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)world, pos);
        if (everstone != null) {
            everstone.onBreak();
        }
        return 10000.0f;
    }

    private TileEntityEverstone getTE(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        return (TileEntityEverstone)te;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_184614_ca() != null) {
            IBlockState block = null;
            TileEntityEverstone everstone = this.getTE((IBlockAccess)world, pos);
            if (everstone == null) {
                return false;
            }
            if (player.func_184614_ca().func_77973_b() == ItemDefs.crystalWrench) {
                if (!world.field_72995_K) {
                    if (everstone.getFacade() != null) {
                        everstone.setFacade(null);
                        return true;
                    }
                    world.func_175698_g(pos);
                    this.func_176226_b(world, pos, state, 0);
                    return true;
                }
            } else {
                if (player.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)this)) {
                    return true;
                }
                if (player.func_184614_ca().func_77973_b() instanceof ItemBlock) {
                    ItemBlock itemblock = (ItemBlock)player.func_184614_ca().func_77973_b();
                    block = itemblock.func_179223_d().func_176203_a(player.func_184614_ca().func_77952_i());
                }
            }
            if (everstone.getFacade() == null && block != null) {
                everstone.setFacade(block);
                world.func_180496_d(pos, (Block)this);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)IS_SOLID)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)HAS_FACADE)).booleanValue()) {
            return EnumBlockRenderType.MODEL;
        }
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)worldIn, pos);
        if (everstone == null || everstone.isSolid()) {
            return super.func_180646_a(blockState, worldIn, pos);
        }
        return field_185506_k;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)worldIn, pos);
        if (everstone == null || everstone.isSolid()) {
            return super.func_180640_a(state, worldIn, pos);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntityEverstone everstone = this.getTE(source, pos);
        if (everstone == null || everstone.isSolid()) {
            return super.func_185496_a(state, source, pos);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityEverstone everstone = this.getTE(world, pos);
        if (everstone == null) {
            return true;
        }
        return everstone.isSolid();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)worldIn, pos);
        if (everstone == null) {
            return this.field_149782_v;
        }
        IBlockState block = everstone.getFacade();
        if (block == null || block == this) {
            return this.field_149782_v;
        }
        return block.func_185887_b(worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)world, pos);
        for (int i = 0; i < 5 * ArsMagica2.config.getGFXLevel(); ++i) {
            IBlockState block;
            if (everstone == null || everstone.getFacade() == null) {
                block = this.func_176223_P();
            } else {
                block = everstone.getFacade();
                if (block == null) {
                    block = this.func_176223_P();
                }
            }
            manager.func_78873_a(new ParticleDigging.Factory().func_178902_a(0, world, (double)pos.func_177958_n() + world.field_73012_v.nextDouble(), (double)pos.func_177956_o() + world.field_73012_v.nextDouble(), (double)pos.func_177952_p() + world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)block)}));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        IBlockState block;
        TileEntityEverstone everstone = this.getTE((IBlockAccess)worldObj, target.func_178782_a());
        if (everstone == null || everstone.getFacade() == null) {
            block = this.func_176223_P();
        } else {
            block = everstone.getFacade();
            if (block == null) {
                block = this.func_176223_P();
            }
        }
        manager.func_78873_a(new ParticleDigging.Factory().func_178902_a(0, worldObj, (double)target.func_178782_a().func_177958_n() + worldObj.field_73012_v.nextDouble(), (double)target.func_178782_a().func_177956_o() + worldObj.field_73012_v.nextDouble(), (double)target.func_178782_a().func_177952_p() + worldObj.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)block)}));
        return true;
    }
}

