/*
 * Decompiled with CFR 0.152.
 */
package am2.asm;

import am2.LogHelper;
import am2.asm.Preloader;
import com.google.common.collect.Lists;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Transformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equalsIgnoreCase("net.minecraft.client.renderer.block.model.BlockPart$Deserializer")) {
            ClassReader cr = new ClassReader(basicClass);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            InsnList newInsn = new InsnList();
            newInsn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInsn.add((AbstractInsnNode)new LdcInsnNode((Object)"angle"));
            newInsn.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/util/JsonUtils", Preloader.isDevEnvironment ? "getFloat" : "func_151217_k", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)F", false));
            newInsn.add((AbstractInsnNode)new InsnNode(174));
            for (MethodNode mn : cn.methods) {
                if (!mn.name.equals("parseAngle") && !mn.name.equals("func_178255_b") || !mn.desc.equals("(Lcom/google/gson/JsonObject;)F")) continue;
                LogHelper.info("Core: Removing Model Rotation Limit...", new Object[0]);
                mn.instructions = newInsn;
            }
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        if (transformedName.equalsIgnoreCase("net.minecraft.client.renderer.EntityRenderer")) {
            return this.patchEntityRenderer(basicClass, !Preloader.isDevEnvironment);
        }
        if (transformedName.equalsIgnoreCase("net.minecraft.client.entity.EntityPlayerSP")) {
            return this.alterEntityPlayerSP(basicClass, !Preloader.isDevEnvironment);
        }
        if (transformedName.equalsIgnoreCase("net.minecraft.entity.EntityLivingBase")) {
            return this.alterEntityLivingBase(this.alterEntity(basicClass, !Preloader.isDevEnvironment), !Preloader.isDevEnvironment);
        }
        if (transformedName.equalsIgnoreCase("net.minecraft.entity.Entity")) {
            return this.alterEntity(basicClass, !Preloader.isDevEnvironment);
        }
        if (transformedName.equalsIgnoreCase("net.minecraft.entity.player.EntityPlayer")) {
            return this.alterEntityPlayer(basicClass, !Preloader.isDevEnvironment);
        }
        if (transformedName.equalsIgnoreCase("net.minecraftforge.client.model.obj.OBJModel$OBJBakedModel")) {
            return this.alterObjBakedModel(basicClass, !Preloader.isDevEnvironment);
        }
        if (transformedName.equalsIgnoreCase("net.minecraft.potion.PotionEffect")) {
            return this.alterPotionEffect(basicClass, !Preloader.isDevEnvironment);
        }
        return basicClass;
    }

    private byte[] alterPotionEffect(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        LogHelper.info("Located OBJBakedModel", new Object[0]);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("readCustomPotionEffectFromNBT") && !mn.name.equals("func_82722_b")) continue;
            ListIterator iter = mn.instructions.iterator();
            LogHelper.info("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            while (iter.hasNext()) {
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new LabelNode());
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "am2/api/event/PotionEvent$EventPotionLoaded", "post", "(Lnet/minecraft/potion/PotionEffect;Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/potion/PotionEffect;", false));
                AbstractInsnNode ain = (AbstractInsnNode)iter.next();
                if (ain == null || ain.getOpcode() != 176 || ain.getPrevious().getOpcode() == 1) continue;
                mn.instructions.insertBefore(ain, toAdd);
            }
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterObjBakedModel(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        LogHelper.info("Located OBJBakedModel", new Object[0]);
        block0: for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("buildQuads")) continue;
            ListIterator iter = mn.instructions.iterator();
            LogHelper.info("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            while (iter.hasNext()) {
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new LabelNode());
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 7));
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 6));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/client/model/obj/OBJModel$Face", "getMaterialName", "()Ljava/lang/String;", false));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "am2/api/event/OBJQuadEvent", "post", "(Ljava/lang/String;)I", false));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/client/model/pipeline/UnpackedBakedQuad$Builder", "setQuadTint", "(I)V", false));
                AbstractInsnNode ain = (AbstractInsnNode)iter.next();
                if (ain == null || !(ain instanceof MethodInsnNode) || ain.getOpcode() != 183 || !((MethodInsnNode)ain).owner.equalsIgnoreCase("net/minecraftforge/client/model/pipeline/UnpackedBakedQuad$Builder")) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                LogHelper.info("Located " + min.owner + " - " + min.name + min.desc, new Object[0]);
                if (!iter.hasNext()) continue block0;
                ain = (AbstractInsnNode)iter.next();
                if (ain == null || !(ain instanceof VarInsnNode) || ain.getOpcode() != 58 || ((VarInsnNode)ain).var != 7) continue;
                mn.instructions.insert(ain, toAdd);
                LogHelper.info("Adding colors to OBJ Models", new Object[0]);
                continue block0;
            }
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntity(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("getLook") && (!mn.name.equals("func_70676_i") || !mn.desc.equals("(F)Lnet/minecraft/util/math/Vec3d"))) continue;
            LogHelper.info("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            ListIterator iter = mn.instructions.iterator();
            while (iter.hasNext()) {
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "am2/utils/EntityUtils", "correctLook", "(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/Entity;)Lnet/minecraft/util/math/Vec3d;", false));
                AbstractInsnNode ain = (AbstractInsnNode)iter.next();
                if (ain == null || ain.getOpcode() != 176) continue;
                LogHelper.info("Core: Located target ARETURN insn node", new Object[0]);
                mn.instructions.insertBefore(ain, toAdd);
            }
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntityPlayer(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("getEyeHeight") && (!mn.name.equals("func_70047_e") || !mn.desc.equals("()F"))) continue;
            LogHelper.info("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            for (AbstractInsnNode ain : mn.instructions) {
                if (ain == null || ain.getOpcode() != 174) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "am2/utils/EntityUtils", "correctEyePos", "(FLnet/minecraft/entity/Entity;)F", false));
                LogHelper.info("Core: Located target ARETURN insn node", new Object[0]);
                mn.instructions.insertBefore(ain, toAdd);
            }
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntityLivingBase(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        block0: for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("c") && !mn.name.equals("addPotionEffect") || !mn.desc.equals("(Lrl;)V") && !mn.desc.equals("(Lnet/minecraft/potion/PotionEffect;)V")) continue;
            LogHelper.info("Patching addPotionEffect", new Object[0]);
            String className = "net/minecraft/potion/PotionEffect;";
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new TypeInsnNode(187, "am2/api/event/PotionEvent$EventPotionAdded"));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new MethodInsnNode(183, "am2/api/event/PotionEvent$EventPotionAdded", "<init>", "(L" + className + ")V", false));
            list.add((AbstractInsnNode)new VarInsnNode(58, 2));
            list.add((AbstractInsnNode)new LabelNode());
            list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lnet/minecraftforge/fml/common/eventhandler/EventBus;"));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/common/eventhandler/EventBus", "post", "(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z", false));
            list.add((AbstractInsnNode)new InsnNode(87));
            list.add((AbstractInsnNode)new LabelNode());
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "am2/api/event/PotionEvent$EventPotionAdded", "getEffect", "()L" + className, false));
            list.add((AbstractInsnNode)new VarInsnNode(58, 1));
            for (AbstractInsnNode insn : mn.instructions) {
                if (!(insn instanceof LabelNode)) continue;
                mn.instructions.insertBefore(insn, list);
                continue block0;
            }
        }
        MethodNode method = new MethodNode();
        method.name = !is_obfuscated ? "moveRelative" : "func_70060_a";
        method.desc = "(FFF)V";
        method.access = 1;
        method.exceptions = Lists.newArrayList();
        LabelNode endNode = new LabelNode();
        method.instructions.add((AbstractInsnNode)new LabelNode());
        method.instructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "am2/utils/EntityUtils", "correctMouvement", "(FFFLnet/minecraft/entity/Entity;)Z", false));
        method.instructions.add((AbstractInsnNode)new JumpInsnNode(154, endNode));
        method.instructions.add((AbstractInsnNode)new LabelNode());
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
        method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/entity/Entity", !is_obfuscated ? "moveRelative" : "func_70060_a", "(FFF)V", false));
        method.instructions.add((AbstractInsnNode)endNode);
        method.instructions.add((AbstractInsnNode)new InsnNode(177));
        method.visitMaxs(0, 0);
        cn.methods.add(method);
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntityPlayerSP(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        ObfDeobfPair method1_name = new ObfDeobfPair();
        method1_name.setVal("onLivingUpdate", false);
        method1_name.setVal("func_70636_d", true);
        String method1_desc = "()V";
        ObfDeobfPair method1_searchinstruction = new ObfDeobfPair();
        method1_searchinstruction.setVal("updatePlayerMoveState", false);
        method1_searchinstruction.setVal("func_78898_a", true);
        String searchinstruction_desc = "()V";
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals(method1_name.getVal(is_obfuscated)) || !mn.desc.equals(method1_desc)) continue;
            AbstractInsnNode target = null;
            LogHelper.info("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof VarInsnNode) || ((VarInsnNode)node).getOpcode() != 25 || !((node = (AbstractInsnNode)instructions.next()) instanceof FieldInsnNode) || ((FieldInsnNode)node).getOpcode() != 180 || !((node = (AbstractInsnNode)instructions.next()) instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.name.equals(method1_searchinstruction.getVal(is_obfuscated)) || !method.desc.equals(searchinstruction_desc)) continue;
                LogHelper.info("Core: Located target method insn node: " + method.name + method.desc, new Object[0]);
                target = node;
                break;
            }
            if (target == null) continue;
            MethodInsnNode callout = new MethodInsnNode(184, "am2/gui/AMGuiHelper", "overrideKeyboardInput", "()V", false);
            mn.instructions.insert(target, (AbstractInsnNode)callout);
            LogHelper.info("Core: Success!  Inserted operations!", new Object[0]);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchEntityRenderer(byte[] basicClass, boolean isObf) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        ObfDeobfPair method1_name = new ObfDeobfPair();
        method1_name.setVal("setupCameraTransform", false);
        method1_name.setVal("func_78479_a", true);
        ObfDeobfPair method2_name = new ObfDeobfPair();
        method2_name.setVal("updateCameraAndRender", false);
        method2_name.setVal("func_181560_a", true);
        String method2_desc = "(FJ)V";
        ObfDeobfPair method2_searchinstruction_function = new ObfDeobfPair();
        method2_searchinstruction_function.setVal("startSection", false);
        method2_searchinstruction_function.setVal("func_76320_a", true);
        String method2_searchinstruction_desc = "(Ljava/lang/String;)V";
        for (MethodNode mn : cn.methods) {
            if (mn.name.equals(method1_name.getVal(isObf)) && mn.desc.equals("(FI)V")) {
                MethodInsnNode callout;
                VarInsnNode floatset;
                AbstractInsnNode orientCameraNode = null;
                AbstractInsnNode gluPerspectiveNode = null;
                LogHelper.info("Core: Located target method " + mn.name + mn.desc, new Object[0]);
                for (AbstractInsnNode node : mn.instructions) {
                    if (node instanceof MethodInsnNode) {
                        MethodInsnNode method = (MethodInsnNode)node;
                        if (orientCameraNode == null && (method.name.equals("orientCamera") || method.name.equals("func_78467_g")) && method.desc.equals("(F)V")) {
                            LogHelper.info("Core: Located target method insn node: " + method.name + method.desc, new Object[0]);
                            orientCameraNode = node;
                            continue;
                        }
                        if (gluPerspectiveNode == null && method.name.equals("gluPerspective") && method.desc.equals("(FFFF)V")) {
                            LogHelper.info("Core: Located target method insn node: " + method.name + method.desc, new Object[0]);
                            gluPerspectiveNode = node;
                            continue;
                        }
                    }
                    if (orientCameraNode == null || gluPerspectiveNode == null) continue;
                    break;
                }
                if (orientCameraNode != null) {
                    floatset = new VarInsnNode(23, 1);
                    callout = new MethodInsnNode(184, "am2/gui/AMGuiHelper", "shiftView", "(F)V", false);
                    mn.instructions.insert(orientCameraNode, (AbstractInsnNode)callout);
                    mn.instructions.insert(orientCameraNode, (AbstractInsnNode)floatset);
                    LogHelper.info("Core: Success!  Inserted callout function op (shift)!", new Object[0]);
                }
                if (gluPerspectiveNode == null) continue;
                floatset = new VarInsnNode(23, 1);
                callout = new MethodInsnNode(184, "am2/gui/AMGuiHelper", "flipView", "(F)V", false);
                mn.instructions.insert(gluPerspectiveNode, (AbstractInsnNode)callout);
                mn.instructions.insert(gluPerspectiveNode, (AbstractInsnNode)floatset);
                LogHelper.info("Core: Success!  Inserted callout function op (flip)!", new Object[0]);
                continue;
            }
            if (!mn.name.equals(method2_name.getVal(isObf)) || !mn.desc.equals(method2_desc)) continue;
            AbstractInsnNode target = null;
            LogHelper.info("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            AbstractInsnNode node = null;
            boolean mouseFound = false;
            while (instructions.hasNext()) {
                node = (AbstractInsnNode)instructions.next();
                if (!mouseFound) {
                    if (!(node instanceof LdcInsnNode) || !((LdcInsnNode)node).cst.equals("mouse")) continue;
                    mouseFound = true;
                    continue;
                }
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.owner.equals("net/minecraft/profiler/Profiler") || !method.name.equals(method2_searchinstruction_function.getVal(isObf)) || !method.desc.equals(method2_searchinstruction_desc)) continue;
                LogHelper.info("Core: Located target method insn node: " + method.owner + "." + method.name + ", " + method.desc, new Object[0]);
                target = node;
                break;
            }
            if (target == null) continue;
            int iRegister = 4;
            VarInsnNode aLoad = new VarInsnNode(25, 0);
            VarInsnNode fLoad = new VarInsnNode(23, 1);
            VarInsnNode iLoad = new VarInsnNode(21, iRegister);
            MethodInsnNode callout = new MethodInsnNode(184, "am2/gui/AMGuiHelper", "overrideMouseInput", "(Lnet/minecraft/client/renderer/EntityRenderer;FZ)Z", false);
            VarInsnNode iStore = new VarInsnNode(54, iRegister);
            mn.instructions.insert(target, (AbstractInsnNode)iStore);
            mn.instructions.insert(target, (AbstractInsnNode)callout);
            mn.instructions.insert(target, (AbstractInsnNode)iLoad);
            mn.instructions.insert(target, (AbstractInsnNode)fLoad);
            mn.instructions.insert(target, (AbstractInsnNode)aLoad);
            LogHelper.info("Core: Success!  Inserted opcodes!", new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public class ObfDeobfPair {
        private String deobf_val = "";
        private String obf_val = "";

        public void setVal(String value, boolean is_obfuscated) {
            if (is_obfuscated) {
                this.obf_val = value;
            } else {
                this.deobf_val = value;
            }
        }

        public String getVal(boolean is_obfuscated) {
            if (is_obfuscated) {
                return this.obf_val;
            }
            return this.deobf_val;
        }
    }
}

