/*
 * Decompiled with CFR 0.152.
 */
package am2.armor.infusions;

import am2.api.items.armor.ArmorImbuement;
import am2.api.items.armor.ImbuementApplicationTypes;
import am2.api.items.armor.ImbuementTiers;
import am2.buffs.BuffEffectSlowfall;
import am2.defs.PotionEffectsDefs;
import am2.extensions.EntityExtension;
import am2.utils.MathUtilities;
import java.util.EnumSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FallProtection
extends ArmorImbuement {
    @Override
    public String getID() {
        return "fallprot";
    }

    @Override
    public ImbuementTiers getTier() {
        return ImbuementTiers.FOURTH;
    }

    @Override
    public EnumSet<ImbuementApplicationTypes> getApplicationTypes() {
        return EnumSet.of(ImbuementApplicationTypes.ON_TICK);
    }

    @Override
    public boolean applyEffect(EntityPlayer player, World world, ItemStack stack, ImbuementApplicationTypes matchedType, Object ... params) {
        if (world.field_72995_K) {
            return false;
        }
        int distanceToGround = MathUtilities.getDistanceToGround((EntityLivingBase)player, world);
        EntityExtension extendedProperties = EntityExtension.For((EntityLivingBase)player);
        if (player.field_70143_R >= extendedProperties.getFallProtection() + 4.0f && (double)distanceToGround < -8.0 * player.field_70181_x && !player.func_70644_a(PotionEffectsDefs.slowfall) && !player.field_71075_bZ.field_75100_b) {
            BuffEffectSlowfall sf = new BuffEffectSlowfall(distanceToGround * 3, 1);
            player.func_70690_d((PotionEffect)sf);
            stack.func_77972_a((int)(player.field_70143_R * 6.0f), (EntityLivingBase)player);
            player.field_70143_R = 0.0f;
            return true;
        }
        return false;
    }

    @Override
    public EntityEquipmentSlot[] getValidSlots() {
        return new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET};
    }

    @Override
    public boolean canApplyOnCooldown() {
        return false;
    }

    @Override
    public int getCooldown() {
        return 900;
    }

    @Override
    public int getArmorDamage() {
        return 0;
    }
}

