/*
 * Decompiled with CFR 0.152.
 */
package am2.armor;

import am2.ArsMagica2;
import am2.api.items.armor.ArmorImbuement;
import am2.api.items.armor.ImbuementApplicationTypes;
import am2.armor.ArmorHelper;
import am2.defs.BlockDefs;
import am2.extensions.AffinityData;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ArmorEventHandler {
    @SubscribeEvent
    public void onEntityLiving(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            ArmorHelper.HandleArmorInfusion((EntityPlayer)event.getEntityLiving());
        }
        this.doInfusions(ImbuementApplicationTypes.ON_TICK, (Event)event, (EntityPlayer)event.getEntityLiving());
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        this.doInfusions(ImbuementApplicationTypes.ON_HIT, (Event)event, (EntityPlayer)event.getEntityLiving());
        if (event.getEntityLiving() instanceof EntityPlayer) {
            this.doXPInfusion((EntityPlayer)event.getEntityLiving(), 0.01f, Math.max(0.05f, Math.min(event.getAmount(), 5.0f)));
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        this.doInfusions(ImbuementApplicationTypes.ON_JUMP, (Event)event, (EntityPlayer)event.getEntityLiving());
    }

    @SubscribeEvent
    public void onMiningSpeed(PlayerEvent.BreakSpeed event) {
        this.doInfusions(ImbuementApplicationTypes.ON_MINING_SPEED, (Event)event, event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            this.doXPInfusion((EntityPlayer)event.getSource().func_76346_g(), 1.0f, Math.min(20.0f, event.getEntityLiving().func_110138_aP()));
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        this.doInfusions(ImbuementApplicationTypes.ON_DEATH, (Event)event, (EntityPlayer)event.getEntityLiving());
    }

    private void doInfusions(ImbuementApplicationTypes type, Event event, EntityPlayer player) {
        AffinityData props = AffinityData.For((EntityLivingBase)player);
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ArmorImbuement[] infusions;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            for (ArmorImbuement inf : infusions = ArmorHelper.getInfusionsOnArmor(player, slot)) {
                if (!inf.getApplicationTypes().contains((Object)type) || !inf.canApply(player) || !inf.applyEffect(player, player.field_70170_p, player.func_184582_a(slot), type, event) || inf.getCooldown() <= 0 || props.getCooldown(inf.getRegistryName().toString()) >= inf.getCooldown()) continue;
                props.addCooldown(inf.getRegistryName().toString(), inf.getCooldown());
                if (!(player instanceof EntityPlayerMP)) continue;
                ArsMagica2.proxy.blackoutArmorPiece((EntityPlayerMP)player, slot, inf.getCooldown());
            }
        }
    }

    private void doXPInfusion(EntityPlayer player, float xpMin, float xpMax) {
        float amt = (float)((double)(player.field_70170_p.field_73012_v.nextFloat() * xpMin + (xpMax - xpMin)) * ArsMagica2.config.getArmorXPInfusionFactor());
        ArmorHelper.addXPToArmor(amt, player);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        block8: {
            NBTTagList list;
            ItemStack stack;
            block7: {
                NBTTagCompound armorCompound;
                stack = event.getItemStack();
                if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) break block7;
                double xp = 0.0;
                int armorLevel = 0;
                String[] effects = new String[]{};
                if (stack.func_77942_o() && (armorCompound = (NBTTagCompound)stack.func_77978_p().func_74781_a("AMArmorProperties")) != null) {
                    xp = armorCompound.func_74769_h("infusedXP");
                    armorLevel = armorCompound.func_74762_e("XPLevel");
                    String effectsList = armorCompound.func_74779_i("armorEffects");
                    if (effectsList != null && effectsList != "") {
                        effects = effectsList.split("\\|");
                    }
                }
                if (Keyboard.isKeyDown((int)42)) {
                    event.getToolTip().add(I18n.func_74837_a((String)"am2.tooltip.armorxp", (Object[])new Object[]{String.format("%.2f", xp)}));
                    event.getToolTip().add(String.format(I18n.func_74838_a((String)"am2.tooltip.armorlevel"), armorLevel));
                    if (effects.length > 0) {
                        event.getToolTip().add(I18n.func_74838_a((String)"am2.toolip.infusions"));
                    }
                    for (String s : effects) {
                        event.getToolTip().add("-" + I18n.func_74838_a((String)("am2.tooltip." + s.replaceAll("arsmagica2:", ""))));
                    }
                } else {
                    event.getToolTip().add(I18n.func_74838_a((String)"am2.tooltip.shiftForDetails"));
                }
                break block8;
            }
            if (!(stack.func_77973_b() instanceof ItemBlock) || ((ItemBlock)stack.func_77973_b()).field_150939_a != BlockDefs.manaBattery || !stack.func_77942_o() || (list = stack.func_77978_p().func_150295_c("Lore", 10)) == null) break block8;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                if (!(tag instanceof NBTTagString)) continue;
                event.getToolTip().add(((NBTTagString)tag).func_150285_a_());
            }
        }
    }
}

