/*
 * Decompiled with CFR 0.152.
 */
package am2.armor;

import am2.armor.ArsMagicaArmorMaterial;
import am2.defs.CreativeTabsDefs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class AMArmor
extends ItemArmor
implements ISpecialArmor {
    private static final int[] maxDamageArray = new int[]{11, 16, 15, 13};
    public final EntityEquipmentSlot field_77881_a;
    public final int field_77879_b;
    private final ArsMagicaArmorMaterial material;
    private final int damageReduction;
    private final float infusionCost;
    private final float infusionRepair;
    public static final String NBT_KEY_AMPROPS = "AMArmorProperties";
    public static final String NBT_KEY_EFFECTS = "armorEffects";
    public static final String NBT_KEY_TOTALXP = "infusedXP";
    public static final String NBT_KEY_ARMORLEVEL = "XPLevel";
    public static final String INFUSION_DELIMITER = "\\|";

    public AMArmor(ItemArmor.ArmorMaterial inheritFrom, ArsMagicaArmorMaterial enumarmormaterial, int par3, EntityEquipmentSlot par4) {
        super(inheritFrom, par3, par4);
        this.material = enumarmormaterial;
        this.field_77881_a = par4;
        this.field_77879_b = 0;
        this.func_77656_e(enumarmormaterial.getMaxDamage(par4));
        this.func_77637_a(CreativeTabsDefs.tabAM2Items);
        this.field_77777_bU = 1;
        this.damageReduction = enumarmormaterial.getDamageReductionAmount(par4);
        this.infusionCost = enumarmormaterial.getInfusionCost();
        this.infusionRepair = enumarmormaterial.getInfusionRepair();
    }

    public AMArmor registerAndName(String name) {
        this.func_77655_b("arsmagica2:" + name);
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)new ResourceLocation("arsmagica2", name));
        return this;
    }

    public int func_77619_b() {
        return this.material.getEnchantability();
    }

    static int[] getMaxDamageArray() {
        return maxDamageArray;
    }

    public int GetDamageReduction() {
        return this.damageReduction;
    }

    public float GetInfusionCost() {
        return this.infusionCost;
    }

    public float GetInfusionRepair() {
        return this.infusionRepair;
    }

    public int getMaterialID() {
        return this.material.getMaterialID();
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.GetDamageReduction();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(1, (double)this.material.getDamageReduceRatio(slot), 1000);
        return ap;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (source == DamageSource.field_76370_b) {
            stack.func_77972_a(damage * 7, entity);
        } else {
            if (source == DamageSource.field_76379_h || source == DamageSource.field_76368_d || source == DamageSource.field_76369_e || source == DamageSource.field_76366_f) {
                return;
            }
            if (source == DamageSource.field_76376_m) {
                stack.func_77972_a(damage * 7, entity);
            } else {
                if (source.func_76363_c()) {
                    return;
                }
                stack.func_77972_a(damage * 10, entity);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return null;
    }

    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_KEY_AMPROPS)) {
            String s = ((NBTTagCompound)stack.func_77978_p().func_74781_a(NBT_KEY_AMPROPS)).func_74779_i(NBT_KEY_EFFECTS);
            return s != null && s.length() > 0;
        }
        return super.func_77636_d(stack);
    }
}

