/*
 * Decompiled with CFR 0.152.
 */
package am2.api.rituals;

import am2.LogHelper;
import am2.api.blocks.MultiblockGroup;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.blocks.TypedMultiblockGroup;
import am2.api.rituals.IRitualInteraction;
import am2.defs.BlockDefs;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RitualShapeHelper {
    public static final RitualShapeHelper instance = new RitualShapeHelper();
    public MultiblockStructureDefinition corruption = new MultiblockStructureDefinition("corruption");
    public MultiblockStructureDefinition purification = new MultiblockStructureDefinition("purification");
    public MultiblockStructureDefinition hourglass = new MultiblockStructureDefinition("hourglass");
    public MultiblockStructureDefinition ringedCross = new MultiblockStructureDefinition("ringedCross");

    public boolean matchesRitual(IRitualInteraction ritual, World world, BlockPos pos) {
        List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)ritual.getReagentSearchRadius(), (double)ritual.getReagentSearchRadius(), (double)ritual.getReagentSearchRadius()));
        if (!ritual.getRitualShape().matches(world, pos)) {
            return false;
        }
        for (ItemStack stack : ritual.getReagents()) {
            boolean matches = false;
            for (EntityItem item : items) {
                ItemStack is = item.func_92059_d();
                if (!is.func_77973_b().equals(stack.func_77973_b()) || stack.func_77960_j() != Short.MAX_VALUE && is.func_77960_j() != stack.func_77960_j() || is.field_77994_a < stack.field_77994_a) continue;
                matches = true;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] checkForRitual(IRitualInteraction ritual, World world, BlockPos pos) {
        ArrayList items = (ArrayList)world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)ritual.getReagentSearchRadius(), (double)ritual.getReagentSearchRadius(), (double)ritual.getReagentSearchRadius()));
        Collections.sort(items, new EntityItemComparator());
        ItemStack[] toReturn = new ItemStack[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            toReturn[i] = ((EntityItem)items.get(i)).func_92059_d();
        }
        return toReturn;
    }

    public void consumeReagents(IRitualInteraction ritual, World world, BlockPos pos) {
        List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)ritual.getReagentSearchRadius(), (double)ritual.getReagentSearchRadius(), (double)ritual.getReagentSearchRadius()));
        for (ItemStack stack : ritual.getReagents()) {
            for (EntityItem item : items) {
                ItemStack is = item.func_92059_d();
                if (!is.func_77973_b().equals(stack.func_77973_b()) || is.func_77960_j() != stack.func_77960_j() || is.field_77994_a < stack.field_77994_a) continue;
                is.field_77994_a -= stack.field_77994_a;
                if (is.field_77994_a <= 0) {
                    item.func_70106_y();
                    continue;
                }
                item.func_92058_a(is);
            }
        }
    }

    public void consumeAllReagents(IRitualInteraction interaction, World world, BlockPos pos) {
        int r = interaction.getReagentSearchRadius();
        List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)r, (double)r, (double)r));
        for (EntityItem item : items) {
            LogHelper.debug("Removing Item %s", item.func_92059_d().toString());
            item.func_70106_y();
        }
    }

    public void consumeShape(IRitualInteraction ritual, World world, BlockPos pos) {
        for (MultiblockGroup group : ritual.getRitualShape().getMatchingGroups(world, pos)) {
            for (BlockPos blockPos : group.getPositions()) {
                IBlockState state = world.func_180495_p(pos.func_177971_a((Vec3i)blockPos));
                world.func_175698_g(pos.func_177971_a((Vec3i)blockPos));
                world.func_184138_a(pos.func_177971_a((Vec3i)blockPos), state, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    private RitualShapeHelper() {
        this.corruptionRitual();
        this.purificationRitual();
        this.hourglassRitual();
        this.ringedCrossRitual();
    }

    private void corruptionRitual() {
        HashMap<Integer, IBlockState> corruptionMap = new HashMap<Integer, IBlockState>();
        corruptionMap.put(0, BlockDefs.wizardChalk.func_176223_P());
        corruptionMap.put(1, BlockDefs.wardingCandle.func_176223_P());
        TypedMultiblockGroup defaultRotation = new TypedMultiblockGroup("defaultRotation", Lists.newArrayList((Object[])new HashMap[]{corruptionMap}), true);
        TypedMultiblockGroup rotated = new TypedMultiblockGroup("rotated", Lists.newArrayList((Object[])new HashMap[]{corruptionMap}), true);
        defaultRotation.addBlock(new BlockPos(1, 0, 0), 0);
        defaultRotation.addBlock(new BlockPos(-1, 0, 0), 0);
        defaultRotation.addBlock(new BlockPos(2, 0, 1), 0);
        defaultRotation.addBlock(new BlockPos(-2, 0, 1), 0);
        defaultRotation.addBlock(new BlockPos(2, 0, -1), 0);
        defaultRotation.addBlock(new BlockPos(-2, 0, -1), 0);
        defaultRotation.addBlock(new BlockPos(2, 0, 2), 0);
        defaultRotation.addBlock(new BlockPos(1, 0, 2), 1);
        defaultRotation.addBlock(new BlockPos(0, 0, 2), 0);
        defaultRotation.addBlock(new BlockPos(-1, 0, 2), 1);
        defaultRotation.addBlock(new BlockPos(-2, 0, 2), 0);
        defaultRotation.addBlock(new BlockPos(2, 0, -2), 0);
        defaultRotation.addBlock(new BlockPos(1, 0, -2), 1);
        defaultRotation.addBlock(new BlockPos(0, 0, -2), 0);
        defaultRotation.addBlock(new BlockPos(-1, 0, -2), 1);
        defaultRotation.addBlock(new BlockPos(-2, 0, -2), 0);
        defaultRotation.addBlock(new BlockPos(1, 0, 3), 0);
        defaultRotation.addBlock(new BlockPos(-1, 0, 3), 0);
        defaultRotation.addBlock(new BlockPos(1, 0, -3), 0);
        defaultRotation.addBlock(new BlockPos(-1, 0, -3), 0);
        rotated.addBlock(new BlockPos(0, 0, 1), 0);
        rotated.addBlock(new BlockPos(0, 0, -1), 0);
        rotated.addBlock(new BlockPos(1, 0, 2), 0);
        rotated.addBlock(new BlockPos(1, 0, -2), 0);
        rotated.addBlock(new BlockPos(-1, 0, 2), 0);
        rotated.addBlock(new BlockPos(-1, 0, -2), 0);
        rotated.addBlock(new BlockPos(2, 0, 2), 0);
        rotated.addBlock(new BlockPos(2, 0, 1), 1);
        rotated.addBlock(new BlockPos(2, 0, 0), 0);
        rotated.addBlock(new BlockPos(2, 0, -1), 1);
        rotated.addBlock(new BlockPos(2, 0, -2), 0);
        rotated.addBlock(new BlockPos(-2, 0, 2), 0);
        rotated.addBlock(new BlockPos(-2, 0, 1), 1);
        rotated.addBlock(new BlockPos(-2, 0, 0), 0);
        rotated.addBlock(new BlockPos(-2, 0, -1), 1);
        rotated.addBlock(new BlockPos(-2, 0, -2), 0);
        rotated.addBlock(new BlockPos(3, 0, 1), 0);
        rotated.addBlock(new BlockPos(3, 0, -1), 0);
        rotated.addBlock(new BlockPos(-3, 0, 1), 0);
        rotated.addBlock(new BlockPos(-3, 0, -1), 0);
        this.corruption.addGroup(defaultRotation, rotated);
    }

    private void purificationRitual() {
        MultiblockGroup chalks = new MultiblockGroup("chalk", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.wizardChalk.func_176223_P()}), true);
        MultiblockGroup candles = new MultiblockGroup("candle", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.wardingCandle.func_176223_P()}), true);
        chalks.addBlock(new BlockPos(-1, 0, 1));
        chalks.addBlock(new BlockPos(-1, 0, -1));
        chalks.addBlock(new BlockPos(1, 0, 1));
        chalks.addBlock(new BlockPos(1, 0, -1));
        chalks.addBlock(new BlockPos(-2, 0, 1));
        chalks.addBlock(new BlockPos(-2, 0, -1));
        chalks.addBlock(new BlockPos(2, 0, 1));
        chalks.addBlock(new BlockPos(2, 0, -1));
        chalks.addBlock(new BlockPos(1, 0, -2));
        chalks.addBlock(new BlockPos(-1, 0, -2));
        chalks.addBlock(new BlockPos(1, 0, 2));
        chalks.addBlock(new BlockPos(-1, 0, 2));
        chalks.addBlock(new BlockPos(-3, 0, 1));
        chalks.addBlock(new BlockPos(-3, 0, 0));
        chalks.addBlock(new BlockPos(-3, 0, -1));
        chalks.addBlock(new BlockPos(3, 0, 1));
        chalks.addBlock(new BlockPos(3, 0, 0));
        chalks.addBlock(new BlockPos(3, 0, -1));
        chalks.addBlock(new BlockPos(1, 0, -3));
        chalks.addBlock(new BlockPos(0, 0, -3));
        chalks.addBlock(new BlockPos(-1, 0, -3));
        chalks.addBlock(new BlockPos(1, 0, 3));
        chalks.addBlock(new BlockPos(0, 0, 3));
        chalks.addBlock(new BlockPos(-1, 0, 3));
        candles.addBlock(new BlockPos(-2, 0, 2));
        candles.addBlock(new BlockPos(-2, 0, -2));
        candles.addBlock(new BlockPos(2, 0, 2));
        candles.addBlock(new BlockPos(2, 0, -2));
        this.purification.addGroup(candles, new MultiblockGroup[0]);
        this.purification.addGroup(chalks, new MultiblockGroup[0]);
    }

    private void hourglassRitual() {
        MultiblockGroup chalks = new MultiblockGroup("chalk", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.wizardChalk.func_176223_P()}), true);
        MultiblockGroup chalks_rotated = new MultiblockGroup("chalk_rot", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.wizardChalk.func_176223_P()}), true);
        chalks.addBlock(new BlockPos(0, 0, 0));
        chalks.addBlock(new BlockPos(-1, 0, 1));
        chalks.addBlock(new BlockPos(-1, 0, -1));
        chalks.addBlock(new BlockPos(1, 0, 1));
        chalks.addBlock(new BlockPos(1, 0, -1));
        chalks.addBlock(new BlockPos(-2, 0, 1));
        chalks.addBlock(new BlockPos(-2, 0, 0));
        chalks.addBlock(new BlockPos(-2, 0, -1));
        chalks.addBlock(new BlockPos(2, 0, 1));
        chalks.addBlock(new BlockPos(2, 0, 0));
        chalks.addBlock(new BlockPos(2, 0, -1));
        chalks_rotated.addBlock(new BlockPos(0, 0, 0));
        chalks_rotated.addBlock(new BlockPos(-1, 0, 1));
        chalks_rotated.addBlock(new BlockPos(-1, 0, -1));
        chalks_rotated.addBlock(new BlockPos(1, 0, 1));
        chalks_rotated.addBlock(new BlockPos(1, 0, -1));
        chalks_rotated.addBlock(new BlockPos(1, 0, -2));
        chalks_rotated.addBlock(new BlockPos(0, 0, -2));
        chalks_rotated.addBlock(new BlockPos(-1, 0, -2));
        chalks_rotated.addBlock(new BlockPos(1, 0, 2));
        chalks_rotated.addBlock(new BlockPos(0, 0, 2));
        chalks_rotated.addBlock(new BlockPos(-1, 0, 2));
        this.hourglass.addGroup(chalks, chalks_rotated);
    }

    private void ringedCrossRitual() {
        MultiblockGroup chalks = new MultiblockGroup("chalk", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.wizardChalk.func_176223_P()}), true);
        chalks.addBlock(new BlockPos(1, 0, 0));
        chalks.addBlock(new BlockPos(-1, 0, 0));
        chalks.addBlock(new BlockPos(0, 0, 1));
        chalks.addBlock(new BlockPos(0, 0, -1));
        chalks.addBlock(new BlockPos(1, 0, 2));
        chalks.addBlock(new BlockPos(0, 0, 2));
        chalks.addBlock(new BlockPos(-1, 0, 2));
        chalks.addBlock(new BlockPos(1, 0, -2));
        chalks.addBlock(new BlockPos(0, 0, -2));
        chalks.addBlock(new BlockPos(-1, 0, -2));
        chalks.addBlock(new BlockPos(2, 0, 1));
        chalks.addBlock(new BlockPos(2, 0, 0));
        chalks.addBlock(new BlockPos(2, 0, -1));
        chalks.addBlock(new BlockPos(-2, 0, 1));
        chalks.addBlock(new BlockPos(-2, 0, 0));
        chalks.addBlock(new BlockPos(-2, 0, -1));
        this.ringedCross.addGroup(chalks, new MultiblockGroup[0]);
    }

    private class EntityItemComparator
    implements Comparator<EntityItem> {
        private EntityItemComparator() {
        }

        @Override
        public int compare(EntityItem o1, EntityItem o2) {
            if (o1.field_70173_aa == o2.field_70173_aa) {
                return 0;
            }
            if (o1.field_70173_aa > o2.field_70173_aa) {
                return -1;
            }
            return 1;
        }
    }
}

