/*
 * Decompiled with CFR 0.152.
 */
package am2.api.math;

import am2.api.math.AMMatrix4;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class AMVector3 {
    public float x;
    public float y;
    public float z;

    public AMVector3(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public AMVector3(TileEntity tile) {
        this.x = tile.func_174877_v().func_177958_n();
        this.y = tile.func_174877_v().func_177956_o();
        this.z = tile.func_174877_v().func_177952_p();
    }

    public AMVector3(Vec3d vec) {
        this.x = (float)vec.field_72450_a;
        this.y = (float)vec.field_72448_b;
        this.z = (float)vec.field_72449_c;
    }

    public AMVector3(AMVector3 a, AMVector3 b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
    }

    public AMVector3(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public AMVector3(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public AMVector3 add(AMVector3 vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public AMVector3 sub(AMVector3 vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public AMVector3 scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public AMVector3 scale(float scalex, float scaley, float scalez) {
        this.x *= scalex;
        this.y *= scaley;
        this.z *= scalez;
        return this;
    }

    public AMVector3 modulo(float divisor) {
        this.x %= divisor;
        this.y %= divisor;
        this.z %= divisor;
        return this;
    }

    public AMVector3 normalize() {
        float length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthPow2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public AMVector3 copy() {
        return new AMVector3(this.x, this.y, this.z);
    }

    public static AMVector3 crossProduct(AMVector3 vec1, AMVector3 vec2) {
        return new AMVector3(vec1.y * vec2.z - vec1.z * vec2.y, vec1.z * vec2.x - vec1.x * vec2.z, vec1.x * vec2.y - vec1.y * vec2.x);
    }

    public static AMVector3 xCrossProduct(AMVector3 vec) {
        return new AMVector3(0.0, vec.z, -vec.y);
    }

    public static AMVector3 zCrossProduct(AMVector3 vec) {
        return new AMVector3(-vec.y, vec.x, 0.0);
    }

    public static float dotProduct(AMVector3 vec1, AMVector3 vec2) {
        return vec1.x * vec2.x + vec1.y * vec2.y + vec1.z * vec2.z;
    }

    public static float angle(AMVector3 vec1, AMVector3 vec2) {
        return AMVector3.anglePreNorm(vec1.copy().normalize(), vec2.copy().normalize());
    }

    public static float anglePreNorm(AMVector3 vec1, AMVector3 vec2) {
        return (float)Math.acos(AMVector3.dotProduct(vec1, vec2));
    }

    public static AMVector3 zero() {
        return new AMVector3(0.0, 0.0, 0.0);
    }

    public AMVector3 rotate(float angle, AMVector3 axis) {
        return AMMatrix4.rotationMat(angle, axis).translate(this);
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public Vec3d toVec3D() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public static AMVector3 getPerpendicular(AMVector3 vec) {
        if (vec.z == 0.0f) {
            return AMVector3.zCrossProduct(vec);
        }
        return AMVector3.xCrossProduct(vec);
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public boolean isWithinRange(float min, float max) {
        return this.x >= min && this.x <= max && this.y >= min && this.y <= max && this.z >= min && this.z <= max;
    }

    public double distanceTo(AMVector3 target) {
        double var2 = target.x - this.x;
        double var4 = target.y - this.y;
        double var6 = target.z - this.z;
        return MathHelper.func_76133_a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public double distanceSqTo(AMVector3 target) {
        double var2 = target.x - this.x;
        double var4 = target.y - this.y;
        double var6 = target.z - this.z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public void floorToI() {
        this.x = (float)Math.floor(this.x);
        this.y = (float)Math.floor(this.y);
        this.z = (float)Math.floor(this.z);
    }

    public void roundToI() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
    }

    public void ceilToI() {
        this.x = (float)Math.ceil(this.x);
        this.y = (float)Math.ceil(this.y);
        this.z = (float)Math.ceil(this.z);
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74776_a("Vec3_x", this.x);
        compound.func_74776_a("Vec3_y", this.y);
        compound.func_74776_a("Vec3_z", this.z);
    }

    public static AMVector3 readFromNBT(NBTTagCompound compound) {
        return new AMVector3(compound.func_74760_g("Vec3_x"), compound.func_74760_g("Vec3_y"), compound.func_74760_g("Vec3_z"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AMVector3) {
            AMVector3 comp = (AMVector3)obj;
            return comp.x == this.x && comp.y == this.y && comp.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.x + this.y + this.z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos((double)this.x, (double)this.y, (double)this.z);
    }
}

