/*
 * Decompiled with CFR 0.152.
 */
package am2.api.extensions;

import am2.api.SkillPointRegistry;
import am2.api.skill.Skill;
import am2.api.skill.SkillPoint;
import am2.extensions.SkillData;
import am2.utils.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public interface ISkillData {
    public boolean hasSkill(String var1);

    public void unlockSkill(String var1);

    public HashMap<Skill, Boolean> getSkills();

    public HashMap<SkillPoint, Integer> getSkillPoints();

    public int getSkillPoint(SkillPoint var1);

    public void setSkillPoint(SkillPoint var1, int var2);

    public boolean canLearn(String var1);

    public ArrayList<String> getKnownShapes();

    public ArrayList<String> getKnownComponents();

    public ArrayList<String> getKnownModifiers();

    public static class Factory
    implements Callable<ISkillData> {
        @Override
        public ISkillData call() throws Exception {
            return new SkillData();
        }
    }

    public static class Storage
    implements Capability.IStorage<ISkillData> {
        public NBTBase writeNBT(Capability<ISkillData> capability, ISkillData instance, EnumFacing side) {
            NBTTagCompound tmp;
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagCompound am2Tag = NBTUtils.getAM2Tag(nbt);
            NBTTagList skillList = NBTUtils.addCompoundList(am2Tag, "Skills");
            NBTTagList skillPointList = NBTUtils.addCompoundList(am2Tag, "SkillPoints");
            for (Map.Entry<Skill, Boolean> entry : instance.getSkills().entrySet()) {
                if (entry.getKey() == null) continue;
                tmp = new NBTTagCompound();
                tmp.func_74778_a("Skill", entry.getKey().getID());
                tmp.func_74757_a("Unlocked", entry.getValue().booleanValue());
                skillList.func_74742_a((NBTBase)tmp);
            }
            for (Map.Entry<Object, Comparable<Boolean>> entry : instance.getSkillPoints().entrySet()) {
                if (entry.getKey() == null) continue;
                tmp = new NBTTagCompound();
                tmp.func_74778_a("Type", ((SkillPoint)entry.getKey()).getName());
                tmp.func_74768_a("Number", ((Integer)entry.getValue()).intValue());
                skillPointList.func_74742_a((NBTBase)tmp);
            }
            am2Tag.func_74782_a("Skills", (NBTBase)skillList);
            am2Tag.func_74782_a("SkillPoints", (NBTBase)skillPointList);
            return nbt;
        }

        public void readNBT(Capability<ISkillData> capability, ISkillData instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tmp;
            int i;
            NBTTagCompound am2Tag = NBTUtils.getAM2Tag((NBTTagCompound)nbt);
            NBTTagList skillList = NBTUtils.addCompoundList(am2Tag, "Skills");
            NBTTagList skillPointList = NBTUtils.addCompoundList(am2Tag, "SkillPoints");
            for (i = 0; i < skillList.func_74745_c(); ++i) {
                tmp = skillList.func_150305_b(i);
                if (!tmp.func_74767_n("Unlocked")) continue;
                instance.unlockSkill(tmp.func_74779_i("Skill"));
            }
            for (i = 0; i < skillPointList.func_74745_c(); ++i) {
                tmp = skillPointList.func_150305_b(i);
                instance.setSkillPoint(SkillPointRegistry.fromName(tmp.func_74779_i("Type")), tmp.func_74762_e("Number"));
            }
        }
    }
}

