/*
 * Decompiled with CFR 0.152.
 */
package am2.api.extensions;

import am2.api.extensions.IDataSyncExtension;
import am2.extensions.EntityExtension;
import am2.spell.ContingencyType;
import am2.utils.NBTUtils;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public interface IEntityExtension {
    public boolean hasEnoughtMana(float var1);

    public void setContingency(ContingencyType var1, ItemStack var2);

    public ContingencyType getContingencyType();

    public ItemStack getContingencyStack();

    public double getMarkX();

    public double getMarkY();

    public double getMarkZ();

    public int getMarkDimensionID();

    public float getCurrentMana();

    public int getCurrentLevel();

    public float getCurrentBurnout();

    public int getCurrentSummons();

    public float getCurrentXP();

    public int getHealCooldown();

    public void lowerHealCooldown(int var1);

    public void placeHealOnCooldown();

    public void lowerAffinityHealCooldown(int var1);

    public int getAffinityHealCooldown();

    public void placeAffinityHealOnCooldown(boolean var1);

    public float getMaxMana();

    public float getMaxXP();

    public float getMaxBurnout();

    public void setAffinityHealCooldown(int var1);

    public void setCurrentBurnout(float var1);

    public void setCurrentLevel(int var1);

    public void setCurrentMana(float var1);

    public void setCurrentSummons(int var1);

    public void setCurrentXP(float var1);

    public void setHealCooldown(int var1);

    public void setMarkX(double var1);

    public void setMarkY(double var1);

    public void setMarkZ(double var1);

    public void setMarkDimensionID(int var1);

    public void setMark(double var1, double var3, double var5, int var7);

    public void setShrunk(boolean var1);

    public boolean isShrunk();

    public void setInverted(boolean var1);

    public void setFallProtection(float var1);

    public boolean isInverted();

    public void addEntityReference(EntityLivingBase var1);

    public void init(EntityLivingBase var1, IDataSyncExtension var2);

    public boolean canHeal();

    public int getMaxSummons();

    public boolean addSummon(EntityCreature var1);

    public boolean getCanHaveMoreSummons();

    public void updateManaLink(EntityLivingBase var1);

    public void deductMana(float var1);

    public void spawnManaLinkParticles();

    public boolean removeSummon();

    public boolean isManaLinkedTo(EntityLivingBase var1);

    public void cleanupManaLinks();

    public float getBonusMaxMana();

    public float getBonusCurrentMana();

    public boolean shouldReverseInput();

    public boolean getIsFlipped();

    public float getFlipRotation();

    public float getPrevFlipRotation();

    public float getShrinkPct();

    public float getPrevShrinkPct();

    public void setTKDistance(float var1);

    public void addToTKDistance(float var1);

    public float getTKDistance();

    public void syncTKDistance();

    public float getFallProtection();

    public void manaBurnoutTick();

    public boolean setMagicLevelWithMana(int var1);

    public void addMagicXP(float var1);

    public void setDisableGravity(boolean var1);

    public boolean isGravityDisabled();

    public Entity getInanimateTarget();

    public void setInanimateTarget(Entity var1);

    public void setFlipRotation(float var1);

    public void setPrevFlipRotation(float var1);

    public float getManaShielding();

    public void setManaShielding(float var1);

    public static class Factory
    implements Callable<IEntityExtension> {
        @Override
        public IEntityExtension call() throws Exception {
            return new EntityExtension();
        }
    }

    public static class Storage
    implements Capability.IStorage<IEntityExtension> {
        public NBTBase writeNBT(Capability<IEntityExtension> capability, IEntityExtension instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagCompound am2tag = NBTUtils.getAM2Tag(compound);
            am2tag.func_74776_a("CurrentMana", instance.getCurrentMana());
            am2tag.func_74768_a("CurrentLevel", instance.getCurrentLevel());
            am2tag.func_74776_a("CurrentXP", instance.getCurrentXP());
            am2tag.func_74776_a("CurrentBurnout", instance.getCurrentBurnout());
            am2tag.func_74768_a("CurrentSummons", instance.getCurrentSummons());
            am2tag.func_74768_a("HealCooldown", instance.getHealCooldown());
            am2tag.func_74768_a("AffinityHealCooldown", instance.getAffinityHealCooldown());
            am2tag.func_74757_a("Shrunk", instance.isShrunk());
            am2tag.func_74757_a("Inverted", instance.isInverted());
            am2tag.func_74776_a("FallProtection", instance.getFallProtection());
            am2tag.func_74780_a("MarkX", instance.getMarkX());
            am2tag.func_74780_a("MarkY", instance.getMarkY());
            am2tag.func_74780_a("MarkZ", instance.getMarkZ());
            am2tag.func_74768_a("MarkDimensionId", instance.getMarkDimensionID());
            am2tag.func_74776_a("TK_Distance", instance.getTKDistance());
            am2tag.func_74776_a("ManaShielding", instance.getManaShielding());
            NBTTagCompound contingencyTag = NBTUtils.addTag(am2tag, "Contingency");
            if (instance.getContingencyType() != ContingencyType.NULL) {
                contingencyTag.func_74778_a("Type", instance.getContingencyType().name().toLowerCase());
                contingencyTag.func_74782_a("Stack", (NBTBase)instance.getContingencyStack().func_77955_b(new NBTTagCompound()));
            } else {
                contingencyTag.func_74778_a("Type", "null");
            }
            return compound;
        }

        public void readNBT(Capability<IEntityExtension> capability, IEntityExtension instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound am2tag = NBTUtils.getAM2Tag((NBTTagCompound)nbt);
            instance.setCurrentMana(am2tag.func_74760_g("CurrentMana"));
            instance.setCurrentLevel(am2tag.func_74762_e("CurrentLevel"));
            instance.setCurrentXP(am2tag.func_74760_g("CurrentXP"));
            instance.setCurrentBurnout(am2tag.func_74760_g("CurrentBurnout"));
            instance.setCurrentSummons(am2tag.func_74762_e("CurrentSummons"));
            instance.setHealCooldown(am2tag.func_74762_e("HealCooldown"));
            instance.setAffinityHealCooldown(am2tag.func_74762_e("AffinityHealCooldown"));
            instance.setShrunk(am2tag.func_74767_n("Shrunk"));
            instance.setInverted(am2tag.func_74767_n("Inverted"));
            instance.setFallProtection(am2tag.func_74760_g("FallProtection"));
            instance.setMarkX(am2tag.func_74769_h("MarkX"));
            instance.setMarkY(am2tag.func_74769_h("MarkY"));
            instance.setMarkZ(am2tag.func_74769_h("MarkZ"));
            instance.setMarkDimensionID(am2tag.func_74762_e("MarkDimensionId"));
            instance.setTKDistance(am2tag.func_74760_g("TK_Distance"));
            instance.setManaShielding(am2tag.func_74760_g("ManaShielding"));
            NBTTagCompound contingencyTag = NBTUtils.addTag(am2tag, "Contingency");
            if (!contingencyTag.func_74764_b("Type") || !contingencyTag.func_74779_i("Type").equals("null")) {
                instance.setContingency(ContingencyType.fromName(contingencyTag.func_74779_i("Type")), ItemStack.func_77949_a((NBTTagCompound)contingencyTag.func_74775_l("Stack")));
            } else {
                instance.setContingency(ContingencyType.NULL, null);
            }
        }
    }
}

