/*
 * Decompiled with CFR 0.152.
 */
package am2.api.extensions;

import am2.api.compendium.CompendiumCategory;
import am2.api.compendium.CompendiumEntry;
import am2.lore.ArcaneCompendium;
import am2.utils.NBTUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public interface IArcaneCompendium {
    public void unlockEntry(String var1);

    public void unlockRelatedItems(ItemStack var1);

    public boolean isUnlocked(String var1);

    public String getPath();

    public void setPath(String var1);

    public ArrayList<CompendiumEntry> getEntriesForCategory(String var1);

    public boolean isNew(String var1);

    public static class Factory
    implements Callable<IArcaneCompendium> {
        @Override
        public IArcaneCompendium call() throws Exception {
            return new ArcaneCompendium();
        }
    }

    public static class Storage
    implements Capability.IStorage<IArcaneCompendium> {
        public NBTBase writeNBT(Capability<IArcaneCompendium> capability, IArcaneCompendium instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagCompound am2tag = NBTUtils.getAM2Tag(compound);
            NBTTagList unlocks = NBTUtils.addCompoundList(am2tag, "Unlocks");
            for (CompendiumCategory categroy : CompendiumCategory.getCategories()) {
                for (CompendiumEntry entry : categroy.getEntries()) {
                    NBTTagCompound tmp = new NBTTagCompound();
                    tmp.func_74778_a("ID", entry.getID());
                    tmp.func_74757_a("Unlocked", instance.isUnlocked(entry.getID()));
                    unlocks.func_74742_a((NBTBase)tmp);
                }
            }
            am2tag.func_74778_a("Path", instance.getPath());
            return compound;
        }

        public void readNBT(Capability<IArcaneCompendium> capability, IArcaneCompendium instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound am2tag = NBTUtils.getAM2Tag((NBTTagCompound)nbt);
            NBTTagList unlocks = NBTUtils.addCompoundList(am2tag, "Unlocks");
            for (int i = 0; i < unlocks.func_74745_c(); ++i) {
                NBTTagCompound tmp = unlocks.func_150305_b(i);
                if (!tmp.func_74767_n("Unlocked")) continue;
                instance.unlockEntry(tmp.func_74779_i("ID"));
            }
            instance.setPath(am2tag.func_74779_i("Path"));
        }
    }
}

