/*
 * Decompiled with CFR 0.152.
 */
package am2.api.extensions;

import am2.api.affinity.Affinity;
import am2.api.extensions.IDataSyncExtension;
import am2.extensions.AffinityData;
import am2.utils.NBTUtils;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public interface IAffinityData {
    public double getAffinityDepth(Affinity var1);

    public void setAffinityDepth(Affinity var1, double var2);

    public HashMap<Affinity, Double> getAffinities();

    public void init(EntityPlayer var1, IDataSyncExtension var2);

    public Affinity[] getHighestAffinities();

    public float getDiminishingReturnsFactor();

    public void tickDiminishingReturns();

    public void addDiminishingReturns(boolean var1);

    public void addCooldown(String var1, int var2);

    public Map<String, Integer> getCooldowns();

    public int getCooldown(String var1);

    public Map<String, Float> getAbilityFloatMap();

    public Map<String, Boolean> getAbilityBooleanMap();

    public boolean getAbilityBoolean(String var1);

    public void addAbilityBoolean(String var1, boolean var2);

    public float getAbilityFloat(String var1);

    public void addAbilityFloat(String var1, float var2);

    public void incrementAffinity(Affinity var1, float var2);

    public void setLocked(boolean var1);

    public boolean isLocked();

    public static class Factory
    implements Callable<IAffinityData> {
        @Override
        public IAffinityData call() throws Exception {
            return new AffinityData();
        }
    }

    public static class Storage
    implements Capability.IStorage<IAffinityData> {
        public NBTBase writeNBT(Capability<IAffinityData> capability, IAffinityData instance, EnumFacing side) {
            NBTTagCompound tmp;
            NBTTagCompound nbt = new NBTTagCompound();
            for (Map.Entry<Affinity, Double> entry : instance.getAffinities().entrySet()) {
                Affinity.writeToNBT(nbt, entry.getKey(), entry.getValue());
            }
            NBTTagCompound am2Tag = NBTUtils.getAM2Tag(nbt);
            NBTTagList cooldowns = NBTUtils.addCompoundList(am2Tag, "Cooldowns");
            for (Map.Entry<String, Integer> entry : instance.getCooldowns().entrySet()) {
                NBTTagCompound tmp2 = new NBTTagCompound();
                tmp2.func_74778_a("Name", entry.getKey());
                tmp2.func_74768_a("Value", entry.getValue().intValue());
                cooldowns.func_74742_a((NBTBase)tmp2);
            }
            am2Tag.func_74782_a("Cooldowns", (NBTBase)cooldowns);
            NBTTagList floats = NBTUtils.addCompoundList(am2Tag, "Floats");
            NBTTagList booleans = NBTUtils.addCompoundList(am2Tag, "Booleans");
            for (Map.Entry<String, Float> entry : instance.getAbilityFloatMap().entrySet()) {
                tmp = new NBTTagCompound();
                tmp.func_74778_a("Name", entry.getKey());
                tmp.func_74776_a("Value", entry.getValue().floatValue());
                floats.func_74742_a((NBTBase)tmp);
            }
            for (Map.Entry<String, Constable> entry : instance.getAbilityBooleanMap().entrySet()) {
                tmp = new NBTTagCompound();
                tmp.func_74778_a("Name", entry.getKey());
                tmp.func_74757_a("Value", ((Boolean)entry.getValue()).booleanValue());
                booleans.func_74742_a((NBTBase)tmp);
            }
            am2Tag.func_74782_a("Floats", (NBTBase)floats);
            am2Tag.func_74782_a("Booleans", (NBTBase)booleans);
            return nbt;
        }

        public void readNBT(Capability<IAffinityData> capability, IAffinityData instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tmp;
            int i;
            ArrayList<Affinity> affinities = Affinity.readFromNBT((NBTTagCompound)nbt);
            for (Affinity aff : affinities) {
                instance.setAffinityDepth(aff, aff.readDepth((NBTTagCompound)nbt));
            }
            NBTTagCompound am2Tag = NBTUtils.getAM2Tag((NBTTagCompound)nbt);
            NBTTagList cooldowns = NBTUtils.addCompoundList(am2Tag, "Cooldowns");
            NBTTagList floats = NBTUtils.addCompoundList(am2Tag, "Floats");
            NBTTagList booleans = NBTUtils.addCompoundList(am2Tag, "Booleans");
            for (i = 0; i < cooldowns.func_74745_c(); ++i) {
                tmp = cooldowns.func_150305_b(i);
                instance.addCooldown(tmp.func_74779_i("Name"), tmp.func_74762_e("Value"));
            }
            for (i = 0; i < floats.func_74745_c(); ++i) {
                tmp = floats.func_150305_b(i);
                instance.addAbilityFloat(tmp.func_74779_i("Name"), tmp.func_74760_g("Value"));
            }
            for (i = 0; i < booleans.func_74745_c(); ++i) {
                tmp = booleans.func_150305_b(i);
                instance.addAbilityBoolean(tmp.func_74779_i("Name"), tmp.func_74767_n("Value"));
            }
        }
    }
}

