/*
 * Decompiled with CFR 0.152.
 */
package am2.api.compendium.wrapper;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class StackMapWrapper {
    private final Map<ItemStack, Integer> input;
    private final String name;

    private static Map<ItemStack, Integer> wrapBlockMap(Map<IBlockState, Integer> input) {
        HashMap<ItemStack, Integer> wrappedMap = new HashMap<ItemStack, Integer>();
        for (Map.Entry<IBlockState, Integer> entry : input.entrySet()) {
            Item item;
            if (entry.getValue() == null || entry.getKey() == null || (item = Item.func_150898_a((Block)entry.getKey().func_177230_c())) == null) continue;
            wrappedMap.put(new ItemStack(item, 1, entry.getKey().func_177230_c().func_176201_c(entry.getKey())), entry.getValue());
        }
        return wrappedMap;
    }

    private static Map<ItemStack, Integer> removeNullItems(Map<ItemStack, Integer> input) {
        HashMap<ItemStack, Integer> wrappedMap = new HashMap<ItemStack, Integer>();
        for (Map.Entry<ItemStack, Integer> entry : input.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null) continue;
            wrappedMap.put(entry.getKey(), entry.getValue());
        }
        return wrappedMap;
    }

    private static Map<ItemStack, Integer> orderMap(Map<ItemStack, Integer> input) {
        int max = -1;
        for (Map.Entry<ItemStack, Integer> entry : input.entrySet()) {
            if (entry.getValue() == null || entry.getValue() <= max) continue;
            max = entry.getValue();
        }
        HashMap<ItemStack, Integer> wrappedMap = new HashMap<ItemStack, Integer>();
        for (int i = 0; i <= max; ++i) {
            for (Map.Entry<ItemStack, Integer> entry : input.entrySet()) {
                if (entry.getValue() == null || entry.getValue() != i) continue;
                wrappedMap.put(entry.getKey(), entry.getValue());
            }
        }
        return wrappedMap;
    }

    public StackMapWrapper(Map<ItemStack, Integer> input, String name) {
        this.input = StackMapWrapper.orderMap(StackMapWrapper.removeNullItems(input));
        this.name = name;
    }

    public StackMapWrapper(Map<IBlockState, Integer> input, String name, boolean placeholder) {
        this(StackMapWrapper.wrapBlockMap(input), name);
    }

    public Map<ItemStack, Integer> getInput() {
        return this.input;
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }
}

