/*
 * Decompiled with CFR 0.152.
 */
package am2.api.compendium.pages;

import am2.api.ArsMagicaAPI;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.compendium.pages.PageEntity;
import am2.api.compendium.pages.PageItemStack;
import am2.api.compendium.pages.PageMultiblock;
import am2.api.compendium.pages.PageRitual;
import am2.api.compendium.pages.PageSkill;
import am2.api.compendium.pages.PageSpellComponent;
import am2.api.compendium.pages.PageStackMap;
import am2.api.compendium.pages.PageText;
import am2.api.compendium.wrapper.StackMapWrapper;
import am2.api.rituals.IRitualInteraction;
import am2.api.skill.Skill;
import am2.api.spell.AbstractSpellPart;
import am2.defs.ItemDefs;
import am2.power.PowerTypes;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class CompendiumPage<E> {
    private static final HashMap<Class<?>, Class<? extends CompendiumPage<?>>> HANDLERS = new HashMap();
    protected E element;
    protected Minecraft mc;
    protected float zLevel;

    public static final <E> void registerPageType(Class<? extends CompendiumPage<E>> page, Class<E> clazz) {
        HANDLERS.put(clazz, page);
    }

    public CompendiumPage(E element) {
        this.element = element;
        this.mc = Minecraft.func_71410_x();
    }

    protected abstract void renderPage(int var1, int var2, int var3, int var4);

    public final void render(int posX, int posY, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        try {
            this.renderPage(posX, posY, mouseX, mouseY);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
    }

    public GuiButton[] getButtons(int id, int posX, int posY) {
        return new GuiButton[0];
    }

    public void switchButtonDisplay(boolean shouldShow) {
    }

    public void actionPerformed(GuiButton button) throws IOException {
    }

    public void dragMouse(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }

    protected void drawHoveringText(List<String> par1List, int par2, int par3, FontRenderer font) {
        if (!par1List.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int k = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            this.zLevel = 300.0f;
            Minecraft.func_71410_x().func_175599_af().field_77023_b = 300.0f;
            int l1 = -267386864;
            this.drawGradientRect(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.drawGradientRect(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.drawGradientRect(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.drawGradientRect(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = par1List.get(k2);
                font.func_175063_a(s1, (float)i1, (float)j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.zLevel = 0.0f;
            Minecraft.func_71410_x().func_175599_af().field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    protected void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)right, (double)top, (double)this.zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, (double)this.zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)bottom, (double)this.zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, (double)this.zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    protected void renderItemToolTip(ItemStack stack, int x, int y) {
        try {
            FontRenderer font;
            List list = stack.func_82840_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71474_y.field_82882_x);
            if (!(stack.func_77973_b() instanceof ItemBlock)) {
                if (stack.func_77973_b() == ItemDefs.spell_component) {
                    list.clear();
                    Skill skill = (Skill)ArsMagicaAPI.getSkillRegistry().getObjectById(stack.func_77952_i());
                    if (skill == null) {
                        return;
                    }
                    list.add(skill.getName());
                } else if (stack.func_77973_b() == ItemDefs.etherium) {
                    list.clear();
                    list.add(stack.field_77994_a + " " + I18n.func_74838_a((String)"item.arsmagica2:etherium.name"));
                    ArrayList<String> subList = new ArrayList<String>();
                    for (PowerTypes type : PowerTypes.all()) {
                        if ((stack.func_77952_i() & type.ID()) != type.ID()) continue;
                        subList.add(type.getChatColor() + I18n.func_74838_a((String)("etherium." + type.name() + ".name")));
                    }
                    if (subList.size() == PowerTypes.all().size()) {
                        list.add(TextFormatting.GRAY.toString() + I18n.func_74838_a((String)"etherium.any.name"));
                    } else {
                        list.addAll(subList);
                    }
                }
            }
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    list.set(k, stack.func_77953_t().field_77937_e.toString() + (String)list.get(k));
                    continue;
                }
                list.set(k, TextFormatting.GRAY.toString() + (String)list.get(k));
            }
            if (((String)list.get(0)).indexOf(10) != -1) {
                String s = (String)list.get(0);
                String colorPrefix = "";
                list.remove(0);
                colorPrefix = stack.func_77953_t().field_77937_e.toString();
                String[] split = s.split("\n");
                for (int i = split.length - 1; i >= 0; --i) {
                    list.add(0, colorPrefix + split[i]);
                }
            }
            this.drawHoveringText(list, x, y, (font = stack.func_77973_b().getFontRenderer(stack)) == null ? this.mc.field_71466_p : font);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final <E> CompendiumPage<E> getCompendiumPage(Class<? extends E> clazz, E element) {
        for (Map.Entry<Class<?>, Class<CompendiumPage<?>>> entry : HANDLERS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            try {
                Constructor<CompendiumPage<?>> constructor = entry.getValue().getConstructor(entry.getKey());
                return constructor.newInstance(element);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        System.out.println("No handlers found for " + clazz.getSimpleName());
        return null;
    }

    public void drawTexturedModalRect_Classic(int dst_x, int dst_y, int src_x, int src_y, int dst_width, int dst_height, int src_width, int src_height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.func_178181_a();
        var9.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        var9.func_178180_c().func_181662_b((double)(dst_x + 0), (double)(dst_y + dst_height), (double)this.zLevel).func_187315_a((double)((float)(src_x + 0) * var7), (double)((float)(src_y + src_height) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + dst_width), (double)(dst_y + dst_height), (double)this.zLevel).func_187315_a((double)((float)(src_x + src_width) * var7), (double)((float)(src_y + src_height) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + dst_width), (double)(dst_y + 0), (double)this.zLevel).func_187315_a((double)((float)(src_x + src_width) * var7), (double)((float)(src_y + 0) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + 0), (double)(dst_y + 0), (double)this.zLevel).func_187315_a((double)((float)(src_x + 0) * var7), (double)((float)(src_y + 0) * var8)).func_181675_d();
        var9.func_78381_a();
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
    }

    static {
        CompendiumPage.registerPageType(PageItemStack.class, ItemStack.class);
        CompendiumPage.registerPageType(PageText.class, String.class);
        CompendiumPage.registerPageType(PageSpellComponent.class, AbstractSpellPart.class);
        CompendiumPage.registerPageType(PageStackMap.class, StackMapWrapper.class);
        CompendiumPage.registerPageType(PageMultiblock.class, MultiblockStructureDefinition.class);
        CompendiumPage.registerPageType(PageRitual.class, IRitualInteraction.Wrapper.class);
        CompendiumPage.registerPageType(PageSkill.class, Skill.class);
        CompendiumPage.registerPageType(PageEntity.class, Entity.class);
    }
}

