/*
 * Decompiled with CFR 0.152.
 */
package am2.api.compendium;

import am2.api.compendium.CompendiumCategory;
import am2.api.compendium.pages.CompendiumPage;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CompendiumEntry {
    private CompendiumCategory category;
    private String id;
    private Object renderObject;
    private ArrayList<Object> objects;
    private boolean isDefaultUnlocked;

    public CompendiumEntry(@Nullable Object renderObject, String id) {
        if (id.contains("\\.")) {
            throw new IllegalArgumentException("Entry ids can't contain \"\\.\"");
        }
        this.id = id;
        this.objects = new ArrayList();
        this.renderObject = renderObject;
    }

    protected CompendiumEntry setCategory(CompendiumCategory category) {
        this.category = category;
        return this;
    }

    public boolean canBeDisplayed(String categoryID) {
        return categoryID.equals(this.category.getID());
    }

    public String getID() {
        return this.category.getID() + "." + this.id;
    }

    public String getName() {
        return I18n.func_74838_a((String)("compendium." + this.getID() + ".name"));
    }

    public String getDescription() {
        return I18n.func_74838_a((String)("compendium." + this.getID() + ".desc"));
    }

    public boolean isDefaultUnlocked() {
        return this.isDefaultUnlocked;
    }

    public Object getRenderObject() {
        return this.renderObject;
    }

    public CompendiumEntry setUnlocked() {
        this.isDefaultUnlocked = true;
        return this;
    }

    public CompendiumEntry addObject(Object obj) {
        this.objects.add(obj);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<CompendiumPage<?>> getPages() {
        ArrayList pages = new ArrayList();
        for (Object obj : this.objects) {
            CompendiumPage<Object> page;
            if (obj == null || (page = CompendiumPage.getCompendiumPage(obj.getClass(), obj)) == null) continue;
            pages.add(page);
        }
        return pages;
    }

    public ImmutableList<Object> getObjects() {
        return ImmutableList.copyOf(this.objects);
    }
}

