/*
 * Decompiled with CFR 0.152.
 */
package am2.api.compendium;

import am2.api.compendium.CompendiumEntry;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class CompendiumCategory {
    private static final ArrayList<CompendiumCategory> CATEGORIES = new ArrayList();
    public static final CompendiumCategory GUIDE = CompendiumCategory.createCompendiumCategory("guide", new ResourceLocation("arsmagica2", "items/arcanecompendium"));
    public static final CompendiumCategory MECHANIC = CompendiumCategory.createCompendiumCategory("mechanic", new ResourceLocation("arsmagica2", "items/magitech_goggle"));
    public static final CompendiumCategory MECHANIC_AFFINITY = CompendiumCategory.createCompendiumCategory("mechanic.affinity", new ResourceLocation("missingno"));
    public static final CompendiumCategory MECHANIC_ENCHANTS = CompendiumCategory.createCompendiumCategory("mechanic.enchants", new ResourceLocation("missingno"));
    public static final CompendiumCategory MECHANIC_INFUSIONS = CompendiumCategory.createCompendiumCategory("mechanic.infusions", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM = CompendiumCategory.createCompendiumCategory("item", new ResourceLocation("arsmagica2", "items/essence_ice"));
    public static final CompendiumCategory ITEM_ORE = CompendiumCategory.createCompendiumCategory("item.ore", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_ESSENCE = CompendiumCategory.createCompendiumCategory("item.essence", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_RUNE = CompendiumCategory.createCompendiumCategory("item.rune", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_ARMOR = CompendiumCategory.createCompendiumCategory("item.armor", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_ARMOR_MAGE = CompendiumCategory.createCompendiumCategory("item.armor.mage", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_ARMOR_BATTLEMAGE = CompendiumCategory.createCompendiumCategory("item.armor.battlemage", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_AFFINITYTOME = CompendiumCategory.createCompendiumCategory("item.affinity_tomes", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_FOCI = CompendiumCategory.createCompendiumCategory("item.foci", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_MANAPOTION = CompendiumCategory.createCompendiumCategory("item.mana_potion", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_BINDINGCATALYST = CompendiumCategory.createCompendiumCategory("item.binding_catalyst", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_FLICKERFOCUS = CompendiumCategory.createCompendiumCategory("item.flickerfocus", new ResourceLocation("missingno"));
    public static final CompendiumCategory ITEM_INSCRIPTIONUPGRADES = CompendiumCategory.createCompendiumCategory("item.inscription_upgrades", new ResourceLocation("missingno"));
    public static final CompendiumCategory BLOCK = CompendiumCategory.createCompendiumCategory("block", new ResourceLocation("arsmagica2", "items/crystal_wrench"));
    public static final CompendiumCategory BLOCK_ILLUSIONBLOCKS = CompendiumCategory.createCompendiumCategory("block.illusionblocks", new ResourceLocation("missingno"));
    public static final CompendiumCategory BLOCK_CRYSTALMARKER = CompendiumCategory.createCompendiumCategory("block.crystalmarker", new ResourceLocation("missingno"));
    public static final CompendiumCategory BLOCK_INLAYS = CompendiumCategory.createCompendiumCategory("block.inlays", new ResourceLocation("missingno"));
    public static final CompendiumCategory SPELL_SHAPE = CompendiumCategory.createCompendiumCategory("shape", new ResourceLocation("arsmagica2", "items/spells/shapes/Binding"));
    public static final CompendiumCategory SPELL_COMPONENT = CompendiumCategory.createCompendiumCategory("component", new ResourceLocation("arsmagica2", "items/spells/components/LifeTap"));
    public static final CompendiumCategory SPELL_MODIFIER = CompendiumCategory.createCompendiumCategory("modifier", new ResourceLocation("arsmagica2", "items/spells/modifiers/VelocityAdded"));
    public static final CompendiumCategory TALENT = CompendiumCategory.createCompendiumCategory("talent", new ResourceLocation("arsmagica2", "items/spells/skills/AugmentedCasting"));
    public static final CompendiumCategory MOB = CompendiumCategory.createCompendiumCategory("mob", new ResourceLocation("arsmagica2", "gui_icons/Fatigue_Icon"));
    public static final CompendiumCategory MOB_FLICKER = CompendiumCategory.createCompendiumCategory("mob.flicker", new ResourceLocation("missingno"));
    public static final CompendiumCategory STRUCTURE = CompendiumCategory.createCompendiumCategory("structure", new ResourceLocation("arsmagica2", "gui_icons/gateway"));
    public static final CompendiumCategory BOSS = CompendiumCategory.createCompendiumCategory("boss", new ResourceLocation("arsmagica2", "items/evilBook"));
    private ArrayList<CompendiumEntry> entries;
    private String id;
    private ResourceLocation sprite;
    private String[] parents;

    public static CompendiumCategory createCompendiumCategory(String id, ResourceLocation sprite) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException("ID Can't be null");
        }
        int num = id.split("\\.").length - 1;
        String[] parents = new String[num];
        for (int i = 0; i < num; ++i) {
            parents[i] = id.split("\\.")[i];
        }
        CompendiumCategory category = new CompendiumCategory(id.split("\\.")[num], sprite, parents);
        CATEGORIES.add(category);
        return category;
    }

    private CompendiumCategory(String id, ResourceLocation sprite, String[] parents) {
        this.id = id;
        this.sprite = sprite;
        this.entries = new ArrayList();
        this.parents = parents;
    }

    public boolean hasParents() {
        return this.parents.length > 0;
    }

    public String[] getParents() {
        return this.parents;
    }

    public String getParentsString() {
        String str = "";
        boolean first = true;
        for (String p : this.parents) {
            str = first ? str + p : str + "." + p;
            first = false;
        }
        return str;
    }

    public String getID() {
        return (this.hasParents() ? this.getParentsString() + "." : "") + this.id;
    }

    public ResourceLocation getSprite() {
        return this.sprite;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(this.getSprite().toString());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerTexture(TextureMap map) {
        map.func_174942_a(this.getSprite());
    }

    public void addEntry(CompendiumEntry entry) {
        this.entries.add(entry.setCategory(this));
    }

    public String getCategoryName() {
        return I18n.func_74838_a((String)("compendium.category." + this.getID() + ".name"));
    }

    public static ImmutableList<CompendiumCategory> getCategories() {
        return ImmutableList.copyOf(CATEGORIES);
    }

    public static CompendiumEntry getEntryByID(String id) {
        for (CompendiumCategory category : CompendiumCategory.getCategories()) {
            for (CompendiumEntry entry : category.getEntries()) {
                if (!entry.getID().equals(id)) continue;
                return entry;
            }
        }
        return null;
    }

    public static CompendiumCategory getCategoryFromID(String id) {
        for (CompendiumCategory category : CATEGORIES) {
            if (!category.getID().equals(id)) continue;
            return category;
        }
        return null;
    }

    public static ImmutableList<CompendiumEntry> getAllEntries() {
        ArrayList<CompendiumEntry> builder = new ArrayList<CompendiumEntry>();
        for (CompendiumCategory category : CompendiumCategory.getCategories()) {
            builder.addAll((Collection<CompendiumEntry>)category.getEntries());
        }
        return ImmutableList.copyOf(builder);
    }

    public ImmutableList<CompendiumEntry> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }
}

