/*
 * Decompiled with CFR 0.152.
 */
package am2.api.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MultiblockGroup {
    protected ArrayList<BlockPos> positions = new ArrayList();
    protected ArrayList<IBlockState> states;
    protected boolean ignoreState;
    protected String name;

    public MultiblockGroup(String name, ArrayList<IBlockState> arrayList, boolean ignoreState) {
        this.states = arrayList;
        this.ignoreState = ignoreState;
        this.name = name;
    }

    public void addBlock(BlockPos position) {
        this.positions.add(position);
    }

    public void addState(IBlockState state) {
        this.states.add(state);
    }

    public boolean matches(World world, BlockPos startCheckPos) {
        boolean flag = true;
        for (BlockPos pos : this.positions) {
            boolean subFlag;
            if (this.ignoreState) {
                subFlag = false;
                for (IBlockState state : this.states) {
                    subFlag = world.func_180495_p(startCheckPos.func_177971_a((Vec3i)pos)).func_177230_c().equals(state.func_177230_c());
                    if (!subFlag) continue;
                    break;
                }
                flag = subFlag;
            } else {
                subFlag = false;
                for (IBlockState state : this.states) {
                    subFlag = world.func_180495_p(startCheckPos.func_177971_a((Vec3i)pos)).equals(state);
                    if (!subFlag) continue;
                    break;
                }
                flag = subFlag;
            }
            if (flag) continue;
            break;
        }
        return flag;
    }

    public int getMinX() {
        int min = Integer.MAX_VALUE;
        for (BlockPos pos : this.positions) {
            if (pos.func_177958_n() >= min) continue;
            min = pos.func_177958_n();
        }
        return min;
    }

    public int getMinY() {
        int min = Integer.MAX_VALUE;
        for (BlockPos pos : this.positions) {
            if (pos.func_177956_o() >= min) continue;
            min = pos.func_177956_o();
        }
        return min;
    }

    public int getMinZ() {
        int min = Integer.MAX_VALUE;
        for (BlockPos pos : this.positions) {
            if (pos.func_177952_p() >= min) continue;
            min = pos.func_177952_p();
        }
        return min;
    }

    public int getMaxX() {
        int max = Integer.MIN_VALUE;
        for (BlockPos pos : this.positions) {
            if (pos.func_177958_n() <= max) continue;
            max = pos.func_177958_n();
        }
        return max;
    }

    public int getMaxY() {
        int max = Integer.MIN_VALUE;
        for (BlockPos pos : this.positions) {
            if (pos.func_177956_o() <= max) continue;
            max = pos.func_177956_o();
        }
        return max;
    }

    public int getMaxZ() {
        int max = Integer.MIN_VALUE;
        for (BlockPos pos : this.positions) {
            if (pos.func_177952_p() <= max) continue;
            max = pos.func_177952_p();
        }
        return max;
    }

    public MultiblockGroup rotate(int mode) {
        MultiblockGroup group = new MultiblockGroup(this.name, this.states, this.ignoreState);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (BlockPos pos : positions) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (mode % 2 == 1) {
                int saveX = z;
                int saveZ = x;
                x = saveX;
                z = saveZ;
            }
            if (mode % 4 >= 2) {
                x = -x;
                z = -z;
            }
            positions.add(new BlockPos(x, y, z));
        }
        group.positions = positions;
        return group;
    }

    public ImmutableList<BlockPos> getPositions() {
        return ImmutableList.copyOf(this.positions);
    }

    public ImmutableList<IBlockState> getStates() {
        return ImmutableList.copyOf(this.states);
    }
}

