/*
 * Decompiled with CFR 0.152.
 */
package am2.api.affinity;

import am2.api.ArsMagicaAPI;
import am2.utils.NBTUtils;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class Affinity
extends IForgeRegistryEntry.Impl<Affinity>
implements Comparable<Affinity> {
    private static final ResourceLocation NONE_LOC = new ResourceLocation("arsmagica2", "none");
    private static final ResourceLocation ARCANE_LOC = new ResourceLocation("arsmagica2", "arcane");
    private static final ResourceLocation WATER_LOC = new ResourceLocation("arsmagica2", "water");
    private static final ResourceLocation FIRE_LOC = new ResourceLocation("arsmagica2", "fire");
    private static final ResourceLocation EARTH_LOC = new ResourceLocation("arsmagica2", "earth");
    private static final ResourceLocation AIR_LOC = new ResourceLocation("arsmagica2", "air");
    private static final ResourceLocation LIGHTNING_LOC = new ResourceLocation("arsmagica2", "lightning");
    private static final ResourceLocation ICE_LOC = new ResourceLocation("arsmagica2", "ice");
    private static final ResourceLocation NATURE_LOC = new ResourceLocation("arsmagica2", "nature");
    private static final ResourceLocation LIFE_LOC = new ResourceLocation("arsmagica2", "life");
    private static final ResourceLocation ENDER_LOC = new ResourceLocation("arsmagica2", "ender");
    public static final Affinity NONE = new Affinity("none", 0xFFFFFF).setDirectOpposite(NONE_LOC);
    public static final Affinity ARCANE = new Affinity("arcane", 12137933).setDirectOpposite(NATURE_LOC).addMajorOpposite(LIFE_LOC, EARTH_LOC, WATER_LOC, ICE_LOC).addMinorOpposite(AIR_LOC, ENDER_LOC);
    public static final Affinity WATER = new Affinity("water", 744687).setDirectOpposite(FIRE_LOC).addMajorOpposite(LIGHTNING_LOC, EARTH_LOC, ARCANE_LOC, ENDER_LOC).addMinorOpposite(AIR_LOC, ICE_LOC);
    public static final Affinity FIRE = new Affinity("fire", 15672843).setDirectOpposite(WATER_LOC).addMajorOpposite(AIR_LOC, ICE_LOC, NATURE_LOC, LIFE_LOC).addMinorOpposite(EARTH_LOC, LIGHTNING_LOC);
    public static final Affinity EARTH = new Affinity("earth", 6370059).setDirectOpposite(AIR_LOC).addMajorOpposite(WATER_LOC, ARCANE_LOC, LIFE_LOC, LIGHTNING_LOC).addMinorOpposite(NATURE_LOC, FIRE_LOC);
    public static final Affinity AIR = new Affinity("air", 0x777777).setDirectOpposite(EARTH_LOC).addMajorOpposite(NATURE_LOC, FIRE_LOC, ICE_LOC, ENDER_LOC).addMinorOpposite(WATER_LOC, ARCANE_LOC);
    public static final Affinity LIGHTNING = new Affinity("lightning", 14601753).setDirectOpposite(ICE_LOC).addMajorOpposite(WATER_LOC, ENDER_LOC, NATURE_LOC, EARTH_LOC).addMinorOpposite(LIFE_LOC, FIRE_LOC);
    public static final Affinity ICE = new Affinity("ice", 13887740).setDirectOpposite(LIGHTNING_LOC).addMajorOpposite(LIFE_LOC, FIRE_LOC, AIR_LOC, ARCANE_LOC).addMinorOpposite(WATER_LOC, ENDER_LOC);
    public static final Affinity NATURE = new Affinity("nature", 2262808).setDirectOpposite(ARCANE_LOC).addMajorOpposite(AIR_LOC, ENDER_LOC, LIGHTNING_LOC, FIRE_LOC).addMinorOpposite(LIFE_LOC, EARTH_LOC);
    public static final Affinity LIFE = new Affinity("life", 3465506).setDirectOpposite(ENDER_LOC).addMajorOpposite(ARCANE_LOC, ICE_LOC, FIRE_LOC, EARTH_LOC).addMinorOpposite(NATURE_LOC, LIGHTNING_LOC);
    public static final Affinity ENDER = new Affinity("ender", 4129853).setDirectOpposite(LIFE_LOC).addMajorOpposite(NATURE_LOC, LIGHTNING_LOC, WATER_LOC, AIR_LOC).addMinorOpposite(ARCANE_LOC, ICE_LOC);
    private int color;
    private String name;
    private ResourceLocation directOpposite;
    private ArrayList<ResourceLocation> majorOpposites = new ArrayList();
    private ArrayList<ResourceLocation> minorOpposites = new ArrayList();

    public static void registerAffinities() {
        GameRegistry.register((IForgeRegistryEntry)NONE, (ResourceLocation)NONE_LOC);
        GameRegistry.register((IForgeRegistryEntry)ARCANE, (ResourceLocation)ARCANE_LOC);
        GameRegistry.register((IForgeRegistryEntry)WATER, (ResourceLocation)WATER_LOC);
        GameRegistry.register((IForgeRegistryEntry)FIRE, (ResourceLocation)FIRE_LOC);
        GameRegistry.register((IForgeRegistryEntry)EARTH, (ResourceLocation)EARTH_LOC);
        GameRegistry.register((IForgeRegistryEntry)AIR, (ResourceLocation)AIR_LOC);
        GameRegistry.register((IForgeRegistryEntry)LIGHTNING, (ResourceLocation)LIGHTNING_LOC);
        GameRegistry.register((IForgeRegistryEntry)ICE, (ResourceLocation)ICE_LOC);
        GameRegistry.register((IForgeRegistryEntry)NATURE, (ResourceLocation)NATURE_LOC);
        GameRegistry.register((IForgeRegistryEntry)LIFE, (ResourceLocation)LIFE_LOC);
        GameRegistry.register((IForgeRegistryEntry)ENDER, (ResourceLocation)ENDER_LOC);
    }

    public Affinity(String name, int color) {
        this.color = color;
        this.name = name;
    }

    public int getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalisedName());
    }

    public String getUnlocalisedName() {
        return "affinity." + this.name;
    }

    public static void writeToNBT(NBTTagCompound tag, Affinity affinity, double depth) {
        NBTTagList affinityTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(tag), "Affinity");
        NBTTagCompound tmp = new NBTTagCompound();
        tmp.func_74778_a("Name", affinity.getRegistryName().toString());
        tmp.func_74780_a("Depth", depth);
        affinityTag.func_74742_a((NBTBase)tmp);
        NBTUtils.getAM2Tag(tag).func_74782_a("Affinity", (NBTBase)affinityTag);
    }

    public static ArrayList<Affinity> readFromNBT(NBTTagCompound tag) {
        NBTTagList affinityTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(tag), "Affinity");
        ArrayList<Affinity> affinities = new ArrayList<Affinity>();
        for (int i = 0; i < affinityTag.func_74745_c(); ++i) {
            NBTTagCompound tmp = affinityTag.func_150305_b(i);
            Affinity aff = (Affinity)ArsMagicaAPI.getAffinityRegistry().getObject(new ResourceLocation(tmp.func_74779_i("Name")));
            affinities.add(aff);
        }
        return affinities;
    }

    public double readDepth(NBTTagCompound tag) {
        NBTTagList affinityTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(tag), "Affinity");
        for (int i = 0; i < affinityTag.func_74745_c(); ++i) {
            NBTTagCompound tmp = affinityTag.func_150305_b(i);
            if (!tmp.func_74779_i("Name").equals(this.getRegistryName().toString())) continue;
            return tmp.func_74769_h("Depth");
        }
        return 0.0;
    }

    @Override
    public int compareTo(Affinity b) {
        return ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)b) - ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)this);
    }

    public ArrayList<Affinity> getMinorOpposingAffinities() {
        ArrayList<Affinity> returnList = new ArrayList<Affinity>();
        for (ResourceLocation rl : this.minorOpposites) {
            Affinity aff = (Affinity)ArsMagicaAPI.getAffinityRegistry().getObject(rl);
            if (aff == NONE) continue;
            returnList.add(aff);
        }
        return returnList;
    }

    public ArrayList<Affinity> getMajorOpposingAffinities() {
        ArrayList<Affinity> returnList = new ArrayList<Affinity>();
        for (ResourceLocation rl : this.majorOpposites) {
            Affinity aff = (Affinity)ArsMagicaAPI.getAffinityRegistry().getObject(rl);
            if (aff == NONE) continue;
            returnList.add(aff);
        }
        return returnList;
    }

    public ArrayList<Affinity> getAdjacentAffinities() {
        ArrayList<Affinity> returnList = new ArrayList<Affinity>();
        for (ResourceLocation rl : ArsMagicaAPI.getAffinityRegistry().func_148742_b()) {
            Affinity aff = (Affinity)ArsMagicaAPI.getAffinityRegistry().getObject(rl);
            if (aff == NONE || this.majorOpposites.contains(rl) || this.minorOpposites.contains(rl) || this.directOpposite == rl || aff == this) continue;
            returnList.add(aff);
        }
        return returnList;
    }

    public Affinity getOpposingAffinity() {
        return (Affinity)ArsMagicaAPI.getAffinityRegistry().getObject(this.directOpposite);
    }

    public Affinity setDirectOpposite(ResourceLocation directOpposite) {
        this.directOpposite = directOpposite;
        return this;
    }

    public Affinity addMajorOpposite(ResourceLocation ... rls) {
        for (ResourceLocation rl : rls) {
            this.majorOpposites.add(rl);
        }
        return this;
    }

    public Affinity addMinorOpposite(ResourceLocation ... rls) {
        for (ResourceLocation rl : rls) {
            this.minorOpposites.add(rl);
        }
        return this;
    }

    public static class AffinityComparator
    implements Comparator<Affinity> {
        @Override
        public int compare(Affinity o1, Affinity o2) {
            return o1.compareTo(o2);
        }
    }
}

