/*
 * Decompiled with CFR 0.152.
 */
package am2.api.affinity;

import am2.api.affinity.Affinity;
import am2.api.event.SpellCastEvent;
import am2.extensions.AffinityData;
import javax.annotation.Nullable;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public abstract class AbstractAffinityAbility
extends IForgeRegistryEntry.Impl<AbstractAffinityAbility> {
    protected AbstractAffinityAbility(ResourceLocation identifier) {
        this.setRegistryName(identifier);
    }

    public abstract float getMinimumDepth();

    public float getMaximumDepth() {
        return -1.0f;
    }

    public abstract Affinity getAffinity();

    @Nullable
    public KeyBinding getKey() {
        return null;
    }

    public boolean canApply(EntityPlayer player) {
        return this.isEligible(player);
    }

    public boolean isEligible(EntityPlayer player) {
        Affinity aff = this.getAffinity();
        if (aff == Affinity.NONE || aff == null) {
            return false;
        }
        AffinityData data = AffinityData.For((EntityLivingBase)player);
        double depth = data.getAffinityDepth(aff);
        if (this.getMaximumDepth() < 0.0f || this.getMaximumDepth() > 1.0f || this.getMaximumDepth() < this.getMinimumDepth()) {
            return depth >= (double)this.getMinimumDepth();
        }
        return depth >= (double)this.getMinimumDepth() && depth <= (double)this.getMaximumDepth();
    }

    public void applyTick(EntityPlayer player) {
    }

    public void applyKeyPress(EntityPlayer player) {
    }

    public void applyHurt(EntityPlayer player, LivingHurtEvent event, boolean isAttacker) {
    }

    public void applyFall(EntityPlayer player, LivingFallEvent event) {
    }

    public void applySpellCast(EntityPlayer player, SpellCastEvent.Post event) {
    }

    public void applyPreSpellCast(EntityPlayer player, SpellCastEvent.Pre event) {
    }

    public void applyDeath(EntityPlayer player, LivingDeathEvent event) {
    }

    public void applyKill(EntityPlayer player, LivingDeathEvent event) {
    }

    public void applyJump(EntityPlayer player, LivingEvent.LivingJumpEvent event) {
    }

    public void removeEffects(EntityPlayer player) {
    }

    public Runnable createRunnable(EntityPlayer player) {
        return new Apply(player, this);
    }

    public boolean hasMax() {
        return this.getMaximumDepth() >= 0.0f && this.getMaximumDepth() <= 1.0f && this.getMaximumDepth() > this.getMinimumDepth();
    }

    private static class Apply
    implements Runnable {
        private EntityPlayer player;
        private AbstractAffinityAbility ability;

        public Apply(EntityPlayer player, AbstractAffinityAbility ability) {
            this.player = player;
            this.ability = ability;
        }

        @Override
        public void run() {
            this.ability.applyKeyPress(this.player);
        }
    }
}

