/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.IPartConverter;
import mcmultipart.multipart.IPartFactory;
import mcmultipart.multipart.IReversePartConverter;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class MultipartRegistry {
    private static Map<BlockStateContainer, ResourceLocation> stateLocations = new HashMap<BlockStateContainer, ResourceLocation>();
    private static Map<ResourceLocation, BlockStateContainer> defaultStates = new HashMap<ResourceLocation, BlockStateContainer>();
    private static Map<ResourceLocation, IPartFactory.IAdvancedPartFactory> partProviders = new HashMap<ResourceLocation, IPartFactory.IAdvancedPartFactory>();
    private static BiMap<ResourceLocation, Class<? extends IMultipart>> partClasses = HashBiMap.create();
    private static Map<Block, IPartConverter> converters = new HashMap<Block, IPartConverter>();
    private static List<IReversePartConverter> reverseConverters = new ArrayList<IReversePartConverter>();

    public static void registerPartFactory(IPartFactory factory, String ... parts) {
        MultipartRegistry.registerPartFactory(factory == null ? null : new AdvancedPartFactory(factory), parts);
    }

    public static void registerPartFactory(IPartFactory.IAdvancedPartFactory factory, String ... parts) {
        if (factory == null) {
            throw new IllegalArgumentException("Attempted to register a null multipart factory!");
        }
        if (parts.length == 0) {
            throw new IllegalArgumentException("Attempted to register a multipart factory without any provided parts!");
        }
        for (String part : parts) {
            partProviders.put(MultipartRegistry.getResourceLocation(part), factory);
        }
        try {
            for (String part : parts) {
                IMultipart multipart = factory.createPart(MultipartRegistry.getResourceLocation(part), new NBTTagCompound());
                BlockStateContainer state = multipart.createBlockState();
                defaultStates.put(MultipartRegistry.getResourceLocation(part), state);
                stateLocations.put(state, multipart.getModelPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FMLCommonHandler.instance().exitJava(-1, true);
        }
    }

    public static void registerPart(Class<? extends IMultipart> clazz, String identifier) {
        if (clazz == null) {
            throw new IllegalArgumentException("Attempted to register a null multipart class!");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Attempted to register a multipart with a null identifier!");
        }
        if (partClasses.containsValue(clazz)) {
            throw new IllegalArgumentException("Attempted to register a multipart with a class that's already in use!");
        }
        if (partClasses.containsKey((Object)identifier)) {
            throw new IllegalArgumentException("Attempted to register a multipart with an identifier that's already in use!");
        }
        partClasses.put((Object)MultipartRegistry.getResourceLocation(identifier), clazz);
        MultipartRegistry.registerPartFactory(new SimplePartFactory(clazz), identifier);
    }

    private static ResourceLocation getResourceLocation(String identifier) {
        if (identifier.contains(":")) {
            return new ResourceLocation(identifier);
        }
        return new ResourceLocation(Loader.instance().activeModContainer().getModId(), identifier);
    }

    public static void registerPartConverter(IPartConverter converter) {
        for (Block block : converter.getConvertableBlocks()) {
            converters.put(block, converter);
        }
    }

    public static void registerReversePartConverter(IReversePartConverter converter) {
        reverseConverters.add(converter);
    }

    public static ResourceLocation getPartType(IMultipart part) {
        return (ResourceLocation)partClasses.inverse().get(part.getClass());
    }

    public static BlockStateContainer getDefaultState(IMultipart part) {
        return defaultStates.get(part.getType());
    }

    public static BlockStateContainer getDefaultState(ResourceLocation partType) {
        return defaultStates.get(partType);
    }

    public static ResourceLocation getStateLocation(BlockStateContainer state) {
        return stateLocations.get(state);
    }

    public static IMultipart createPart(ResourceLocation partType, NBTTagCompound tag) {
        IPartFactory.IAdvancedPartFactory factory = partProviders.get(partType);
        return factory == null ? null : factory.createPart(partType, tag);
    }

    public static IMultipart createPart(ResourceLocation partType, PacketBuffer buf) {
        IPartFactory.IAdvancedPartFactory factory = partProviders.get(partType);
        return factory == null ? null : factory.createPart(partType, buf);
    }

    public static Set<ResourceLocation> getRegisteredParts() {
        return partProviders.keySet();
    }

    public static boolean hasRegisteredParts() {
        return !partProviders.isEmpty();
    }

    public static Collection<? extends IMultipart> convert(IBlockAccess world, BlockPos pos, boolean simulated) {
        IPartConverter converter = converters.get(world.func_180495_p(pos).func_177230_c());
        if (converter != null) {
            return converter.convertBlock(world, pos, simulated);
        }
        return null;
    }

    public static boolean convertToBlock(IMultipartContainer container) {
        for (IReversePartConverter converter : reverseConverters) {
            if (!converter.convertToBlock(container)) continue;
            return true;
        }
        return false;
    }

    private static class AdvancedPartFactory
    implements IPartFactory.IAdvancedPartFactory {
        private final IPartFactory simpleFactory;

        public AdvancedPartFactory(IPartFactory simpleFactory) {
            this.simpleFactory = simpleFactory;
        }

        @Override
        public IMultipart createPart(ResourceLocation type, PacketBuffer buf) {
            try {
                IMultipart part = this.simpleFactory.createPart(type, true);
                part.readUpdatePacket(buf);
                return part;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public IMultipart createPart(ResourceLocation type, NBTTagCompound tag) {
            try {
                IMultipart part = this.simpleFactory.createPart(type, false);
                part.readFromNBT(tag);
                return part;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SimplePartFactory
    implements IPartFactory {
        private final Class<? extends IMultipart> partClass;

        public SimplePartFactory(Class<? extends IMultipart> partClass) {
            this.partClass = partClass;
        }

        @Override
        public IMultipart createPart(ResourceLocation type, boolean client) {
            try {
                return this.partClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

