/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps.transformers;

import guichaguri.betterfps.BetterFpsHelper;
import guichaguri.betterfps.transformers.ASMUtils;
import guichaguri.betterfps.transformers.Conditions;
import guichaguri.betterfps.transformers.Patch;
import guichaguri.betterfps.tweaker.BetterFpsTweaker;
import guichaguri.betterfps.tweaker.Mappings;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.tree.ClassNode;

public class PatcherTransformer
implements IClassTransformer {
    private static final Map<Mappings, String> patches = new HashMap<Mappings, String>();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode patchClass = this.findPatch(name);
        if (patchClass == null) {
            return bytes;
        }
        if (!Conditions.shouldPatch(patchClass.invisibleAnnotations)) {
            return bytes;
        }
        ClassNode classNode = ASMUtils.readClass(bytes, 0);
        Patch patch = new Patch(patchClass, classNode);
        BetterFpsHelper.LOG.info("Patching {}... ({})", new Object[]{transformedName, name});
        patch.copy();
        patch.patch();
        return ASMUtils.writeClass(classNode, 0);
    }

    private ClassNode findPatch(String name) {
        for (Mappings m : patches.keySet()) {
            if (!m.is(name)) continue;
            Conditions.patched.add(m);
            return this.loadPatch(patches.get((Object)m));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassNode loadPatch(String className) {
        String path = className + ".class";
        InputStream in = null;
        try {
            in = BetterFpsTweaker.getResourceStream(path);
            ClassNode classNode = ASMUtils.readClass(IOUtils.toByteArray((InputStream)in), 0);
            return classNode;
        }
        catch (IOException ex2) {
            BetterFpsHelper.LOG.error("Couldn't load patch from {}", new Object[]{className});
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return null;
    }

    static {
        patches.put(Mappings.C_Block, "guichaguri/betterfps/patches/block/BlockPatch");
        patches.put(Mappings.C_TileEntityHopper, "guichaguri/betterfps/patches/block/FastHopper");
        patches.put(Mappings.C_BlockHopper, "guichaguri/betterfps/patches/block/FastHopperBlock");
        patches.put(Mappings.C_TileEntityBeacon, "guichaguri/betterfps/patches/block/FastBeacon");
        patches.put(Mappings.C_TileEntityBeaconRenderer, "guichaguri/betterfps/patches/block/FastBeaconRender");
        patches.put(Mappings.C_EntityRenderer, "guichaguri/betterfps/patches/misc/FogPatch");
        patches.put(Mappings.C_GuiOptions, "guichaguri/betterfps/patches/misc/OptionsButton");
        patches.put(Mappings.C_Minecraft, "guichaguri/betterfps/patches/misc/MinecraftPatch");
        patches.put(Mappings.C_DedicatedServer, "guichaguri/betterfps/patches/misc/ServerPatch");
        patches.put(Mappings.C_EntityPlayerSP, "guichaguri/betterfps/patches/misc/ClientPlayerPatch");
        patches.put(Mappings.C_GuiContainerCreative, "guichaguri/betterfps/patches/misc/FastCreativeSearch");
    }
}

