/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps.installer;

import guichaguri.betterfps.installer.GuiInstaller;
import guichaguri.betterfps.json.Json;
import guichaguri.betterfps.json.JsonArray;
import guichaguri.betterfps.json.JsonObject;
import guichaguri.betterfps.json.JsonValue;
import guichaguri.betterfps.json.WriterConfig;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class BetterFpsInstaller {
    private static final String TWEAK_CLASS = "guichaguri.betterfps.tweaker.BetterFpsTweaker";
    private static final String LIBRARY_IDENTIFIER = "betterfps";
    private static final String LIBRARY_NAME = "BetterFps";
    private static final String VERSION_NAME = "1.4.4-1.10";
    private static final String[] LIBRARIES = new String[]{"org.ow2.asm:asm-all:5.0.3", "net.minecraft:launchwrapper:1.11"};
    private static final Properties i18n = new Properties();
    protected static File GAME_DIR = null;
    protected static String ALGORITHM = null;

    public static void main(String[] args) {
        String lang = String.format("%s_%s", System.getProperty("user.language"), System.getProperty("user.country"));
        BetterFpsInstaller.loadLanguage(lang);
        BetterFpsInstaller.info("Waiting for Swing to load...", new Object[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BetterFpsInstaller.loadUI();
            }
        });
    }

    private static void loadUI() {
        BetterFpsInstaller.info("Initializing Look and Feel...", new Object[0]);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex2) {
            BetterFpsInstaller.info("OS Look and Feel couldn't be loaded. Using the default instead.", new Object[0]);
        }
        BetterFpsInstaller.info("Initializing the UI...", new Object[0]);
        GuiInstaller installer = new GuiInstaller();
        installer.setVisible(true);
        BetterFpsInstaller.info("Checking for updates...", new Object[0]);
        try {
            BetterFpsInstaller.checkUpdates(installer);
        }
        catch (Exception ex3) {
            BetterFpsInstaller.info("Couldn't check for updates", new Object[0]);
        }
    }

    private static void loadLanguage(String lang) {
        String langPattern = "assets/betterfps/lang/%s.lang";
        lang = lang.toLowerCase();
        try {
            Charset utf8 = Charset.forName("UTF-8");
            BetterFpsInstaller.info("Loading en_us...", new Object[0]);
            InputStream in = BetterFpsInstaller.getResource(String.format("assets/betterfps/lang/%s.lang", "en_us"));
            if (in != null) {
                i18n.load(new InputStreamReader(in, utf8));
            }
            if (!lang.equals("en_us")) {
                BetterFpsInstaller.info("Loading %s...", lang);
                in = BetterFpsInstaller.getResource(String.format("assets/betterfps/lang/%s.lang", lang));
                if (in != null) {
                    i18n.load(new InputStreamReader(in, utf8));
                }
            }
        }
        catch (IOException ex2) {
            BetterFpsInstaller.error("Couldn't load the i18n data (%s)", lang);
            ex2.printStackTrace();
        }
    }

    public static void info(String log, Object ... data) {
        System.out.println(String.format(log, data));
    }

    public static void error(String log, Object ... data) {
        System.err.println(String.format(log, data));
    }

    public static InputStream getResource(String path) {
        return BetterFpsInstaller.class.getClassLoader().getResourceAsStream(path);
    }

    public static String i18n(String id, Object ... data) {
        String msg = i18n.getProperty(id, id);
        if (data.length > 0) {
            return String.format(msg, data);
        }
        return msg;
    }

    public static File getSuggestedMinecraftFolder() {
        String userHomeDir = System.getProperty("user.home", ".");
        String osType = System.getProperty("os.name").toLowerCase();
        if (osType.contains("win") && System.getenv("APPDATA") != null) {
            return new File(System.getenv("APPDATA"), ".minecraft");
        }
        if (osType.contains("mac")) {
            return new File(userHomeDir, "Library/Application Support/minecraft");
        }
        return new File(userHomeDir, ".minecraft");
    }

    public static void checkUpdates(GuiInstaller installer) throws IOException, URISyntaxException {
        String title;
        String msg;
        int r;
        URL url = new URL("http://widget.mcf.li/mc-mods/minecraft/229876-betterfps.json");
        InputStream in = url.openStream();
        JsonObject json = Json.parse(new InputStreamReader(in)).asObject();
        JsonObject versions = json.get("versions").asObject();
        JsonValue elem = versions.get("1.10.2");
        if (elem == null) {
            return;
        }
        JsonArray array = elem.asArray();
        if (array.isEmpty()) {
            return;
        }
        JsonObject latest = array.get(0).asObject();
        String version = latest.getString("name", VERSION_NAME);
        if (!version.contains(VERSION_NAME) && (r = JOptionPane.showConfirmDialog(installer, msg = (title = BetterFpsInstaller.i18n("betterfps.update.available", version)) + "\n" + BetterFpsInstaller.i18n("betterfps.update.prompt", new Object[0]), title, 0, 1)) == 0) {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(new URI(latest.getString("url", "http://guichaguri.github.io/BetterFps/")));
            installer.setVisible(false);
            System.exit(0);
        }
    }

    public static void saveAlgorithm() throws IOException {
        JsonObject json;
        if (ALGORITHM == null) {
            return;
        }
        if (GAME_DIR == null) {
            GAME_DIR = BetterFpsInstaller.getSuggestedMinecraftFolder();
        }
        BetterFpsInstaller.info("Changing the algorithm to %s...", ALGORITHM);
        File config = new File(GAME_DIR, "config/betterfps.json");
        if (config.exists()) {
            FileReader reader = new FileReader(config);
            json = Json.parse(reader).asObject();
            reader.close();
        } else {
            json = Json.object();
            config.getParentFile().mkdirs();
            config.createNewFile();
        }
        json.set("algorithm", ALGORITHM);
        FileWriter writer = new FileWriter(config);
        json.writeTo(writer);
        writer.close();
    }

    public static void copyLibrary(File gameDir) throws IOException {
        String path = String.format("libraries/%s/%s/%s", LIBRARY_IDENTIFIER, LIBRARY_NAME, VERSION_NAME);
        File libraryDir = new File(gameDir, path);
        libraryDir.mkdirs();
        File library = new File(libraryDir, String.format("%s-%s.jar", LIBRARY_NAME, VERSION_NAME));
        library.createNewFile();
        BetterFpsInstaller.copyMod(library);
    }

    public static void copyMod(File output) throws IOException {
        int length;
        BetterFpsInstaller.info("Copying the mod file...", new Object[0]);
        URL modFile = BetterFpsInstaller.class.getProtectionDomain().getCodeSource().getLocation();
        InputStream is = modFile.openStream();
        FileOutputStream os = new FileOutputStream(output);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, length);
        }
        is.close();
        ((OutputStream)os).close();
    }

    public static JsonObject loadVersion(File gameDir, String version) throws IOException {
        BetterFpsInstaller.info("Loading version json from %s...", version);
        File versionFile = new File(gameDir, String.format("versions/%s/%s.json", version, version));
        FileReader reader = new FileReader(versionFile);
        JsonObject obj = Json.parse(reader).asObject();
        reader.close();
        return obj;
    }

    public static void saveVersion(File gameDir, String version, JsonObject data) throws IOException {
        BetterFpsInstaller.info("Saving version json to %s...", version);
        File versionFile = new File(gameDir, String.format("versions/%s/%s.json", version, version));
        versionFile.getParentFile().mkdirs();
        versionFile.createNewFile();
        FileWriter writer = new FileWriter(versionFile);
        data.writeTo(writer, WriterConfig.PRETTY_PRINT);
        writer.close();
    }

    public static JsonObject generateVersion(JsonObject original, String versionName) {
        JsonObject version = new JsonObject();
        String oldId = original.getString("id", "1.10.2");
        String date = BetterFpsInstaller.getDateISO();
        version.set("id", versionName);
        version.set("inheritsFrom", oldId);
        version.set("jar", version.getString("jar", oldId));
        version.set("mainClass", "net.minecraft.launchwrapper.Launch");
        version.set("time", date);
        version.set("releaseTime", date);
        version.set("type", "release");
        String arguments = original.getString("minecraftArguments", "");
        version.set("minecraftArguments", String.format("%s --tweakClass %s", arguments, TWEAK_CLASS));
        JsonArray libraries = new JsonArray();
        String ver = String.format("%s:%s:%s", LIBRARY_IDENTIFIER, LIBRARY_NAME, VERSION_NAME);
        libraries.add(new JsonObject().add("name", ver));
        for (String lib : LIBRARIES) {
            libraries.add(new JsonObject().add("name", lib));
        }
        version.set("libraries", libraries);
        return version;
    }

    public static JsonObject loadProfiles(File gameDir) throws IOException {
        BetterFpsInstaller.info("Loading profiles json for game dir: %s", gameDir.getAbsolutePath());
        File profilesFile = new File(gameDir, "launcher_profiles.json");
        FileReader reader = new FileReader(profilesFile);
        JsonObject obj = Json.parse(reader).asObject();
        reader.close();
        return obj;
    }

    public static void saveProfiles(File gameDir, JsonObject launcherProfiles) throws IOException {
        BetterFpsInstaller.info("Saving profiles json...", new Object[0]);
        File profilesFile = new File(gameDir, "launcher_profiles.json");
        FileWriter writer = new FileWriter(profilesFile);
        launcherProfiles.writeTo(writer, WriterConfig.PRETTY_PRINT);
        writer.close();
    }

    public static List<String> getProfileNames(JsonObject launcherProfiles) {
        ArrayList<String> profileNames = new ArrayList<String>();
        JsonObject profs = launcherProfiles.get("profiles").asObject();
        for (String prof : profs.names()) {
            JsonObject obj = profs.get(prof).asObject();
            if (!obj.getString("type", "custom").equalsIgnoreCase("custom")) continue;
            profileNames.add(obj.getString("name", prof));
        }
        return profileNames;
    }

    public static void addProfile(JsonObject launcherProfiles, String selectedProfileName, String version) {
        JsonObject profs = launcherProfiles.get("profiles").asObject();
        JsonObject selectedProfile = null;
        for (String prof : profs.names()) {
            JsonObject obj = profs.get(prof).asObject();
            String name = obj.getString("name", prof);
            if (!name.equalsIgnoreCase(selectedProfileName)) continue;
            selectedProfile = obj;
            break;
        }
        String date = BetterFpsInstaller.getDateISO();
        if (selectedProfile == null) {
            selectedProfile = new JsonObject();
            selectedProfile.add("name", selectedProfileName);
            selectedProfile.add("type", "custom");
            selectedProfile.add("created", date);
            selectedProfile.add("icon", "Leaves_Oak");
            profs.add(selectedProfileName, selectedProfile);
        }
        selectedProfile.set("lastUsed", date);
        selectedProfile.set("lastVersionId", version);
    }

    private static String getDateISO() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return format.format(new Date());
    }
}

