/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static bwe spriteGrass = null;
    private static bwe spriteGrassSide = null;
    private static bwe spriteGrassPath = null;
    private static bwe spriteGrassPathSide = null;
    private static bwe spriteMycelium = null;
    private static bwe spritePodzol = null;
    private static bwe spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static byl modelCubeGrass = null;
    private static byl modelGrassPath = null;
    private static byl modelCubeGrassPath = null;
    private static byl modelCubeMycelium = null;
    private static byl modelCubePodzol = null;
    private static byl modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "blocks/grass_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "blocks/grass_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "blocks/grass_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "blocks/grass_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "blocks/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "blocks/dirt_podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "blocks/snow";

    public static void updateIcons(bwd textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            byl modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("grass_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(bwd textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.a(new kn(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.a(new kn(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.a(new kn(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.a(new kn(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.a(new kn(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.a(new kn(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.a(new kn(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            kn locFile = new kn(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e) {
            Config.warn("Error reading: " + name + ", " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static bwe registerSprite(Properties props, String key, String textureDefault, bwd textureMap) {
        kn locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new kn("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        kn locSprite = new kn(texture);
        bwe sprite = textureMap.a(locSprite);
        return sprite;
    }

    public static List getFaceQuads(aih blockAccess, ars blockState, cm blockPos, ct facing, List quads) {
        if (facing == ct.b || facing == ct.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        akf block = blockState.t();
        if (block instanceof anj) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof amj) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof alg) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof ami) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(aih blockAccess, ars blockState, cm blockPos, ct facing, List quads) {
        boolean snowy;
        akf blockUp = blockAccess.o(blockPos.a()).t();
        boolean bl = snowy = blockUp == akg.aJ || blockUp == akg.aH;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == akg.aH) {
                    return modelCubeSnow.a(blockState, facing, 0L);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == akg.bw) {
                return modelCubeMycelium.a(blockState, facing, 0L);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(blockState, facing, 0L);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(blockState, facing, 0L);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(aih blockAccess, ars blockState, cm blockPos, ct facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == akg.da) {
                return modelGrassPath.a(blockState, facing, 0L);
            }
        } else {
            return modelGrassPath.a(blockState, facing, 0L);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(aih blockAccess, ars blockState, cm blockPos, ct facing, List quads) {
        akf blockTop = BetterGrass.getBlockAt(blockPos, ct.b, blockAccess);
        if (blockState.c((asi)alg.a) == alg.a.c) {
            boolean snowy;
            boolean bl = snowy = blockTop == akg.aJ || blockTop == akg.aH;
            if (Config.isBetterGrassFancy()) {
                cm posSide;
                ars stateSide;
                if (snowy) {
                    if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == akg.aH) {
                        return modelCubeSnow.a(blockState, facing, 0L);
                    }
                } else if (betterPodzol && (stateSide = blockAccess.o(posSide = blockPos.b().a(facing))).t() == akg.d && stateSide.c((asi)alg.a) == alg.a.c) {
                    return modelCubePodzol.a(blockState, facing, 0L);
                }
            } else if (snowy) {
                if (betterPodzolSnow) {
                    return modelCubeSnow.a(blockState, facing, 0L);
                }
            } else if (betterPodzol) {
                return modelCubePodzol.a(blockState, facing, 0L);
            }
            return quads;
        }
        if (blockTop == akg.da) {
            if (betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == akg.da) {
                return modelCubeGrassPath.a(blockState, facing, 0L);
            }
            return quads;
        }
        return quads;
    }

    private static List getFaceQuadsGrass(aih blockAccess, ars blockState, cm blockPos, ct facing, List quads) {
        boolean snowy;
        akf blockUp = blockAccess.o(blockPos.a()).t();
        boolean bl = snowy = blockUp == akg.aJ || blockUp == akg.aH;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == akg.aH) {
                    return modelCubeSnow.a(blockState, facing, 0L);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == akg.c) {
                return modelCubeGrass.a(blockState, facing, 0L);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(blockState, facing, 0L);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(blockState, facing, 0L);
        }
        return quads;
    }

    private static akf getBlockAt(cm blockPos, ct facing, aih blockAccess) {
        cm pos = blockPos.a(facing);
        akf block = blockAccess.o(pos).t();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

