/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
    }

    public void render(float partial) {
        if (this.modMain.getSettings().getShowIngameWaypoints() && this.waypointsManager.getWaypoints() != null) {
            Entity entity = Minecraft.func_71410_x().func_175606_aa();
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partial;
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partial;
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partial;
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer bufferbuilder = tessellator.func_178180_c();
            boolean divideBy8 = this.modMain.getWaypointsManager().divideBy8();
            if (this.waypointsManager.renderAllSets) {
                HashMap<String, WaypointSet> sets = this.waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    this.renderWaypointsList(setEntry.getValue().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, divideBy8);
                }
            } else {
                this.renderWaypointsList(this.waypointsManager.getWaypoints().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, divideBy8);
            }
            if (ServerWaypointStorage.working() && this.waypointsManager.getServerWaypoints() != null) {
                this.renderWaypointsList(this.waypointsManager.getServerWaypoints(), d3, d4, d5, entity, bufferbuilder, tessellator, divideBy8);
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    private void renderWaypointsList(List<Waypoint> list, double d3, double d4, double d5, Entity entity, VertexBuffer bufferbuilder, Tessellator tessellator, boolean divideBy8) {
        for (int i = 0; i < list.size(); ++i) {
            this.renderWaypointIngame(list.get(i), this.modMain, 12.0, d3, d4, d5, entity, bufferbuilder, tessellator, divideBy8);
        }
    }

    private void renderWaypointIngame(Waypoint w, IXaeroMinimap modMain, double radius, double d3, double d4, double d5, Entity entity, VertexBuffer vertexBuffer, Tessellator tessellator, boolean divideBy8) {
        if (w.isDisabled() || w.getType() == 1 && !modMain.getSettings().getDeathpoints()) {
            return;
        }
        float offX = (float)Math.floorDiv(w.getX(), divideBy8 ? 8 : 1) - (float)d3 + 0.5f;
        float offY = (float)w.getY() - (float)d4 + 1.0f;
        float offZ = (float)Math.floorDiv(w.getZ(), divideBy8 ? 8 : 1) - (float)d5 + 0.5f;
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        double correctDistance = Math.sqrt(offX * offX + (offY - 1.0f) * (offY - 1.0f) + offZ * offZ);
        w.setLastDistance(distance);
        if (modMain.getSettings().waypointsDistance != 0.0f && distance > (double)modMain.getSettings().waypointsDistance || modMain.getSettings().waypointsDistanceMin != 0.0f && distance < (double)modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (modMain.getSettings().keepWaypointNames) {
            textSize = 1.6f;
        }
        if (distance > radius) {
            double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
            if (distance > maxDistance) {
                zoomer2 = (float)(maxDistance / radius);
                float zoomer = (float)(maxDistance / distance);
                offX *= zoomer;
                offY *= zoomer;
                offY += entity.func_70047_e() * (1.0f - zoomer);
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(distance / radius);
            }
        }
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            textSize = 1.6f;
            if (modMain.getSettings().distance == 1) {
                float cameraAngle;
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                showDistance = (offset = MathHelper.func_76142_g((float)(angle - (cameraAngle = MathHelper.func_76142_g((float)entity.field_70177_z))))) > -20.0f && offset < 20.0f;
            } else if (modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        GlStateManager.func_179109_b((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179152_a((float)zoomer2, (float)zoomer2, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.drawIconInWorld(w, modMain.getSettings(), vertexBuffer, tessellator, fontrenderer, name, distanceText, textSize, showDistance);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, VertexBuffer vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance) {
        GlStateManager.func_179152_a((float)settings.waypointsScale, (float)settings.waypointsScale, (float)1.0f);
        if (w.getType() == 0) {
            int c = ModSettings.COLORS[w.getColor()];
            float l = (float)(c >> 16 & 0xFF) / 255.0f;
            float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
            float j1 = (float)(c & 0xFF) / 255.0f;
            int s = fontrenderer.func_78256_a(w.getSymbol()) / 2;
            GlStateManager.func_179090_x();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            GlStateManager.func_179131_c((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)settings.waypointOpacityIngame / 100.0f) / 255.0f));
            vertexBuffer.func_181662_b(-5.0, -9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(-5.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(4.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(4.0, -9.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(w.getSymbol(), -s, -8, 0x20FFFFFF);
            fontrenderer.func_78276_b(w.getSymbol(), -s, -8, -1);
        } else if (w.getType() == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(250.0f * ((float)settings.waypointOpacityIngame / 100.0f) / 255.0f));
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexBuffer.func_181662_b(-5.0, -9.0, 0.0).func_187315_a(0.0, (double)(78.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(-5.0, 0.0, 0.0).func_187315_a(0.0, (double)(87.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(4.0, 0.0, 0.0).func_187315_a((double)(9.0f * f), (double)(87.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(4.0, -9.0, 0.0).func_187315_a((double)(9.0f * f), (double)(78.0f * f1)).func_181675_d();
            tessellator.func_78381_a();
            if (!showDistance) {
                name = w.getLocalizedName();
                if (!settings.keepWaypointNames) {
                    textSize = 1.0f;
                }
            }
        }
        if (Minecraft.func_71410_x().func_152349_b()) {
            textSize *= 1.5f;
        }
        boolean showingName = name.length() > 0;
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
        if (distance.length() > 0) {
            int t = fontrenderer.func_78256_a(distance) / 2;
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            vertexBuffer.func_181662_b((double)(-t) - 1.0, (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 9.0 + (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 9.0 + (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(distance, -t, 1 + (showingName ? 10 : 0), 0x20FFFFFF);
            fontrenderer.func_78276_b(distance, -t, 1 + (showingName ? 10 : 0), -1);
        }
        if (showingName) {
            int t = fontrenderer.func_78256_a(name) / 2;
            fontrenderer.func_78276_b(name, -t, 1, 0x20FFFFFF);
            fontrenderer.func_78276_b(name, -t, 1, -1);
        }
    }
}

