/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments;

import com.google.common.base.Supplier;
import info.openmods.calc.Calculator;
import info.openmods.calc.Environment;
import info.openmods.calc.ExprType;
import info.openmods.calc.SingleExprEvaluator;
import info.openmods.calc.types.fp.DoubleCalculatorFactory;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;
import openmods.entity.PlayerDamageEvent;
import openmods.utils.EnchantmentUtils;

public class LastStandEnchantmentsHandler {
    private static final String VAR_ENCH_LEVEL = "ench";
    private static final String VAR_PLAYER_XP = "xp";
    private static final String VAR_PLAYER_HP = "hp";
    private static final String VAR_DAMAGE = "dmg";
    private final SingleExprEvaluator<Double, ExprType> reductionCalculator = SingleExprEvaluator.create((Calculator)DoubleCalculatorFactory.createDefault());

    public LastStandEnchantmentsHandler() {
        this.updateReductionFormula();
    }

    @SubscribeEvent
    public void onConfigChange(ConfigurationChange.Post evt) {
        if (evt.check("features", "lastStandFormula")) {
            this.updateReductionFormula();
        }
    }

    private void updateReductionFormula() {
        this.reductionCalculator.setExpr((Object)ExprType.INFIX, Config.lastStandEnchantmentFormula);
        if (!this.reductionCalculator.isExprValid()) {
            Log.warn((String)"Invalid lastStandFormula: ", (Object[])new Object[]{Config.lastStandEnchantmentEnabled});
        }
    }

    @SubscribeEvent
    public void onHurt(final PlayerDamageEvent e) {
        float xpRequired;
        int xpAvailable;
        float playerHealth;
        float healthAvailable;
        final int enchantmentLevels = LastStandEnchantmentsHandler.countLastStandEnchantmentLevels(e.player);
        if (enchantmentLevels > 0 && (healthAvailable = (playerHealth = e.player.func_110143_aJ()) - e.amount) < 1.0f && (float)(xpAvailable = EnchantmentUtils.getPlayerXP((EntityPlayer)e.player)) >= (xpRequired = ((Double)this.reductionCalculator.evaluate((SingleExprEvaluator.EnvironmentConfigurator)new SingleExprEvaluator.EnvironmentConfigurator<Double>(){

            public void accept(Environment<Double> env) {
                env.setGlobalSymbol(LastStandEnchantmentsHandler.VAR_ENCH_LEVEL, (Object)enchantmentLevels);
                env.setGlobalSymbol(LastStandEnchantmentsHandler.VAR_PLAYER_XP, (Object)xpAvailable);
                env.setGlobalSymbol(LastStandEnchantmentsHandler.VAR_PLAYER_HP, (Object)playerHealth);
                env.setGlobalSymbol(LastStandEnchantmentsHandler.VAR_DAMAGE, (Object)e.amount);
            }
        }, (Supplier)new Supplier<Double>(){

            public Double get() {
                float xpRequired = 1.0f - healthAvailable;
                xpRequired *= 50.0f;
                xpRequired /= (float)enchantmentLevels;
                xpRequired = Math.max(1.0f, xpRequired);
                return xpRequired;
            }
        })).floatValue())) {
            e.player.func_70606_j(1.0f);
            EnchantmentUtils.addPlayerXP((EntityPlayer)e.player, (int)(-((int)xpRequired)));
            e.amount = 0.0f;
            e.setCanceled(true);
        }
    }

    public static int countLastStandEnchantmentLevels(EntityPlayer player) {
        if (player != null) {
            int count = 0;
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                count += EnchantmentHelper.func_77506_a((Enchantment)OpenBlocks.Enchantments.lastStand, (ItemStack)stack);
            }
            return count;
        }
        return 0;
    }
}

