/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.RayTraceResult;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockTarget;
import openmods.Log;
import openmods.api.ISurfaceAttachment;
import openmods.reflection.SafeClassLoad;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.EntityUtils;

public class TileEntityTarget
extends OpenTileEntity
implements ISurfaceAttachment,
ITickable {
    private int strength = 0;
    private int tickCounter = -1;
    private static final SafeClassLoad FLANS_BULLET = SafeClassLoad.create((String)"com.flansmod.common.guns.EntityBullet");
    public static final Set<Class<?>> EXTRA_PROJECTILE_CLASSES = Sets.newHashSet();
    private static final Predicate<Entity> PROJECTILE_SELECTOR;

    private static void addClass(SafeClassLoad cls) {
        if (cls.tryLoad()) {
            EXTRA_PROJECTILE_CLASSES.add(cls.get());
        } else {
            Log.debug((String)"Class %s not found, skipping target path prediction from FlansMod", (Object[])new Object[]{cls.clsName});
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !EXTRA_PROJECTILE_CLASSES.isEmpty()) {
            this.predictOtherProjectiles();
        }
        --this.tickCounter;
        if (this.tickCounter == 0) {
            this.tickCounter = -1;
            this.strength = 0;
            this.field_145850_b.func_175685_c(this.field_174879_c, OpenBlocks.Blocks.target);
        }
    }

    private void predictOtherProjectiles() {
        List projectiles = this.field_145850_b.func_175647_a(Entity.class, this.getBB().func_72314_b(10.0, 10.0, 10.0), PROJECTILE_SELECTOR);
        IBlockState state = null;
        for (Entity projectile : projectiles) {
            RayTraceResult hit = EntityUtils.raytraceEntity((Entity)projectile);
            if (hit.field_72313_a != RayTraceResult.Type.BLOCK || !this.field_174879_c.equals((Object)hit.func_178782_a())) continue;
            if (state == null) {
                state = this.field_145850_b.func_180495_p(this.func_174877_v());
            }
            ((BlockTarget)state.func_177230_c()).onTargetHit(this.field_145850_b, this.field_174879_c, state, hit.field_72307_f);
        }
    }

    public int getRedstoneStrength() {
        return this.strength;
    }

    public void setRedstoneStrength(int strength) {
        this.strength = strength;
        this.tickCounter = 10;
        this.field_145850_b.func_175685_c(this.field_174879_c, OpenBlocks.Blocks.target);
    }

    public EnumFacing getSurfaceDirection() {
        return EnumFacing.DOWN;
    }

    static {
        TileEntityTarget.addClass(FLANS_BULLET);
        PROJECTILE_SELECTOR = new Predicate<Entity>(){

            public boolean apply(Entity target) {
                return EXTRA_PROJECTILE_CLASSES.contains(target.getClass());
            }
        };
    }
}

