/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.common.MagnetWhitelists;
import openblocks.common.entity.EntityMiniMe;
import openmods.Log;
import openmods.api.IBreakAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.entity.EntityBlock;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.sync.SyncableEnum;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityGoldenEgg
extends SyncedTileEntity
implements IPlaceAwareTile,
IBreakAwareTile,
ITickable {
    private static final float SPEED_CHANGE_RATE = 0.1f;
    private static final Random RANDOM = new Random();
    private static final int STAGE_CHANGE_TICK = 100;
    private static final int RISING_TIME = 400;
    private static final int FALLING_TIME = 10;
    public static final int MAX_HEIGHT = 5;
    private static final double STAGE_CHANGE_CHANCE = 0.8;
    private static final GameProfile MR_GLITCH = new GameProfile(UUID.fromString("d4d119aa-d410-488a-8734-0053577d4a1a"), null);
    public int tickCounter;
    private float rotation;
    private float progress;
    private float rotationSpeed;
    private float progressSpeed;
    private List<EntityBlock> blocks = Lists.newArrayList();
    private SyncableEnum<State> stage;
    private GameProfile owner;

    public float getRotation(float partialTickTime) {
        return this.rotation + this.rotationSpeed * partialTickTime;
    }

    public float getProgress(float partialTickTime) {
        return this.progress + this.progressSpeed * partialTickTime;
    }

    public float getOffset(float partialTickTime) {
        return this.getProgress(partialTickTime) * 5.0f;
    }

    public State tryRandomlyChangeState(int delay, State nextState) {
        return this.tickCounter % delay == 0 && RANDOM.nextDouble() < 0.8 ? nextState : null;
    }

    protected void createSyncedFields() {
        this.stage = SyncableEnum.create((Enum)State.INERT);
    }

    private void pickUpBlock(final WorldServer world, final BlockPos pos) {
        FakePlayerPool.instance.executeOnPlayer(world, new FakePlayerPool.PlayerUser(){

            public void usePlayer(OpenModsFakePlayer fakePlayer) {
                EntityBlock block = EntityBlock.create((EntityPlayer)fakePlayer, (World)TileEntityGoldenEgg.this.field_145850_b, (BlockPos)pos);
                if (block != null) {
                    block.setHasAirResistance(false);
                    block.setHasGravity(false);
                    block.field_70181_x = 0.1;
                    TileEntityGoldenEgg.this.blocks.add(block);
                    world.func_72838_d((Entity)block);
                }
            }
        });
    }

    private void dropBlocks() {
        for (EntityBlock block : this.blocks) {
            block.field_70181_x = -0.9;
            block.setHasGravity(true);
        }
        this.blocks.clear();
    }

    private void explode() {
        this.field_145850_b.func_175698_g(this.field_174879_c);
        this.field_145850_b.func_72876_a(null, 0.5 + (double)this.field_174879_c.func_177958_n(), 0.5 + (double)this.field_174879_c.func_177956_o(), 0.5 + (double)this.field_174879_c.func_177952_p(), 2.0f, true);
        EntityMiniMe miniMe = new EntityMiniMe(this.field_145850_b, (GameProfile)Objects.firstNonNull((Object)this.owner, (Object)MR_GLITCH));
        miniMe.func_70080_a(0.5 + (double)this.field_174879_c.func_177958_n(), 0.5 + (double)this.field_174879_c.func_177956_o(), 0.5 + (double)this.field_174879_c.func_177952_p(), 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)miniMe);
    }

    public State getState() {
        return (State)this.stage.get();
    }

    public void func_73660_a() {
        State state = this.getState();
        if (this.field_145850_b.field_72995_K) {
            this.rotationSpeed = 0.9f * this.rotationSpeed + 0.1f * state.rotationSpeed;
            this.rotation += this.rotationSpeed;
            this.progressSpeed = 0.9f * this.progressSpeed + 0.1f * state.progressSpeed;
            this.progress += this.progressSpeed;
        } else {
            State nextState;
            if (this.field_145850_b instanceof WorldServer) {
                state.onServerTick(this, (WorldServer)this.field_145850_b);
            }
            if ((nextState = state.getNextState(this)) != null) {
                this.stage.set((Enum)nextState);
                nextState.onEntry(this);
                this.sync();
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.owner != null) {
            NBTTagCompound ownerTag = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)ownerTag, (GameProfile)this.owner);
            nbt.func_74782_a("Owner", (NBTBase)ownerTag);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("owner", 8)) {
            String ownerName = nbt.func_74779_i("owner");
            this.owner = TileEntitySkull.func_174884_b((GameProfile)new GameProfile(null, ownerName));
        } else if (nbt.func_150297_b("OwnerUUID", 8)) {
            String uuidStr = nbt.func_74779_i("OwnerUUID");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                this.owner = new GameProfile(uuid, null);
            }
            catch (IllegalArgumentException e) {
                Log.warn((Throwable)e, (String)"Failed to parse UUID: %s", (Object[])new Object[]{uuidStr});
            }
        } else if (nbt.func_150297_b("Owner", 10)) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("Owner"));
        }
    }

    public void onBlockBroken() {
        this.dropBlocks();
    }

    public void onBlockPlacedBy(IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!this.field_145850_b.field_72995_K && placer instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)placer).func_146103_bH();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), -1024.0, (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), 1024.0, (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public static enum State {
        INERT(0.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_SLOW);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_SLOW(1.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_MEDIUM);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_MEDIUM(10.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_FAST);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_FAST(50.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, FLOATING);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                ++target.tickCounter;
            }
        }
        ,
        FLOATING(100.0f, 0.0025f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.tickCounter = 400;
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                --target.tickCounter;
                if (Config.eggCanPickBlocks && RANDOM.nextInt(6) == 0) {
                    BlockPos pos = target.func_174877_v();
                    BlockPos targetPos = pos.func_177982_a(RANDOM.nextInt(20) - 10, RANDOM.nextInt(2) - 1, RANDOM.nextInt(20) - 10);
                    boolean canMove = MagnetWhitelists.instance.testBlock(target.func_145831_w(), targetPos);
                    if (canMove) {
                        target.pickUpBlock(world, targetPos);
                    }
                }
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tickCounter <= 0 ? FALLING : null;
            }
        }
        ,
        FALLING(150.0f, -0.1f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.tickCounter = 10;
                target.dropBlocks();
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
                --target.tickCounter;
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tickCounter <= 0 ? EXPLODING : null;
            }
        }
        ,
        EXPLODING(666.0f, 0.0f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.explode();
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return null;
            }
        };

        public final float rotationSpeed;
        public final float progressSpeed;
        public final boolean specialEffects;

        public void onEntry(TileEntityGoldenEgg target) {
        }

        public void onServerTick(TileEntityGoldenEgg target, WorldServer world) {
        }

        public abstract State getNextState(TileEntityGoldenEgg var1);

        private State(float rotationSpeed, float riseSpeed, boolean specialEffects) {
            this.rotationSpeed = rotationSpeed;
            this.progressSpeed = riseSpeed;
            this.specialEffects = specialEffects;
        }
    }
}

