/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import openblocks.OpenBlocks;
import openblocks.client.renderer.block.canvas.CanvasState;
import openblocks.common.StencilPattern;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemSqueegee;
import openblocks.common.item.ItemStencil;
import openblocks.common.sync.SyncableBlockLayers;
import openmods.api.IActivateAwareTile;
import openmods.api.ICustomBreakDrops;
import openmods.api.ICustomHarvestDrops;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableBlockState;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityCanvas
extends SyncedTileEntity
implements IActivateAwareTile,
ICustomBreakDrops,
ICustomHarvestDrops {
    private SyncableBlockState paintedBlockState;
    private IBlockState rawPaintedBlockState;
    private int prevLightValue;
    private int prevLightOpacity;
    private IBlockState actualPaintedBlockState;
    private SyncableBlockLayers stencilsUp;
    private SyncableBlockLayers stencilsDown;
    private SyncableBlockLayers stencilsEast;
    private SyncableBlockLayers stencilsWest;
    private SyncableBlockLayers stencilsNorth;
    private SyncableBlockLayers stencilsSouth;
    private Map<EnumFacing, SyncableBlockLayers> allSides;
    private CanvasState canvasState = CanvasState.EMPTY;

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addUpdateListener(new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                boolean stateChanged = false;
                if (changes.contains(TileEntityCanvas.this.paintedBlockState)) {
                    TileEntityCanvas.this.onPaintedBlockUpdate();
                    stateChanged = true;
                }
                for (Map.Entry e : TileEntityCanvas.this.allSides.entrySet()) {
                    SyncableBlockLayers side = (SyncableBlockLayers)((Object)e.getValue());
                    if (!changes.contains((Object)side)) continue;
                    TileEntityCanvas.this.canvasState = TileEntityCanvas.this.canvasState.update((EnumFacing)e.getKey(), side.convertToState());
                    stateChanged = true;
                }
                if (stateChanged) {
                    TileEntityCanvas.this.markBlockForRenderUpdate(TileEntityCanvas.this.func_174877_v());
                }
            }
        });
    }

    private SyncableBlockLayers createLayer(EnumFacing facing) {
        SyncableBlockLayers result = new SyncableBlockLayers();
        this.allSides.put(facing, result);
        return result;
    }

    protected void createSyncedFields() {
        this.allSides = Maps.newEnumMap(EnumFacing.class);
        this.stencilsUp = this.createLayer(EnumFacing.UP);
        this.stencilsDown = this.createLayer(EnumFacing.DOWN);
        this.stencilsEast = this.createLayer(EnumFacing.EAST);
        this.stencilsWest = this.createLayer(EnumFacing.WEST);
        this.stencilsNorth = this.createLayer(EnumFacing.NORTH);
        this.stencilsSouth = this.createLayer(EnumFacing.SOUTH);
        this.paintedBlockState = new SyncableBlockState();
    }

    public SyncableBlockLayers getLayersForSide(EnumFacing side) {
        return this.allSides.get(side);
    }

    public IBlockState getPaintedBlockState() {
        if (this.rawPaintedBlockState == null) {
            this.rawPaintedBlockState = this.paintedBlockState.getValue();
        }
        return this.rawPaintedBlockState;
    }

    public IBlockState getActualPaintedBlockState() {
        if (this.actualPaintedBlockState == null) {
            IBlockState rawBlockState = this.getPaintedBlockState();
            try {
                this.actualPaintedBlockState = rawBlockState.func_185899_b((IBlockAccess)new UnpackingBlockAccess(this.func_145831_w()), this.func_174877_v());
            }
            catch (Exception e) {
                this.actualPaintedBlockState = rawBlockState;
            }
        }
        return this.actualPaintedBlockState;
    }

    private boolean isBlockUnpainted() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.allSides.get(side).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean applyPaint(int color, EnumFacing ... sides) {
        boolean hasChanged = false;
        for (EnumFacing side : sides) {
            SyncableBlockLayers layers = this.getLayersForSide(side);
            layers.applyPaint(color);
            hasChanged |= layers.isDirty();
        }
        this.trySync();
        return hasChanged;
    }

    private void dropStackFromSide(ItemStack stack, EnumFacing side) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockUtils.dropItemStackInWorld((World)this.field_145850_b, (Vec3i)this.field_174879_c.func_177972_a(side), (ItemStack)stack);
    }

    public void removePaint(EnumFacing ... sides) {
        for (EnumFacing side : sides) {
            SyncableBlockLayers layer = this.getLayersForSide(side);
            Optional<StencilPattern> stencil = layer.clearAll();
            if (!stencil.isPresent()) continue;
            ItemStack dropStack = new ItemStack(OpenBlocks.Items.stencil, 1, ((StencilPattern)stencil.get()).ordinal());
            this.dropStackFromSide(dropStack, side);
        }
        if (this.isBlockUnpainted() && !this.paintedBlockState.isAir()) {
            IBlockState state = this.paintedBlockState.getValue();
            this.field_145850_b.func_175656_a(this.field_174879_c, state);
        }
        this.trySync();
    }

    public boolean useStencil(EnumFacing side, StencilPattern stencil) {
        SyncableBlockLayers layer = this.getLayersForSide(side);
        layer.putStencil(stencil);
        this.trySync();
        return true;
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item heldItem;
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (held != null && ((heldItem = held.func_77973_b()) instanceof ItemSqueegee || heldItem instanceof ItemPaintBrush || heldItem instanceof ItemStencil)) {
            return false;
        }
        SyncableBlockLayers layer = this.getLayersForSide(side);
        boolean result = false;
        if (player.func_70093_af()) {
            Optional<StencilPattern> stencil;
            if (!this.field_145850_b.field_72995_K && (stencil = layer.popStencil()).isPresent() && OpenBlocks.Items.stencil != null) {
                ItemStack dropStack = ItemStencil.createItemStack(OpenBlocks.Items.stencil, (StencilPattern)stencil.get());
                this.dropStackFromSide(dropStack, side);
                result = true;
            }
        } else {
            result = layer.rotateCover();
        }
        this.trySync();
        return result;
    }

    public List<ItemStack> getDrops(List<ItemStack> drops) {
        for (SyncableBlockLayers sideLayers : this.allSides.values()) {
            Optional<StencilPattern> stencil = sideLayers.peekStencil();
            if (!stencil.isPresent() || OpenBlocks.Items.stencil == null) continue;
            drops.add(ItemStencil.createItemStack(OpenBlocks.Items.stencil, (StencilPattern)stencil.get()));
        }
        return drops;
    }

    public boolean suppressBlockHarvestDrops() {
        return !this.paintedBlockState.isAir();
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops, IBlockState blockState, int fortune, boolean isSilkHarvest) {
        if (!this.paintedBlockState.isAir()) {
            IBlockState state = this.paintedBlockState.getValue();
            Block paintedBlock = state.func_177230_c();
            Random rand = this.field_145850_b.field_73012_v;
            int count = paintedBlock.quantityDropped(state, fortune, rand);
            int damageDropped = paintedBlock.func_180651_a(state);
            for (int i = 0; i < count; ++i) {
                Item item = paintedBlock.func_180660_a(state, rand, fortune);
                if (item == null) continue;
                drops.add(new ItemStack(item, 1, damageDropped));
            }
        }
    }

    public void setPaintedBlock(IBlockState state) {
        this.paintedBlockState.setValue(state);
        this.onPaintedBlockUpdate();
    }

    private void onPaintedBlockUpdate() {
        this.rawPaintedBlockState = null;
        this.actualPaintedBlockState = null;
        this.updateLight();
    }

    private void updateLight() {
        IBlockState paintedBlockStatek = this.getPaintedBlockState();
        Block paintedBlock = paintedBlockStatek.func_177230_c();
        int newLightValue = paintedBlock.func_149750_m(paintedBlockStatek);
        int newLightOpacity = paintedBlock.func_149717_k(paintedBlockStatek);
        if (newLightValue != this.prevLightValue || newLightOpacity != this.prevLightOpacity) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
            this.prevLightOpacity = newLightOpacity;
            this.prevLightValue = newLightValue;
        }
    }

    public CanvasState getCanvasState() {
        return this.canvasState;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.canvasState.release();
        this.canvasState = CanvasState.EMPTY;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.canvasState.release();
        this.canvasState = CanvasState.EMPTY;
    }

    public static class UnpackingBlockAccess
    implements IBlockAccess {
        private final World original;

        public UnpackingBlockAccess(World original) {
            this.original = original;
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            TileEntity te = this.original.func_175625_s(pos);
            return te instanceof TileEntityCanvas ? null : te;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return this.original.func_175626_b(pos, lightValue);
        }

        public IBlockState func_180495_p(BlockPos pos) {
            TileEntity te = this.original.func_175625_s(pos);
            if (te instanceof TileEntityCanvas) {
                return ((TileEntityCanvas)te).getPaintedBlockState();
            }
            return this.original.func_180495_p(pos);
        }

        public boolean func_175623_d(BlockPos pos) {
            IBlockState state = this.func_180495_p(pos);
            return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
        }

        public Biome func_180494_b(BlockPos pos) {
            return this.original.func_180494_b(pos);
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return this.original.func_175627_a(pos, direction);
        }

        public WorldType func_175624_G() {
            return this.original.func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            Chunk chunk = this.original.func_175726_f(pos);
            if (chunk == null || chunk.func_76621_g()) {
                return _default;
            }
            IBlockState state = this.func_180495_p(pos);
            return state.func_177230_c().isSideSolid(state, (IBlockAccess)this, pos, side);
        }
    }
}

