/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.sync;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import openblocks.client.renderer.block.canvas.CanvasSideState;
import openblocks.client.renderer.block.canvas.TextureOrientation;
import openblocks.common.StencilPattern;
import openmods.Log;
import openmods.sync.SyncableObjectBase;
import openmods.utils.Stack;

public class SyncableBlockLayers
extends SyncableObjectBase {
    private static final String TAG_LAYERS = "Layers";
    private static final String TAG_BACKGROUND = "Background";
    private static final String TAG_COLOR = "Color";
    private static final String TAG_STENCIL = "Stencil";
    private static final String TAG_ROTATION = "Rotation";
    private static final String TAG_COVER = "Cover";
    private final Stack<Layer> layers = Stack.create();
    private Optional<Cover> cover = Optional.absent();
    private int backgroundColor;
    private static final Function<Cover, StencilPattern> EXTRACT_PATTERN = new Function<Cover, StencilPattern>(){

        public StencilPattern apply(Cover input) {
            return input.stencil;
        }
    };

    public void readFromStream(PacketBuffer stream) {
        this.backgroundColor = stream.readInt();
        byte size = stream.readByte();
        this.layers.clear();
        for (byte i = 0; i < size; i = (byte)(i + 1)) {
            this.layers.push((Object)Layer.createFromStream(stream));
        }
        this.cover = Cover.createFromStream(stream);
    }

    public void writeToStream(PacketBuffer stream) {
        stream.writeInt(this.backgroundColor);
        stream.writeByte(this.layers.size());
        for (Layer layer : this.layers) {
            layer.writeToStream(stream);
        }
        if (this.cover.isPresent()) {
            stream.writeBoolean(true);
            ((Cover)this.cover.get()).writeToStream(stream);
        } else {
            stream.writeBoolean(false);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74768_a(TAG_BACKGROUND, this.backgroundColor);
        NBTTagList layersTag = new NBTTagList();
        for (Layer layer : this.layers) {
            layersTag.func_74742_a((NBTBase)layer.writeToNBT());
        }
        subTag.func_74782_a(TAG_LAYERS, (NBTBase)layersTag);
        if (this.cover.isPresent()) {
            subTag.func_74782_a(TAG_COVER, (NBTBase)((Cover)this.cover.get()).writeToNBT());
        }
        nbt.func_74782_a(name, (NBTBase)subTag);
    }

    public void readFromNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound subTag = nbt.func_74775_l(name);
        this.backgroundColor = subTag.func_74762_e(TAG_BACKGROUND);
        NBTTagList layersTag = subTag.func_150295_c(TAG_LAYERS, 10);
        this.layers.clear();
        for (int i = 0; i < layersTag.func_74745_c(); ++i) {
            this.layers.push((Object)Layer.createFromNBT(layersTag.func_150305_b(i)));
        }
        this.cover = subTag.func_150297_b(TAG_COVER, 10) ? Optional.of((Object)Cover.createFromNBT(subTag.func_74775_l(TAG_COVER))) : Optional.absent();
    }

    public void applyPaint(int color) {
        if (this.cover.isPresent()) {
            this.paintOverCover((Cover)this.cover.get(), color);
        } else {
            this.layers.clear();
            this.backgroundColor = color;
        }
        this.markDirty();
    }

    private void paintOverCover(Cover cover, int color) {
        Layer top;
        if (!this.layers.isEmpty() && cover.hasSamePatternAndRotation(top = (Layer)this.layers.peek(0))) {
            top.color = color;
            return;
        }
        this.layers.push((Object)cover.paint(color));
    }

    public boolean rotateCover() {
        if (this.cover.isPresent()) {
            Cover c = (Cover)this.cover.get();
            c.rotation = c.rotation.increment();
            this.markDirty();
            return true;
        }
        return false;
    }

    public Optional<StencilPattern> clearAll() {
        this.layers.clear();
        this.backgroundColor = 0;
        this.markDirty();
        Optional<Cover> cover = this.cover;
        this.cover = Optional.absent();
        return cover.transform(EXTRACT_PATTERN);
    }

    public boolean putStencil(StencilPattern stencil) {
        if (this.cover.isPresent()) {
            return false;
        }
        Cover cover = new Cover();
        cover.rotation = TextureOrientation.R0;
        cover.stencil = stencil;
        this.cover = Optional.of((Object)cover);
        this.markDirty();
        return true;
    }

    public Optional<StencilPattern> popStencil() {
        Optional<Cover> cover = this.cover;
        this.cover = Optional.absent();
        this.markDirty();
        return cover.transform(EXTRACT_PATTERN);
    }

    public Optional<StencilPattern> peekStencil() {
        return this.cover.transform(EXTRACT_PATTERN);
    }

    public boolean isEmpty() {
        return this.backgroundColor == 0 && this.layers.isEmpty();
    }

    public CanvasSideState convertToState() {
        CanvasSideState.Builder builder = CanvasSideState.builder().withBackground(this.backgroundColor);
        for (Layer layer : this.layers) {
            builder.addLayer(layer.stencil, layer.color, layer.rotation);
        }
        if (this.cover.isPresent()) {
            Cover c = (Cover)this.cover.get();
            return builder.withCover(c.stencil, c.rotation);
        }
        return builder.withoutCover();
    }

    private static class Cover
    extends Pattern {
        private Cover() {
        }

        public Layer paint(int color) {
            Layer result = new Layer();
            result.color = color;
            result.rotation = this.rotation;
            result.stencil = this.stencil;
            return result;
        }

        public static Optional<Cover> createFromStream(PacketBuffer stream) {
            if (!stream.readBoolean()) {
                return Optional.absent();
            }
            Cover cover = new Cover();
            try {
                cover.readFromStream(stream);
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to read stencil cover", (Object[])new Object[0]);
            }
            return Optional.of((Object)cover);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            return nbt;
        }

        public static Cover createFromNBT(NBTTagCompound tag) {
            Cover cover = new Cover();
            cover.readFromNBT(tag);
            return cover;
        }
    }

    private static class Layer
    extends Pattern {
        public int color;

        private Layer() {
        }

        public static Layer createFromStream(PacketBuffer stream) {
            Layer layer = new Layer();
            try {
                layer.color = stream.readInt();
                layer.readFromStream(stream);
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to read stencil layer", (Object[])new Object[0]);
            }
            return layer;
        }

        @Override
        public void writeToStream(PacketBuffer stream) {
            stream.writeInt(this.color);
            super.writeToStream(stream);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a(SyncableBlockLayers.TAG_COLOR, this.color);
            this.writeToNBT(nbt);
            return nbt;
        }

        public static Layer createFromNBT(NBTTagCompound tag) {
            Layer layer = new Layer();
            layer.color = tag.func_74762_e(SyncableBlockLayers.TAG_COLOR);
            layer.readFromNBT(tag);
            return layer;
        }
    }

    private static class Pattern {
        public StencilPattern stencil;
        public TextureOrientation rotation;

        private Pattern() {
        }

        public void readFromStream(PacketBuffer stream) {
            this.rotation = TextureOrientation.values()[stream.readByte()];
            this.stencil = StencilPattern.values()[stream.readByte()];
        }

        public void writeToStream(PacketBuffer stream) {
            stream.writeByte(this.rotation.ordinal());
            stream.writeByte(this.stencil.ordinal());
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.rotation = TextureOrientation.values()[tag.func_74771_c(SyncableBlockLayers.TAG_ROTATION)];
            this.stencil = StencilPattern.valueOf(tag.func_74779_i(SyncableBlockLayers.TAG_STENCIL));
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74774_a(SyncableBlockLayers.TAG_ROTATION, (byte)this.rotation.ordinal());
            tag.func_74778_a(SyncableBlockLayers.TAG_STENCIL, this.stencil.name());
        }

        public boolean hasSamePatternAndRotation(Pattern other) {
            return this.rotation == other.rotation && this.stencil == other.stencil;
        }
    }
}

