/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityTank;
import openmods.item.ItemOpenBlock;
import openmods.model.textureditem.IItemTexture;
import openmods.model.textureditem.ItemTextureCapability;
import openmods.utils.ItemUtils;
import openmods.utils.MiscUtils;
import openmods.utils.TranslationUtils;

public class ItemTankBlock
extends ItemOpenBlock {
    public static final String TANK_TAG = "tank";

    public ItemTankBlock(Block block) {
        super(block);
        this.func_185043_a(new ResourceLocation("level"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                FluidTank tank = ItemTankBlock.readTank(stack);
                return 16.0f * (float)tank.getFluidAmount() / (float)tank.getCapacity();
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProvider(new FluidHandler(stack), new ItemTexture(stack));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean extended) {
        FluidTank fakeTank = ItemTankBlock.readTank(stack);
        FluidStack fluidStack = fakeTank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            float percent = Math.max(100.0f / (float)fakeTank.getCapacity() * (float)fluidStack.amount, 1.0f);
            list.add(String.format("%d mB (%.0f%%)", fluidStack.amount, Float.valueOf(percent)));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String fluidName;
        FluidTank fakeTank = ItemTankBlock.readTank(stack);
        FluidStack fluidStack = fakeTank.getFluid();
        String unlocalizedName = this.func_77658_a();
        if (fluidStack != null && fluidStack.amount > 0 && !Strings.isNullOrEmpty((String)(fluidName = MiscUtils.getTranslatedFluidName((FluidStack)fluidStack)))) {
            return TranslationUtils.translateToLocalFormatted((String)(unlocalizedName + ".filled.name"), (Object[])new Object[]{fluidName});
        }
        return super.func_77653_i(stack);
    }

    public static ItemStack createFilledTank(Fluid fluid) {
        int tankCapacity = TileEntityTank.getTankCapacity();
        FluidStack stack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)tankCapacity);
        if (stack == null) {
            return null;
        }
        FluidTank tank = new FluidTank(tankCapacity);
        tank.setFluid(stack);
        ItemStack item = new ItemStack(OpenBlocks.Blocks.tank);
        ItemTankBlock.saveTank(item, tank);
        return item;
    }

    private static FluidTank readTank(ItemStack stack) {
        FluidTank tank = new FluidTank(TileEntityTank.getTankCapacity());
        NBTTagCompound itemTag = stack.func_77978_p();
        if (itemTag != null && itemTag.func_74764_b(TANK_TAG)) {
            tank.readFromNBT(itemTag.func_74775_l(TANK_TAG));
            return tank;
        }
        return tank;
    }

    private static void saveTank(ItemStack container, FluidTank tank) {
        if (tank.getFluidAmount() > 0) {
            NBTTagCompound itemTag = ItemUtils.getItemTag((ItemStack)container);
            NBTTagCompound tankTag = new NBTTagCompound();
            tank.writeToNBT(tankTag);
            itemTag.func_74782_a(TANK_TAG, (NBTBase)tankTag);
        } else {
            container.func_77982_d(null);
        }
    }

    private static class CapabilityProvider
    implements ICapabilityProvider {
        private final IFluidHandler fluidHandler;
        private final IItemTexture itemTexture;

        public CapabilityProvider(IFluidHandler fluidHandler, IItemTexture itemTexture) {
            this.fluidHandler = fluidHandler;
            this.itemTexture = itemTexture;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == ItemTextureCapability.CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.fluidHandler;
            }
            if (capability == ItemTextureCapability.CAPABILITY) {
                return (T)this.itemTexture;
            }
            return null;
        }
    }

    private static class ItemTexture
    implements IItemTexture {
        private final ItemStack container;

        public ItemTexture(ItemStack container) {
            this.container = container;
        }

        public Optional<ResourceLocation> getTexture() {
            FluidTank tank = ItemTankBlock.readTank(this.container);
            FluidStack stack = tank.getFluid();
            if (stack == null) {
                return Optional.absent();
            }
            Fluid fluid = stack.getFluid();
            return Optional.fromNullable((Object)fluid.getStill());
        }
    }

    private static class FluidHandler
    implements IFluidHandler {
        private final ItemStack container;

        public FluidHandler(ItemStack container) {
            this.container = container;
        }

        private FluidStack getFluid(FluidTank tank) {
            if (tank == null) {
                return null;
            }
            FluidStack result = tank.getFluid();
            if (result != null) {
                result.amount *= this.container.field_77994_a;
            }
            return result;
        }

        private int getCapacity(FluidTank tank) {
            return tank != null ? tank.getCapacity() * this.container.field_77994_a : 0;
        }

        public IFluidTankProperties[] getTankProperties() {
            FluidTank tank = ItemTankBlock.readTank(this.container);
            return new IFluidTankProperties[]{new FluidTankProperties(this.getFluid(tank), this.getCapacity(tank), true, true)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            FluidTank tank = ItemTankBlock.readTank(this.container);
            if (tank == null) {
                return 0;
            }
            int count = this.container.field_77994_a;
            if (count == 0) {
                return 0;
            }
            int amountPerTank = resource.amount / count;
            if (amountPerTank == 0) {
                return 0;
            }
            FluidStack resourcePerTank = resource.copy();
            resourcePerTank.amount = amountPerTank;
            int filledPerTank = tank.fill(resourcePerTank, doFill);
            if (doFill) {
                ItemTankBlock.saveTank(this.container, tank);
            }
            return filledPerTank * count;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            FluidTank tank = ItemTankBlock.readTank(this.container);
            if (tank == null) {
                return null;
            }
            if (!resource.isFluidEqual(tank.getFluid())) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain <= 0) {
                return null;
            }
            FluidTank tank = ItemTankBlock.readTank(this.container);
            if (tank == null) {
                return null;
            }
            return this.drain(tank, maxDrain, doDrain);
        }

        private FluidStack drain(FluidTank tank, int maxDrain, boolean doDrain) {
            int count = this.container.field_77994_a;
            if (count == 0) {
                return null;
            }
            int amountPerTank = maxDrain / count;
            if (amountPerTank == 0) {
                return null;
            }
            FluidStack drained = tank.drain(amountPerTank, doDrain);
            if (doDrain) {
                ItemTankBlock.saveTank(this.container, tank);
            }
            if (drained != null) {
                drained.amount *= count;
            }
            return drained;
        }
    }
}

