/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.PedometerHandler;
import openmods.utils.Units;

public class ItemPedometer
extends Item {
    private Units.SpeedUnit speedUnit = Units.SpeedUnit.M_PER_TICK;
    private Units.DistanceUnit distanceUnit = Units.DistanceUnit.M;

    public ItemPedometer() {
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("speed"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return (float)Math.sqrt(entityIn.field_70159_w * entityIn.field_70159_w + entityIn.field_70181_x * entityIn.field_70181_x + entityIn.field_70179_y * entityIn.field_70179_y);
            }
        });
    }

    private static void send(EntityPlayer player, String format, Object ... args) {
        player.func_146105_b((ITextComponent)new TextComponentTranslation(format, args));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            if (player.func_70093_af()) {
                PedometerHandler.getProperty((Entity)player).reset();
                ItemPedometer.send(player, "openblocks.misc.pedometer.tracking_reset", new Object[0]);
            } else {
                PedometerHandler.PedometerState state = PedometerHandler.getProperty((Entity)player);
                if (state.isRunning()) {
                    this.showPedometerData(player, state);
                } else {
                    state.init((Entity)player, world);
                    ItemPedometer.send(player, "openblocks.misc.pedometer.tracking_started", new Object[0]);
                }
            }
        } else {
            world.func_184133_a(null, player.func_180425_c(), OpenBlocks.Sounds.ITEM_PEDOMETER_USE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    protected void showPedometerData(EntityPlayer player, PedometerHandler.PedometerState state) {
        PedometerHandler.PedometerData result = state.getData();
        if (result == null) {
            return;
        }
        player.func_146105_b((ITextComponent)new TextComponentString(""));
        ItemPedometer.send(player, "openblocks.misc.pedometer.start_point", String.format("%.1f %.1f %.1f", result.startingPoint.field_72450_a, result.startingPoint.field_72448_b, result.startingPoint.field_72449_c));
        ItemPedometer.send(player, "openblocks.misc.pedometer.speed", this.speedUnit.format(result.currentSpeed));
        ItemPedometer.send(player, "openblocks.misc.pedometer.avg_speed", this.speedUnit.format(result.averageSpeed()));
        ItemPedometer.send(player, "openblocks.misc.pedometer.total_distance", this.distanceUnit.format(result.totalDistance));
        ItemPedometer.send(player, "openblocks.misc.pedometer.straght_line_distance", this.distanceUnit.format(result.straightLineDistance));
        ItemPedometer.send(player, "openblocks.misc.pedometer.straigh_line_speed", this.speedUnit.format(result.straightLineSpeed()));
        ItemPedometer.send(player, "openblocks.misc.pedometer.last_check_speed", this.speedUnit.format(result.lastCheckSpeed()));
        ItemPedometer.send(player, "openblocks.misc.pedometer.last_check_distance", this.distanceUnit.format(result.lastCheckDistance));
        ItemPedometer.send(player, "openblocks.misc.pedometer.last_check_time", result.lastCheckTime);
        ItemPedometer.send(player, "openblocks.misc.pedometer.total_time", result.totalTime);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        PedometerHandler.PedometerState state;
        if (world.field_72995_K && slotId < 9 && (state = PedometerHandler.getProperty(entity)).isRunning()) {
            state.update(entity);
        }
    }
}

