/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openmods.colors.ColorMeta;
import openmods.item.ItemOpenBlock;
import openmods.utils.ItemUtils;

public class ItemPaintCan
extends ItemOpenBlock {
    public static final String TAG_AMOUNT = "amount";
    public static final String TAG_COLOR = "color";
    public static final int FULL_CAN_SIZE = 30;
    private static final int COLOR_WHITE = 0xFFFFFF;

    public ItemPaintCan(Block block) {
        super(block);
        this.func_77656_e(30);
        this.func_77625_d(1);
    }

    public static int getColorFromStack(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_COLOR) : 0xFFFFFF;
    }

    public static int getAmountFromStack(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_AMOUNT) : 0;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> result) {
        for (ColorMeta meta : ColorMeta.getAllColors()) {
            result.add(ItemPaintCan.createStack(meta.rgb, 30));
        }
    }

    public static ItemStack createStack(int color, int amount) {
        ItemStack stack = new ItemStack(OpenBlocks.Blocks.paintCan);
        ItemPaintCan.setColorAndAmount(stack, color, amount);
        return stack;
    }

    public static void setColorAndAmount(ItemStack stack, int color, int amount) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
        tag.func_74768_a(TAG_AMOUNT, amount);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean extended) {
        list.add(String.format("#%06X", ItemPaintCan.getColorFromStack(stack)));
    }

    public int getDamage(ItemStack stack) {
        return 30 - ItemPaintCan.getAmountFromStack(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemPaintCan.getAmountFromStack(stack) / 30.0;
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77942_o() && ItemPaintCan.getAmountFromStack(stack) < 30;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            return tintIndex == 1 ? ItemPaintCan.getColorFromStack(stack) : 0xFFFFFF;
        }
    }
}

