/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openblocks.common.MapDataManager;
import openmods.utils.ItemUtils;

public class ItemEmptyMap
extends Item {
    public static final String TAG_SCALE = "Scale";
    public static final int MAX_SCALE = 4;

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List<String> result, boolean extended) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)item);
        result.add(String.format("Scale: 1:%d", 1 << tag.func_74771_c(TAG_SCALE)));
    }

    public static ItemStack createMap(Item item, int scale) {
        ItemStack result = new ItemStack(item);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)result);
        tag.func_74774_a(TAG_SCALE, (byte)scale);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> result) {
        for (int scale = 0; scale < 4; ++scale) {
            result.add(ItemEmptyMap.createMap(this, scale));
        }
    }

    public static ItemStack upgradeToMap(World world, ItemStack emptyMap) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)emptyMap);
        byte scale = tag.func_74771_c(TAG_SCALE);
        int newMapId = MapDataManager.createNewMap(world, scale);
        return new ItemStack(OpenBlocks.Items.heightMap, 1, newMapId);
    }
}

