/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import openblocks.Config;
import openblocks.common.CraneRegistry;
import openblocks.common.entity.EntityMagnet;
import openblocks.common.item.ItemCraneBackpack;
import openmods.OpenMods;
import openmods.infobook.BookDocumentation;
import openmods.model.itemstate.IStateItem;
import openmods.state.State;
import openmods.state.StateContainer;

@BookDocumentation(customName="crane_control", hasVideo=true)
public class ItemCraneControl
extends Item
implements IStateItem {
    private static final Map<EntityLivingBase, Long> debouncerTime = new MapMaker().weakKeys().makeMap();
    private static final IProperty<LiftState> liftProperty = PropertyEnum.func_177709_a((String)"lift", LiftState.class);
    private static final IProperty<MagnetState> magnetProperty = PropertyEnum.func_177709_a((String)"magnet", MagnetState.class);
    private final StateContainer stateContainer = new StateContainer(new IProperty[]{liftProperty, magnetProperty});
    private final State defaultState = this.stateContainer.getBaseState().withProperty(liftProperty, (Comparable)((Object)LiftState.IDLE)).withProperty(magnetProperty, (Comparable)((Object)MagnetState.IDLE));

    public ItemCraneControl() {
        this.func_77625_d(1);
    }

    private static boolean hasClicked(EntityLivingBase entity) {
        long currentTime = OpenMods.proxy.getTicks(entity.field_70170_p);
        Long lastClick = debouncerTime.get(entity);
        if (lastClick == null || currentTime - lastClick > 5L) {
            debouncerTime.put(entity, currentTime);
            return true;
        }
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        EntityPlayer player;
        EntityMagnet magnet;
        if (entityLiving instanceof EntityPlayer && ItemCraneControl.hasClicked(entityLiving) && (magnet = CraneRegistry.instance.getMagnetForPlayer((EntityLivingBase)(player = (EntityPlayer)entityLiving))) != null) {
            magnet.toggleMagnet();
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        CraneRegistry.Data data = CraneRegistry.instance.getData((EntityLivingBase)player, false);
        if (data != null) {
            data.isExtending = Config.craneShiftControl ? player.func_70093_af() : !data.isExtending;
        }
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player instanceof EntityPlayerMP && ItemCraneBackpack.isWearingCrane(player)) {
            CraneRegistry.Data data = CraneRegistry.instance.getData(player, true);
            data.updateLength();
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public StateContainer getStateContainer() {
        return this.stateContainer;
    }

    public State getState(ItemStack stack, World world, EntityLivingBase entity) {
        CraneRegistry.Data data;
        if (entity != null && ItemCraneBackpack.isWearingCrane(entity) && (data = CraneRegistry.instance.getData(entity, false)) != null) {
            EntityMagnet magnet;
            State state = this.defaultState;
            if (entity.func_184607_cu() == stack) {
                state = state.withProperty(liftProperty, (Comparable)((Object)(data.isExtending ? LiftState.DOWN : LiftState.UP)));
            }
            if ((magnet = CraneRegistry.instance.getMagnetForPlayer(entity)) != null) {
                if (magnet.isLocked()) {
                    state = state.withProperty(magnetProperty, (Comparable)((Object)MagnetState.LOCKED));
                } else if (magnet.isAboveTarget()) {
                    state = state.withProperty(magnetProperty, (Comparable)((Object)MagnetState.DETECTING));
                }
            }
            return state;
        }
        return this.defaultState;
    }

    private static enum MagnetState implements IStringSerializable
    {
        IDLE,
        DETECTING,
        LOCKED;


        public String func_176610_l() {
            return this.name();
        }
    }

    private static enum LiftState implements IStringSerializable
    {
        IDLE,
        DOWN,
        UP;


        public String func_176610_l() {
            return this.name();
        }
    }
}

