/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.common.entity.EntitySmoothMove;

public class EntityGoldenEye
extends EntitySmoothMove {
    private static final int TTL = 60;
    private int timeToLive;
    private ItemStack spawningStack;

    public EntityGoldenEye(World world, ItemStack spawningStack, Entity owner, BlockPos target) {
        super(world);
        this.timeToLive = 60;
        this.spawningStack = spawningStack.func_77946_l();
        this.targetStructure(owner, target);
        this.func_70105_a(0.02f, 0.02f);
    }

    public EntityGoldenEye(World world) {
        super(world);
        this.func_70105_a(0.02f, 0.02f);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
        if (tag.func_74764_b("SpawningItem")) {
            NBTTagCompound item = tag.func_74775_l("SpawningItem");
            this.spawningStack = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        if (this.spawningStack != null) {
            NBTTagCompound item = this.spawningStack.func_77955_b(new NBTTagCompound());
            tag.func_74782_a("SpawningItem", (NBTBase)item);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.timeToLive-- < 0) {
            this.func_70106_y();
            if (this.spawningStack != null) {
                EntityItem dropped = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.spawningStack);
                this.field_70170_p.func_72838_d((Entity)dropped);
            }
            return;
        }
        this.updatePrevPosition();
        this.smoother.update();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.3 - 0.15, this.field_70163_u - 0.5 + this.field_70146_Z.nextGaussian() * 0.3 - 0.15, this.field_70161_v - this.field_70146_Z.nextGaussian() * 0.3 - 0.15, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
        }
    }

    private void targetStructure(Entity owner, BlockPos target) {
        double playerY = owner.field_70163_u + (double)owner.func_70047_e();
        double dx = (double)target.func_177958_n() - owner.field_70165_t;
        double dz = (double)target.func_177952_p() - owner.field_70161_v;
        double dist = Math.sqrt(dx * dx + dz * dz);
        dx /= dist;
        dz /= dist;
        double yaw = Math.toRadians(owner.field_70177_z);
        double px = -Math.sin(yaw);
        double pz = Math.cos(yaw);
        this.func_70107_b(owner.field_70165_t + 0.75 * px, playerY, owner.field_70161_v + 0.75 * pz);
        double targetX = owner.field_70165_t;
        double targetY = playerY;
        double targetZ = owner.field_70161_v;
        if (dist < 16.0) {
            targetY -= 4.0;
            this.field_70125_A = 90.0f;
        } else {
            targetX += 6.0 * dx;
            targetZ += 6.0 * dz;
            this.field_70177_z = (float)Math.toDegrees(Math.atan2(dx, dz));
        }
        this.func_70107_b(targetX, targetY, targetZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }
}

