/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openmods.block.OpenBlock;
import openmods.infobook.BookDocumentation;

@BookDocumentation(customName="sky.normal")
public class BlockSky
extends OpenBlock {
    private static final int MASK_INVERTED = 1;
    private static final int MASK_POWERED = 2;
    private static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final PropertyBool INVERTED = PropertyBool.func_177716_a((String)"inverted");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public static boolean isInverted(int meta) {
        return (meta & 1) != 0;
    }

    public BlockSky() {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.setRequiresInitialization(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), INVERTED, POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 2) != 0)).func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf((meta & 1) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int isPowered = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 2 : 0;
        int isInverted = (Boolean)state.func_177229_b((IProperty)INVERTED) != false ? 1 : 0;
        return isPowered | isInverted;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos blockPos, Block neighbour) {
        this.updatePowerState(state, world, blockPos);
        super.func_189540_a(state, world, blockPos, neighbour);
    }

    protected boolean onBlockAddedNextTick(World world, BlockPos blockPos, IBlockState state) {
        this.updatePowerState(state, world, blockPos);
        return super.onBlockAddedNextTick(world, blockPos, state);
    }

    private void updatePowerState(IBlockState state, World world, BlockPos pos) {
        boolean isActive;
        boolean isPowered;
        if (!world.field_72995_K && (isPowered = world.func_175687_A(pos) > 0) != (isActive = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue())) {
            world.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        boolean isPowered = world.func_175687_A(pos) > 0;
        world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isPowered)));
    }

    public static boolean isActive(IBlockState state) {
        boolean isPowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean isInverted = (Boolean)state.func_177229_b((IProperty)INVERTED);
        return isPowered ^ isInverted;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return BlockSky.isActive(state) ? EMPTY : super.func_180640_a(state, world, pos);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return BlockSky.isActive(state) ? EnumBlockRenderType.ENTITYBLOCK_ANIMATED : EnumBlockRenderType.MODEL;
    }
}

