/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.common.tileentity.TileEntityFlag;
import openmods.block.OpenBlock;
import openmods.colors.ColorMeta;
import openmods.geometry.Orientation;
import openmods.model.eval.EvalModelState;

public class BlockFlag
extends OpenBlock.SixDirections {
    public static final ColorMeta DEFAULT_COLOR = ColorMeta.LIME;
    public static final PropertyEnum<ColorMeta> COLOR = PropertyEnum.func_177709_a((String)"color", ColorMeta.class);
    private static final AxisAlignedBB MIDDLE_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
    private static final AxisAlignedBB NS_AABB = new AxisAlignedBB(0.4375, 0.0, 0.1875, 0.5625, 1.0, 0.8125);
    private static final AxisAlignedBB WE_AABB = new AxisAlignedBB(0.1875, 0.0, 0.4375, 0.8125, 1.0, 0.5625);

    public BlockFlag() {
        super(Material.field_151594_q);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
        this.func_149711_c(0.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(COLOR, (Comparable)DEFAULT_COLOR));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.getPropertyOrientation(), COLOR}, new IUnlistedProperty[]{EvalModelState.PROPERTY});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176212_b(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntityFlag flag = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)source, (BlockPos)pos, TileEntityFlag.class));
        if (flag != null) {
            EnumFacing onSurface = flag.getOrientation().down();
            switch (onSurface) {
                case EAST: 
                case WEST: {
                    return WE_AABB;
                }
                case NORTH: 
                case SOUTH: {
                    return NS_AABB;
                }
            }
            return MIDDLE_AABB;
        }
        return MIDDLE_AABB;
    }

    private boolean isFlagOnGround(IBlockState state) {
        return ((Orientation)state.func_177229_b(this.getPropertyOrientation())).down() == EnumFacing.DOWN;
    }

    private boolean isBaseSolidForFlag(World world, BlockPos pos) {
        IBlockState belowState = world.func_180495_p(pos.func_177977_b());
        Block belowBlock = belowState.func_177230_c();
        if (belowBlock instanceof BlockFence) {
            return true;
        }
        return belowBlock == this && this.isFlagOnGround(belowState);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return false;
        }
        if (side == EnumFacing.UP && this.isBaseSolidForFlag(world, pos)) {
            return true;
        }
        return BlockFlag.isNeighborBlockSolid((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side.func_176734_d());
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        super.func_189540_a(state, world, pos, block);
        Orientation orientation = this.getOrientation(state);
        EnumFacing down = orientation.down();
        if (BlockFlag.isNeighborBlockSolid((IBlockAccess)world, (BlockPos)pos, (EnumFacing)down)) {
            return;
        }
        if (this.isFlagOnGround(state) && this.isBaseSolidForFlag(world, pos)) {
            return;
        }
        world.func_175655_b(pos, true);
    }

    public boolean canRotateWithTool() {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    private static ColorMeta getColorMeta(IBlockAccess world, BlockPos pos) {
        TileEntityFlag te = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityFlag.class));
        return te != null ? te.getColor() : ColorMeta.WHITE;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        ColorMeta color = BlockFlag.getColorMeta(world, pos);
        return state.func_177226_a(COLOR, (Comparable)color);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, BlockFlag.DEFAULT_COLOR.vanillaBlockId));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityFlag te = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityFlag.class));
        return te != null ? ((IExtendedBlockState)state).withProperty(EvalModelState.PROPERTY, (Object)te.getRenderState()) : state;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
        super.func_180653_a(worldIn, pos, actualState, chance, fortune);
    }

    public int func_180651_a(IBlockState state) {
        return ((ColorMeta)state.func_177229_b(BlockFlag.COLOR)).vanillaBlockId;
    }

    @SideOnly(value=Side.CLIENT)
    public static class BlockColorHandler
    implements IBlockColor {
        private static final int WHITE = -1;

        public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            return tintIndex == 0 ? ((ColorMeta)state.func_177229_b(BlockFlag.COLOR)).rgb : -1;
        }
    }
}

