/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.api.IElevatorBlock;
import openmods.block.OpenBlock;
import openmods.colors.ColorMeta;
import openmods.infobook.BookDocumentation;
import openmods.utils.CollectionUtils;

@BookDocumentation(hasVideo=true)
public class BlockElevator
extends OpenBlock
implements IElevatorBlock {
    public static final PropertyEnum<ColorMeta> COLOR = PropertyEnum.func_177709_a((String)"color", ColorMeta.class);

    public BlockElevator() {
        super(Material.field_151576_e);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)ColorMeta.fromBlockMeta((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((ColorMeta)state.func_177229_b(BlockElevator.COLOR)).vanillaBlockId;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), COLOR});
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor colour) {
        IBlockState state;
        ColorMeta currentColor;
        ColorMeta newColor = ColorMeta.fromVanillaEnum((EnumDyeColor)colour);
        if (newColor != (currentColor = (ColorMeta)(state = world.func_180495_p(pos)).func_177229_b(COLOR))) {
            world.func_175656_a(pos, state.func_177226_a(COLOR, (Comparable)newColor));
            return true;
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((ColorMeta)state.func_177229_b(BlockElevator.COLOR)).vanillaBlockId;
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((ColorMeta)state.func_177229_b(BlockElevator.COLOR)).vanillaEnum.func_176768_e();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        Set metas;
        if (hand == EnumHand.MAIN_HAND && heldItem != null && !(metas = ColorMeta.fromStack((ItemStack)heldItem)).isEmpty()) {
            ColorMeta meta = (ColorMeta)CollectionUtils.getRandom((Collection)metas);
            return world.func_175656_a(pos, state.func_177226_a(COLOR, (Comparable)meta));
        }
        return false;
    }

    @Override
    public EnumDyeColor getColor(World world, BlockPos pos, IBlockState state) {
        return ((ColorMeta)state.func_177229_b(BlockElevator.COLOR)).vanillaEnum;
    }

    @Override
    public IElevatorBlock.PlayerRotation getRotation(World world, BlockPos pos, IBlockState state) {
        return IElevatorBlock.PlayerRotation.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public static class BlockColorHandler
    implements IBlockColor {
        private static final int WHITE = -1;

        public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            return tintIndex == 0 ? ((ColorMeta)state.func_177229_b(BlockElevator.COLOR)).rgb : -1;
        }
    }
}

