/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openblocks.api.IPaintableBlock;
import openblocks.client.renderer.block.canvas.CanvasState;
import openblocks.client.renderer.block.canvas.InnerBlockState;
import openblocks.common.tileentity.TileEntityCanvas;
import openmods.block.OpenBlock;
import openmods.colors.ColorMeta;
import openmods.infobook.BookDocumentation;

@BookDocumentation(hasVideo=true)
public class BlockCanvas
extends OpenBlock
implements IPaintableBlock {
    public static final PropertyEnum<CanvasMaterial> MATERIAL = PropertyEnum.func_177709_a((String)"material", CanvasMaterial.class);

    public BlockCanvas() {
        super(Material.field_151583_m);
    }

    public static boolean replaceBlock(World world, BlockPos pos) {
        Block toReplace;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockCanvas) {
            return true;
        }
        Block block = toReplace = state.func_185914_p() ? OpenBlocks.Blocks.canvas : OpenBlocks.Blocks.canvasGlass;
        if (toReplace == null) {
            return false;
        }
        CanvasMaterial material = CanvasMaterial.wrap(state.func_185904_a());
        world.func_175656_a(pos, toReplace.func_176223_P().func_177226_a(MATERIAL, (Comparable)((Object)material)));
        TileEntityCanvas tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityCanvas.class));
        if (tile != null) {
            tile.setPaintedBlock(state);
        }
        return true;
    }

    @Override
    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, int color) {
        TileEntityCanvas te = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityCanvas.class));
        return te != null ? te.applyPaint(0xFF000000 | color, side) : false;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor colour) {
        ColorMeta color = ColorMeta.fromVanillaEnum((EnumDyeColor)colour);
        return this.recolorBlock(world, pos, side, color.rgb);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.getPropertyOrientation(), MATERIAL}, new IUnlistedProperty[]{CanvasState.PROPERTY, InnerBlockState.PROPERTY});
    }

    public int func_176201_c(IBlockState state) {
        return ((CanvasMaterial)((Object)state.func_177229_b(MATERIAL))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(MATERIAL, (Comparable)((Object)CanvasMaterial.ID_TO_VALUE[meta]));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        TileEntityCanvas te = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityCanvas.class));
        if (te != null) {
            return extendedState.withProperty(CanvasState.PROPERTY, (Object)te.getCanvasState()).withProperty(InnerBlockState.PROPERTY, (Object)te.getActualPaintedBlockState());
        }
        return extendedState;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    private static <T> T getPaintedBlockProperty(IBlockAccess world, @Nullable IBlockState state, BlockPos pos, IBlockPropertyGetter<T> getter, IBlockPropertyGetter<T> defaultValue) {
        IBlockState paintedBlockState;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCanvas && (paintedBlockState = ((TileEntityCanvas)te).getPaintedBlockState()) != Blocks.field_150350_a.func_176223_P()) {
            World actualWorld = te.func_145831_w();
            TileEntityCanvas.UnpackingBlockAccess fakedWorldAccess = new TileEntityCanvas.UnpackingBlockAccess(actualWorld);
            if (actualWorld != null) {
                try {
                    return getter.get(paintedBlockState, fakedWorldAccess, pos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue.get(state, world, pos);
    }

    private static <T> T getPaintedBlockProperty(IBlockAccess world, IBlockState state, BlockPos pos, IBlockPropertyGetter<T> getter, final T defaultValue) {
        return (T)BlockCanvas.getPaintedBlockProperty(world, state, pos, getter, new IBlockPropertyGetter<T>(){

            @Override
            public T get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return defaultValue;
            }
        });
    }

    private static <T> T getPaintedBlockProperty(World world, IBlockState state, BlockPos pos, IWorldBlockPropertyGetter<T> getter, IWorldBlockPropertyGetter<T> defaultValue) {
        IBlockState paintedBlockState;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCanvas && (paintedBlockState = ((TileEntityCanvas)te).getPaintedBlockState()) != Blocks.field_150350_a.func_176223_P()) {
            try {
                return getter.get(paintedBlockState, world, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue.get(state, world, pos);
    }

    private static <T> T getPaintedBlockProperty(World world, IBlockState state, BlockPos pos, IWorldBlockPropertyGetter<T> getter, final T defaultValue) {
        return (T)BlockCanvas.getPaintedBlockProperty(world, state, pos, getter, new IWorldBlockPropertyGetter<T>(){

            @Override
            public T get(IBlockState state, World world, BlockPos pos) {
                return defaultValue;
            }
        });
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(world, state, pos, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.getLightOpacity(world, pos);
            }
        }, Integer.valueOf(this.field_149786_r));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(world, state, pos, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.getLightValue(world, pos);
            }
        }, Integer.valueOf(this.field_149784_t));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Integer)((Object)BlockCanvas.getPaintedBlockProperty(source, state, pos, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_185889_a(world, pos);
            }
        }, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return BlockCanvas.super.func_185484_c(state, world, pos);
            }
        }));
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, final EnumFacing side) {
        return BlockCanvas.getPaintedBlockProperty(blockAccess, blockState, pos, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_185911_a(world, pos, side);
            }
        }, Integer.valueOf(0));
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, final EnumFacing side) {
        return BlockCanvas.getPaintedBlockProperty(blockAccess, blockState, pos, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_185893_b(world, pos, side);
            }
        }, Integer.valueOf(0));
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(worldIn, blockState, pos, new IWorldBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, World world, BlockPos pos) {
                return state.func_185888_a(world, pos);
            }
        }, Integer.valueOf(0));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(worldIn, blockState, pos, new IWorldBlockPropertyGetter<Float>(){

            @Override
            public Float get(IBlockState state, World world, BlockPos pos) {
                return Float.valueOf(state.func_185887_b(world, pos));
            }
        }, Float.valueOf(this.field_149782_v)).floatValue();
    }

    public float func_180647_a(IBlockState state, final EntityPlayer player, World worldIn, BlockPos pos) {
        return ((Float)((Object)BlockCanvas.getPaintedBlockProperty(worldIn, state, pos, new IWorldBlockPropertyGetter<Float>(){

            @Override
            public Float get(IBlockState state, World world, BlockPos pos) {
                return Float.valueOf(state.func_185903_a(player, world, pos));
            }
        }, new IWorldBlockPropertyGetter<Float>(){

            @Override
            public Float get(IBlockState state, World world, BlockPos pos) {
                return Float.valueOf(BlockCanvas.super.func_180647_a(state, player, world, pos));
            }
        }))).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return (AxisAlignedBB)BlockCanvas.getPaintedBlockProperty(worldIn, state, pos, new IWorldBlockPropertyGetter<AxisAlignedBB>(){

            @Override
            public AxisAlignedBB get(IBlockState state, World world, BlockPos pos) {
                return state.func_185918_c(world, pos);
            }
        }, new IWorldBlockPropertyGetter<AxisAlignedBB>(){

            @Override
            public AxisAlignedBB get(IBlockState state, World world, BlockPos pos) {
                return Block.field_185505_j.func_186670_a(pos);
            }
        });
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(worldIn, blockState, pos, new IWorldBlockPropertyGetter<AxisAlignedBB>(){

            @Override
            public AxisAlignedBB get(IBlockState state, World world, BlockPos pos) {
                return state.func_185890_d(world, pos);
            }
        }, field_185505_j);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(source, state, pos, new IBlockPropertyGetter<AxisAlignedBB>(){

            @Override
            public AxisAlignedBB get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_185900_c(world, pos);
            }
        }, field_185505_j);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, final AxisAlignedBB entityBox, final List<AxisAlignedBB> collidingBoxes, final @Nullable Entity entityIn) {
        BlockCanvas.getPaintedBlockProperty(worldIn, state, pos, new IWorldBlockPropertyGetter<Void>(){

            @Override
            public Void get(IBlockState state, World world, BlockPos pos) {
                state.func_185908_a(world, pos, entityBox, collidingBoxes, entityIn);
                return null;
            }
        }, new IWorldBlockPropertyGetter<Void>(){

            @Override
            public Void get(IBlockState state, World world, BlockPos pos) {
                BlockCanvas.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)Block.field_185505_j);
                return null;
            }
        });
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, final Vec3d start, final Vec3d end) {
        return (RayTraceResult)BlockCanvas.getPaintedBlockProperty(worldIn, blockState, pos, new IWorldBlockPropertyGetter<RayTraceResult>(){

            @Override
            public RayTraceResult get(IBlockState state, World world, BlockPos pos) {
                return state.func_185910_a(world, pos, start, end);
            }
        }, new IWorldBlockPropertyGetter<RayTraceResult>(){

            @Override
            public RayTraceResult get(IBlockState state, World world, BlockPos pos) {
                return BlockCanvas.this.func_185503_a(pos, start, end, Block.field_185505_j);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, final EnumFacing side) {
        return BlockCanvas.getPaintedBlockProperty(blockAccess, blockState, pos, new IBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_185894_c(world, pos, side);
            }
        }, Boolean.valueOf(true));
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, final EnumFacing face) {
        return BlockCanvas.getPaintedBlockProperty(world, state, pos, new IBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.doesSideBlockRendering(world, pos, face);
            }
        }, Boolean.TRUE);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, final EnumFacing side) {
        return BlockCanvas.getPaintedBlockProperty(world, base_state, pos, new IBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.isSideSolid(world, pos, side);
            }
        }, Boolean.TRUE);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(worldIn, null, pos, new IBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_177230_c().func_176205_b(world, pos);
            }
        }, Boolean.FALSE);
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(world, state, pos, new IBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_177230_c().canSustainLeaves(state, world, pos);
            }
        }, Boolean.FALSE);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, final EnumFacing direction, final IPlantable plantable) {
        return BlockCanvas.getPaintedBlockProperty(world, state, pos, new IBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_177230_c().canSustainPlant(state, world, pos, direction, plantable);
            }
        }, Boolean.FALSE);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(world, null, pos, new IWorldBlockPropertyGetter<Float>(){

            @Override
            public Float get(IBlockState state, World world, BlockPos pos) {
                return Float.valueOf(state.func_177230_c().getEnchantPowerBonus(world, pos));
            }
        }, Float.valueOf(0.0f)).floatValue();
    }

    public float getExplosionResistance(World world, BlockPos pos, final Entity exploder, final Explosion explosion) {
        return BlockCanvas.getPaintedBlockProperty(world, null, pos, new IWorldBlockPropertyGetter<Float>(){

            @Override
            public Float get(IBlockState state, World world, BlockPos pos) {
                return Float.valueOf(state.func_177230_c().getExplosionResistance(world, pos, exploder, explosion));
            }
        }, Float.valueOf(super.func_149638_a(exploder))).floatValue();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, final EnumFacing face) {
        return (Integer)((Object)BlockCanvas.getPaintedBlockProperty(world, null, pos, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_177230_c().getFlammability(world, pos, face);
            }
        }, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return BlockCanvas.super.getFlammability(world, pos, face);
            }
        }));
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, final EnumFacing face) {
        return BlockCanvas.getPaintedBlockProperty(world, null, pos, new IBlockPropertyGetter<Integer>(){

            @Override
            public Integer get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_177230_c().getFireSpreadSpeed(world, pos, face);
            }
        }, Integer.valueOf(200));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, final EnumFacing face) {
        return BlockCanvas.getPaintedBlockProperty(world, null, pos, new IBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_177230_c().isFlammable(world, pos, face);
            }
        }, Boolean.TRUE);
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(world, null, pos, new IBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, IBlockAccess world, BlockPos pos) {
                return state.func_177230_c().isBurning(world, pos);
            }
        }, Boolean.FALSE);
    }

    public boolean isFireSource(World world, BlockPos pos, final EnumFacing side) {
        return BlockCanvas.getPaintedBlockProperty(world, null, pos, new IWorldBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, World world, BlockPos pos) {
                return state.func_177230_c().isFireSource(world, pos, side);
            }
        }, Boolean.FALSE);
    }

    public boolean isFertile(World world, BlockPos pos) {
        return BlockCanvas.getPaintedBlockProperty(world, null, pos, new IWorldBlockPropertyGetter<Boolean>(){

            @Override
            public Boolean get(IBlockState state, World world, BlockPos pos) {
                return state.func_177230_c().isFertile(world, pos);
            }
        }, Boolean.FALSE);
    }

    public void func_180658_a(World worldIn, BlockPos pos, final Entity entityIn, final float fallDistance) {
        BlockCanvas.getPaintedBlockProperty(worldIn, null, pos, new IWorldBlockPropertyGetter<Void>(){

            @Override
            public Void get(IBlockState state, World world, BlockPos pos) {
                state.func_177230_c().func_180658_a(world, pos, entityIn, fallDistance);
                return null;
            }
        }, new IWorldBlockPropertyGetter<Void>(){

            @Override
            public Void get(IBlockState state, World world, BlockPos pos) {
                BlockCanvas.super.func_180658_a(world, pos, entityIn, fallDistance);
                return null;
            }
        });
    }

    public void func_176216_a(World worldIn, final Entity entityIn) {
        BlockPos pos = new BlockPos(entityIn.field_70165_t, entityIn.field_70163_u - 0.2, entityIn.field_70161_v);
        BlockCanvas.getPaintedBlockProperty(worldIn, null, pos, new IWorldBlockPropertyGetter<Void>(){

            @Override
            public Void get(IBlockState state, World world, BlockPos pos) {
                state.func_177230_c().func_176216_a(world, entityIn);
                return null;
            }
        }, new IWorldBlockPropertyGetter<Void>(){

            @Override
            public Void get(IBlockState state, World world, BlockPos pos) {
                BlockCanvas.super.func_176216_a(world, entityIn);
                return null;
            }
        });
    }

    public void func_176199_a(World worldIn, BlockPos pos, final Entity entityIn) {
        BlockCanvas.getPaintedBlockProperty(worldIn, null, pos, new IWorldBlockPropertyGetter<Void>(){

            @Override
            public Void get(IBlockState state, World world, BlockPos pos) {
                state.func_177230_c().func_176199_a(world, pos, entityIn);
                return null;
            }
        }, new IWorldBlockPropertyGetter<Void>(){

            @Override
            public Void get(IBlockState state, World world, BlockPos pos) {
                BlockCanvas.super.func_176199_a(world, pos, entityIn);
                return null;
            }
        });
    }

    public SoundType getSoundType(IBlockState state, World worldIn, BlockPos pos, final Entity entity) {
        return BlockCanvas.getPaintedBlockProperty(worldIn, state, pos, new IWorldBlockPropertyGetter<SoundType>(){

            @Override
            public SoundType get(IBlockState state, World world, BlockPos pos) {
                return state.func_177230_c().getSoundType(state, world, pos, entity);
            }
        }, this.field_149762_H);
    }

    public Material func_149688_o(IBlockState state) {
        return ((CanvasMaterial)((Object)state.func_177229_b(BlockCanvas.MATERIAL))).material;
    }

    private static interface IWorldBlockPropertyGetter<T> {
        public T get(IBlockState var1, World var2, BlockPos var3);
    }

    private static interface IBlockPropertyGetter<T> {
        public T get(IBlockState var1, IBlockAccess var2, BlockPos var3);
    }

    public static class InnerBlockColorHandler
    implements IBlockColor {
        private final BlockColors blockColors;

        public InnerBlockColorHandler(BlockColors blockColors) {
            this.blockColors = blockColors;
        }

        public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            IExtendedBlockState extendedState;
            IBlockState innerState;
            if (state instanceof IExtendedBlockState && (innerState = (IBlockState)(extendedState = (IExtendedBlockState)state).getValue(InnerBlockState.PROPERTY)) != null) {
                return this.blockColors.func_186724_a(innerState, worldIn, pos, tintIndex);
            }
            return -1;
        }
    }

    protected static enum CanvasMaterial implements IStringSerializable
    {
        SPONGE(Material.field_151583_m),
        GRASS(Material.field_151577_b),
        GROUND(Material.field_151578_c),
        WOOD(Material.field_151575_d),
        ROCK(Material.field_151576_e),
        IRON(Material.field_151573_f),
        LEAVES(Material.field_151584_j),
        PLANTS(Material.field_151585_k),
        CLOTH(Material.field_151580_n),
        SAND(Material.field_151595_p),
        CIRCUITS(Material.field_151594_q),
        GLASS(Material.field_151592_s),
        ICE(Material.field_151588_w),
        SNOW(Material.field_151597_y),
        CLAY(Material.field_151571_B),
        CARPET(Material.field_151593_r);

        private static final Map<Material, CanvasMaterial> MATERIAL_TO_VALUE;
        private static final CanvasMaterial[] ID_TO_VALUE;
        public final Material material;
        public final String name;

        private CanvasMaterial(Material material) {
            this.material = material;
            this.name = this.name().toLowerCase(Locale.ROOT);
        }

        public static CanvasMaterial wrap(Material material) {
            CanvasMaterial result = MATERIAL_TO_VALUE.get(material);
            return result != null ? result : SPONGE;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            ID_TO_VALUE = new CanvasMaterial[16];
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int i = 0;
            for (CanvasMaterial material : CanvasMaterial.values()) {
                builder.put((Object)material.material, (Object)material);
                CanvasMaterial.ID_TO_VALUE[i++] = material;
            }
            while (i < 16) {
                CanvasMaterial.ID_TO_VALUE[i++] = SPONGE;
            }
            MATERIAL_TO_VALUE = builder.build();
        }
    }
}

