/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;
import openmods.utils.BlockUtils;
import openmods.utils.PlayerUtils;

public class EntityEventHandler {
    public static final String OPENBLOCKS_PERSIST_TAG = "OpenBlocks";
    public static final String GIVEN_MANUAL_TAG = "givenManual";
    public static final String LATEST_CHANGELOG_TAG = "latestChangelog";
    private Set<Class<? extends Entity>> entityBlacklist;

    private Set<Class<? extends Entity>> getBlacklist() {
        if (this.entityBlacklist == null) {
            this.entityBlacklist = Sets.newIdentityHashSet();
            HashSet unknownNames = Sets.newHashSet();
            for (String name : Config.disableMobNames) {
                Class cls = (Class)EntityList.field_75625_b.get(name);
                if (cls != null) {
                    this.entityBlacklist.add(cls);
                    continue;
                }
                unknownNames.add(name);
            }
            for (Class cls : EntityList.field_75626_c.keySet()) {
                if (unknownNames.isEmpty()) break;
                if (!unknownNames.remove(cls.getName())) continue;
                this.entityBlacklist.add(cls);
            }
            if (!unknownNames.isEmpty()) {
                Log.warn((String)"Can't identify mobs for blacklist: %s", (Object[])new Object[]{unknownNames});
            }
        }
        return this.entityBlacklist;
    }

    @SubscribeEvent
    public void onReconfigure(ConfigurationChange.Post evt) {
        if (evt.check("additional", "disableMobNames")) {
            this.entityBlacklist = null;
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Set<Class<? extends Entity>> blacklist;
        Entity entity = event.getEntity();
        if (entity != null && (blacklist = this.getBlacklist()).contains(entity.getClass())) {
            entity.func_70106_y();
            event.setCanceled(true);
            return;
        }
        if (Config.spamInfoBook && !event.getWorld().field_72995_K && entity instanceof EntityPlayer) {
            boolean shouldGiveManual;
            EntityPlayer player = (EntityPlayer)entity;
            NBTTagCompound persistTag = PlayerUtils.getModPlayerPersistTag((EntityPlayer)player, (String)OPENBLOCKS_PERSIST_TAG);
            boolean bl = shouldGiveManual = OpenBlocks.Items.infoBook != null && !persistTag.func_74767_n(GIVEN_MANUAL_TAG);
            if (shouldGiveManual) {
                ItemStack manual = new ItemStack(OpenBlocks.Items.infoBook);
                if (!player.field_71071_by.func_70441_a(manual)) {
                    BlockUtils.dropItemStackInWorld((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)manual);
                }
                persistTag.func_74757_a(GIVEN_MANUAL_TAG, true);
            }
        }
    }
}

