/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.api.ElevatorCheckEvent;
import openblocks.api.IElevatorBlock;
import openmods.Log;
import openmods.colors.ColorMeta;
import openmods.config.properties.ConfigurationChange;

public class ElevatorBlockRules {
    public static final ElevatorBlockRules instance = new ElevatorBlockRules();
    private static final Map<String, Action> ACTIONS;
    private Map<Block, Action> rules;
    private Map<IBlockState, ElevatorOverride> overrides;

    private ElevatorBlockRules() {
    }

    private Map<Block, Action> getRules() {
        if (this.rules == null) {
            this.rules = Maps.newIdentityHashMap();
            for (String entry : Config.elevatorRules) {
                try {
                    ElevatorBlockRules.tryAddRule(this.rules, entry);
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Invalid entry in elevator actions: %s", (Object[])new Object[]{entry});
                }
            }
        }
        return this.rules;
    }

    private static void tryAddRule(Map<Block, Action> rules, String entry) {
        String[] parts = entry.split(":");
        if (parts.length == 0) {
            return;
        }
        Preconditions.checkState((parts.length == 3 ? 1 : 0) != 0, (Object)"Each entry must have exactly 3 colon-separated fields");
        String modId = parts[0];
        String blockName = parts[1];
        String actionName = parts[2].toLowerCase(Locale.ENGLISH);
        Action action = ACTIONS.get(actionName);
        Preconditions.checkNotNull((Object)((Object)action), (String)"Unknown action: %s", (Object[])new Object[]{actionName});
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modId, blockName));
        if (block != Blocks.field_150350_a) {
            rules.put(block, action);
        } else {
            Log.warn((String)"Can't find block %s", (Object[])new Object[]{entry});
        }
    }

    private Map<IBlockState, ElevatorOverride> getOverrides() {
        if (this.overrides == null) {
            this.overrides = Maps.newIdentityHashMap();
            for (String entry : Config.elevatorOverrides) {
                try {
                    ElevatorBlockRules.tryAddOverride(this.overrides, entry);
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Invalid entry in elevator overrides: %s", (Object[])new Object[]{entry});
                }
            }
        }
        return this.overrides;
    }

    private static void tryAddOverride(Map<IBlockState, ElevatorOverride> overrides, String entry) {
        EnumDyeColor color;
        List parts = Splitter.on((char)';').splitToList((CharSequence)entry);
        if (parts.size() == 0) {
            return;
        }
        Preconditions.checkState((parts.size() == 1 || parts.size() == 2 ? 1 : 0) != 0, (Object)"Each entry be either 'blockState' or 'blockState=color'");
        List<IBlockState> blockStates = ElevatorBlockRules.parseBlockDesc((String)parts.get(0));
        if (parts.size() == 2) {
            ColorMeta colorMeta = ColorMeta.fromName((String)((String)parts.get(1)));
            color = colorMeta.vanillaEnum;
        } else {
            color = EnumDyeColor.WHITE;
        }
        for (IBlockState state : blockStates) {
            overrides.put(state, new ElevatorOverride(color, IElevatorBlock.PlayerRotation.NONE));
        }
    }

    private static List<IBlockState> parseBlockDesc(String blockDesc) {
        List blockDescParts = Splitter.on((char)'#').splitToList((CharSequence)blockDesc);
        String blockId = (String)blockDescParts.get(0);
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockId));
        if (block == Blocks.field_150350_a) {
            Log.warn((String)"Can't find block %s", (Object[])new Object[]{blockId});
            return Collections.emptyList();
        }
        if (blockDescParts.size() == 1) {
            return block.func_176194_O().func_177619_a();
        }
        String stateDesc = (String)blockDescParts.get(1);
        return ElevatorBlockRules.decodeState(block, stateDesc);
    }

    private static List<IBlockState> decodeState(Block block, String stateDesc) {
        int meta = Integer.parseInt(stateDesc);
        return ImmutableList.of((Object)block.func_176203_a(meta));
    }

    @SubscribeEvent
    public void onReconfig(ConfigurationChange.Post evt) {
        if (evt.check("dropblock", "specialBlockRules")) {
            this.rules = null;
        }
        if (evt.check("dropblock", "overrides")) {
            this.overrides = null;
        }
    }

    private static boolean isPassable(IBlockState state) {
        return Config.elevatorIgnoreHalfBlocks && !state.func_185915_l();
    }

    public Action getActionForBlock(IBlockState state) {
        Action action = this.getRules().get(state.func_177230_c());
        if (action != null) {
            return action;
        }
        return ElevatorBlockRules.isPassable(state) ? Action.IGNORE : Action.INCREMENT;
    }

    public void configureEvent(ElevatorCheckEvent evt) {
        Map<IBlockState, ElevatorOverride> overrides = this.getOverrides();
        ElevatorOverride elevatorOverride = overrides.get(evt.getState());
        if (elevatorOverride != null) {
            evt.setColor(elevatorOverride.color);
            evt.setRotation(elevatorOverride.rotation);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Action a : Action.values()) {
            builder.put((Object)a.name().toLowerCase(Locale.ENGLISH), (Object)a);
        }
        ACTIONS = builder.build();
    }

    private static class ElevatorOverride {
        public final EnumDyeColor color;
        public final IElevatorBlock.PlayerRotation rotation;

        public ElevatorOverride(EnumDyeColor color, IElevatorBlock.PlayerRotation rotation) {
            this.color = color;
            this.rotation = rotation;
        }
    }

    public static enum Action {
        IGNORE,
        ABORT,
        INCREMENT;

    }
}

