/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;
import openblocks.OpenBlocks;
import openblocks.common.TrophyHandler;
import openblocks.common.tileentity.TileEntityTrophy;
import openmods.geometry.Orientation;
import openmods.utils.BlockUtils;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class TileEntityTrophyRenderer
extends TileEntitySpecialRenderer<TileEntityTrophy> {
    private static final int INVENTORY_ROTATION = 0;
    private final TrophyHandler.Trophy trophyType;

    public TileEntityTrophyRenderer(TrophyHandler.Trophy trophyType) {
        this.trophyType = trophyType;
    }

    public TileEntityTrophyRenderer() {
        this(null);
    }

    public void renderTileEntityAt(TileEntityTrophy trophy, double x, double y, double z, float partialTick, int destroyProgress) {
        TrophyHandler.Trophy type;
        TrophyHandler.Trophy trophy2 = type = trophy != null ? trophy.getTrophy() : this.trophyType;
        if (type != null) {
            float angle = trophy != null ? BlockUtils.getRotationFromOrientation((Orientation)trophy.getOrientation()) : 0.0f;
            this.renderTrophy(type, x + 0.5, y, z + 0.5, angle);
        }
        if (trophy == null) {
            this.renderStaticPart(x + 0.5, y + 0.5, z + 0.5);
        }
    }

    private void renderStaticPart(double x, double y, double z) {
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        IBlockState state = OpenBlocks.Blocks.trophy.func_176223_P();
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer wr = tessellator.func_178180_c();
        this.func_147499_a(TextureMap.field_110575_b);
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        wr.func_178969_c(x, y, z);
        for (EnumFacing face : EnumFacing.values()) {
            TileEntityTrophyRenderer.renderQuads(wr, model.func_188616_a(state, face, 0L));
        }
        TileEntityTrophyRenderer.renderQuads(wr, model.func_188616_a(state, null, 0L));
        tessellator.func_78381_a();
        wr.func_178969_c(0.0, 0.0, 0.0);
    }

    private static void renderQuads(VertexBuffer wr, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            LightUtil.renderQuadColor((VertexBuffer)wr, (BakedQuad)quad, (int)-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTrophy(TrophyHandler.Trophy type, double x, double y, double z, float angle) {
        Entity entity = type.getEntity();
        if (entity != null) {
            Render renderer;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)(y + type.getVerticalOffset() + 0.2), (double)z);
            GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            double ratio = type.getScale();
            GL11.glScaled((double)ratio, (double)ratio, (double)ratio);
            World renderWorld = RenderUtils.getRenderWorld();
            if (renderWorld != null && (renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity)) != null && renderer.func_76983_a() != null) {
                boolean mipmapLast;
                boolean blurLast;
                AbstractTexture blocksTexture = this.getBlockTexture();
                if (blocksTexture != null) {
                    blurLast = blocksTexture.field_174938_d;
                    mipmapLast = blocksTexture.field_174939_e;
                } else {
                    blurLast = false;
                    mipmapLast = false;
                }
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                boolean lightmapEnabled = GL11.glGetBoolean((int)3553);
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                Entity entity2 = entity;
                synchronized (entity2) {
                    entity.field_70170_p = renderWorld;
                    renderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                    entity.field_70170_p = null;
                }
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                if (lightmapEnabled) {
                    GlStateManager.func_179098_w();
                } else {
                    GlStateManager.func_179090_x();
                }
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                if (blocksTexture != null) {
                    blocksTexture.field_174939_e = mipmapLast;
                    blocksTexture.field_174938_d = blurLast;
                }
            }
            GL11.glPopMatrix();
        }
    }

    private AbstractTexture getBlockTexture() {
        ITextureObject texture;
        TextureManager texturemanager = this.field_147501_a.field_147553_e;
        if (texturemanager != null && (texture = texturemanager.func_110581_b(TextureMap.field_110575_b)) instanceof AbstractTexture) {
            return (AbstractTexture)texture;
        }
        return null;
    }
}

