/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import openblocks.client.renderer.SkyBlockRenderer;
import openblocks.common.block.BlockSky;
import openblocks.common.tileentity.TileEntitySky;
import org.lwjgl.opengl.GL11;

public class TileEntitySkyRenderer
extends TileEntitySpecialRenderer<TileEntitySky> {
    private static BlockRendererDispatcher blockRenderer;

    public void renderTileEntityAt(TileEntitySky te, double x, double y, double z, float partialTickTime, int destroyStage) {
        boolean stencilActive;
        BlockPos pos = te.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)te.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        if (!(state.func_177230_c() instanceof BlockSky) || !BlockSky.isActive(state)) {
            return;
        }
        SkyBlockRenderer.INSTANCE.incrementUsers();
        int stencilMask = SkyBlockRenderer.INSTANCE.getStencilMask();
        boolean bl = stencilActive = stencilMask >= 0 && SkyBlockRenderer.INSTANCE.hasSkyTexture();
        if (stencilActive) {
            GL11.glEnable((int)2960);
            GL11.glStencilMask((int)stencilMask);
            GL11.glClearStencil((int)0);
            GL11.glClear((int)1024);
            GL11.glStencilFunc((int)519, (int)stencilMask, (int)stencilMask);
            GL11.glStencilOp((int)7680, (int)7680, (int)7681);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        this.renderModel(x, y, z, pos, (IBlockAccess)world, state);
        if (stencilActive) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glStencilFunc((int)514, (int)stencilMask, (int)stencilMask);
            GL11.glStencilOp((int)7680, (int)7680, (int)7680);
            SkyBlockRenderer.INSTANCE.renderSkyTexture();
            GL11.glDisable((int)2960);
        }
    }

    private void renderModel(double x, double y, double z, BlockPos pos, IBlockAccess world, IBlockState state) {
        this.func_147499_a(TextureMap.field_110575_b);
        if (blockRenderer == null) {
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        renderer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
        blockRenderer.func_175019_b().func_178267_a(world, model, state, pos, renderer, false);
        tessellator.func_78381_a();
        renderer.func_178969_c(0.0, 0.0, 0.0);
    }
}

